/*
 * Decompiled with CFR 0.152.
 */
package sidplay.ini;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import libsidutils.ZipFileUtils;
import libsidutils.siddatabase.TimeConverter;

public class IniReader {
    private static final Pattern COMMENT = Pattern.compile("[;#].*");
    private static final Pattern SECTION_HEADING = Pattern.compile("\\[(\\w+)\\]");
    private static final Pattern KEY_VALUE = Pattern.compile("(\\w+(?:\\s+\\w+)*)\\s*=\\s*(.*)");
    private final Map<String, Map<String, String>> sections = new LinkedHashMap<String, Map<String, String>>();
    private boolean dirty;

    public final boolean isDirty() {
        return this.dirty;
    }

    public IniReader(String pathname) throws IOException {
        this(new FileReader(pathname));
    }

    public IniReader(InputStream input) throws IOException {
        this(new InputStreamReader(input));
    }

    public IniReader(Reader input) throws IOException {
        this.initialize(new BufferedReader(input));
    }

    public final String[] listSections() {
        return this.sections.keySet().toArray(new String[0]);
    }

    public final String[] sectionProperties(String section) {
        Map<String, String> properties = this.sections.get(section);
        return properties.keySet().toArray(new String[0]);
    }

    private void initialize(BufferedReader r) throws IOException {
        String line;
        LinkedHashMap<String, String> section = null;
        StringBuilder comment = new StringBuilder();
        while ((line = r.readLine()) != null) {
            if ((line = line.trim()).isEmpty()) continue;
            Matcher m = COMMENT.matcher(line);
            if (m.matches()) {
                comment.append(line);
                comment.append(System.getProperty("line.separator"));
                continue;
            }
            m = SECTION_HEADING.matcher(line);
            if (m.matches()) {
                section = new LinkedHashMap<String, String>();
                this.sections.put(m.group(1), section);
                if (comment.length() == 0) continue;
                section.put("_", comment.toString());
                comment.delete(0, comment.length());
                continue;
            }
            assert (section != null);
            m = KEY_VALUE.matcher(line);
            if (m.matches()) {
                String key = m.group(1);
                section.put(key, m.group(2));
                if (comment.length() == 0) continue;
                section.put("_" + key, comment.toString());
                comment.delete(0, comment.length());
                continue;
            }
            throw new RuntimeException(String.format("Unrecognized line in ini config: %s", line));
        }
    }

    public final void save(String outputname) throws IOException {
        try (PrintWriter wr = new PrintWriter(new File(outputname));){
            for (String section : this.sections.keySet()) {
                Map<String, String> unsaved = this.sections.get(section);
                if (unsaved.isEmpty()) continue;
                if (unsaved.containsKey("_")) {
                    wr.print(unsaved.get("_"));
                }
                if (section.length() <= 0) continue;
                wr.println("[" + section + "]");
                for (String key : unsaved.keySet()) {
                    if (key.startsWith("_")) continue;
                    if (unsaved.containsKey("_" + key)) {
                        wr.print(unsaved.get("_" + key));
                    }
                    wr.println(key + "=" + unsaved.get(key));
                }
                wr.println("");
            }
        }
        this.dirty = false;
    }

    public final String getPropertyString(String section, String key, String defaultValue) {
        String value;
        Map<String, String> map = this.sections.get(section);
        if (map != null && (value = map.get(key)) != null && value.length() > 0) {
            return value;
        }
        return defaultValue;
    }

    public final float[] getPropertyFloats(String section, String key, float[] defaultValue) {
        String s = this.getPropertyString(section, key, null);
        if (s != null) {
            double[] doubles = Arrays.asList(s.split(",")).stream().map(String::trim).mapToDouble(Double::parseDouble).toArray();
            float[] result = new float[doubles.length];
            for (int i = 0; i < doubles.length; ++i) {
                result[i] = (float)doubles[i];
            }
            return result;
        }
        return defaultValue;
    }

    public final float getPropertyFloat(String section, String key, float defaultValue) {
        String s = this.getPropertyString(section, key, null);
        if (s != null) {
            return Float.parseFloat(s);
        }
        return defaultValue;
    }

    public final int[] getPropertyInts(String section, String key, int[] defaultValue) {
        String s = this.getPropertyString(section, key, null);
        if (s != null) {
            return Arrays.asList(s.split(",")).stream().map(String::trim).mapToInt(Integer::parseInt).toArray();
        }
        return defaultValue;
    }

    public final int getPropertyInt(String section, String key, int defaultValue) {
        String s = this.getPropertyString(section, key, null);
        if (s != null && !s.equals("")) {
            return Integer.decode(s);
        }
        return defaultValue;
    }

    public final short getPropertyShort(String section, String key, short defaultValue) {
        String s = this.getPropertyString(section, key, null);
        if (s != null && !s.equals("")) {
            return Short.decode(s);
        }
        return defaultValue;
    }

    public final boolean getPropertyBool(String section, String key, boolean defaultValue) {
        String s = this.getPropertyString(section, key, null);
        if (s != null) {
            return Boolean.valueOf(s);
        }
        return defaultValue;
    }

    public final char getPropertyChar(String section, String key, char defaultValue) {
        String s = this.getPropertyString(section, key, null);
        if (s != null && s.length() > 2 && s.charAt(0) == '\'' && s.charAt(s.length() - 1) == '\'') {
            return s.substring(1, s.length() - 1).toCharArray()[0];
        }
        return defaultValue;
    }

    public final double getPropertyTime(String section, String key, double defaultValue) {
        String s = this.getPropertyString(section, key, null);
        if (s != null) {
            return this.parseTime(s);
        }
        return defaultValue;
    }

    public final File getPropertyFile(String section, String key, File defaultValue) {
        String s = this.getPropertyString(section, key, null);
        if (s != null) {
            return ZipFileUtils.newFile(null, s);
        }
        return defaultValue;
    }

    public final <T extends Enum<T>> T getPropertyEnum(String section, String key, T defaultValue, Class<T> class1) {
        String s = this.getPropertyString(section, key, null);
        if (s != null) {
            try {
                T value = Enum.valueOf(class1, s.toUpperCase(Locale.US));
                return value;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return defaultValue;
    }

    public final void setPropertyArray(String section, String key, Object ... value) {
        StringBuilder valueAsString = new StringBuilder();
        for (int i = 0; i < value.length; ++i) {
            valueAsString.append(value[i]);
            if (i == value.length - 1) continue;
            valueAsString.append(",");
        }
        this.setProperty(section, key, valueAsString);
    }

    public final void setProperty(String section, String key, Object value) {
        Map<String, String> settings = this.sections.get(section);
        if (settings == null) {
            settings = new HashMap<String, String>();
            this.sections.put(section, settings);
        }
        String newValue = value instanceof Character ? "'" + value + "'" : (value instanceof Enum ? ((Enum)value).name() : String.valueOf(value));
        String oldValue = null;
        if (settings.containsKey(key)) {
            oldValue = settings.get(key);
        }
        if (value == null) {
            settings.put(key, "");
            if (oldValue != null && !"".equals(oldValue)) {
                this.dirty = true;
            }
        } else {
            settings.put(key, newValue);
            if (!newValue.equals(oldValue)) {
                this.dirty = true;
            }
        }
    }

    private double parseTime(String time) {
        double seconds = new TimeConverter().fromString(time);
        if (seconds == -1.0) {
            System.err.println("Invalid time, expected mm:ss.SSS (found " + time + ")");
        }
        return seconds;
    }
}

