/*
 * Decompiled with CFR 0.152.
 */
package ui.common;

import java.time.LocalDate;
import java.time.Year;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.control.TextField;

public class TypeTextField
extends TextField {
    private static final String NUMBERS = "[\\-0-9]";
    private static final String FLOATS = "[\\-0-9.,]";
    private static final String LOCAL_DATE = "[\\-0-9]";
    private StringProperty type = new SimpleStringProperty();
    private String pattern;

    public String getType() {
        return (String)this.type.get();
    }

    public void setType(String type2) {
        this.type.set((Object)type2);
        this.setPattern(type2);
    }

    private void setPattern(String type2) {
        if (type2.equals("Long") || type2.equals("Integer") || type2.equals("Short")) {
            this.pattern = "[\\-0-9]";
        } else if (type2.equals("Float")) {
            this.pattern = FLOATS;
        } else if (type2.equals("String")) {
            this.pattern = null;
        } else if (type2.equals("LocalDate")) {
            this.pattern = "[\\-0-9]";
        } else {
            throw new RuntimeException("Unsupported data type: " + type2);
        }
    }

    public void replaceText(int start, int end, String text) {
        if (this.pattern == null || text.isEmpty() || text.matches(this.pattern)) {
            super.replaceText(start, end, text);
        }
    }

    public void replaceSelection(String text) {
        if (this.pattern == null || text.isEmpty() || text.matches(this.pattern)) {
            super.replaceSelection(text);
        }
    }

    public Object getValue() {
        if (((String)this.type.get()).equals("Long")) {
            try {
                return Long.parseLong(this.getText());
            }
            catch (NumberFormatException e) {
                return 0L;
            }
        }
        if (((String)this.type.get()).equals("Integer")) {
            try {
                return Integer.parseInt(this.getText());
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }
        if (((String)this.type.get()).equals("LocalDate")) {
            try {
                return LocalDate.parse(this.getText(), DateTimeFormatter.ISO_DATE);
            }
            catch (Exception e) {
                try {
                    return YearMonth.parse(this.getText());
                }
                catch (Exception e2) {
                    try {
                        return Year.parse(this.getText());
                    }
                    catch (Exception e3) {
                        return null;
                    }
                }
            }
        }
        if (((String)this.type.get()).equals("Short")) {
            try {
                return Short.parseShort(this.getText());
            }
            catch (NumberFormatException e) {
                return (short)0;
            }
        }
        if (((String)this.type.get()).equals("Float")) {
            try {
                return Float.valueOf(Float.parseFloat(this.getText()));
            }
            catch (NumberFormatException e) {
                return Float.valueOf(0.0f);
            }
        }
        return this.getText();
    }

    public void setValue(Object value) {
        this.setText(String.valueOf(value));
    }
}

