/*
 * Decompiled with CFR 0.152.
 */
package ui.common;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javafx.fxml.JavaFXBuilderFactory;
import javafx.util.Builder;
import javafx.util.BuilderFactory;
import sidplay.Player;
import ui.common.C64Window;
import ui.common.UIPart;

final class UIBuilder
implements BuilderFactory {
    private C64Window window;
    private Player player;
    private JavaFXBuilderFactory defaultBuilderFactory = new JavaFXBuilderFactory();

    public UIBuilder(C64Window window, Player player) {
        this.window = window;
        this.player = player;
    }

    public Builder<?> getBuilder(Class<?> type2) {
        if (UIPart.class.isAssignableFrom(type2)) {
            try {
                Constructor<?> constructor = type2.getConstructor(C64Window.class, Player.class);
                return (Builder)constructor.newInstance(this.window, this.player);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new RuntimeException("UIPart implementations require a specific constructor!", e);
            }
        }
        return this.defaultBuilderFactory.getBuilder(type2);
    }
}

