/*
 * Decompiled with CFR 0.152.
 */
package ui.common.download;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.function.Consumer;
import javafx.scene.Scene;
import ui.common.UIUtil;
import ui.common.download.DownloadThread;
import ui.common.download.ProgressListener;
import ui.entities.config.Configuration;

public class MultiDownload {
    private UIUtil util;
    private Configuration cfg;
    private Scene scene;
    private Consumer<File> downloadedFileConsumer;

    public MultiDownload(UIUtil util, Scene scene, Consumer<File> downloadedFileConsumer) {
        this.util = util;
        this.cfg = util.getConfig();
        this.scene = scene;
        this.downloadedFileConsumer = downloadedFileConsumer;
    }

    public void download(final List<String> urls) {
        try {
            if (urls.size() == 0) {
                return;
            }
            new DownloadThread(this.cfg, new ProgressListener(this.util, this.scene){

                @Override
                public void downloaded(File downloadedFile) {
                    if (urls.size() > 1) {
                        MultiDownload.this.download(urls.subList(1, urls.size()));
                    } else {
                        MultiDownload.this.downloadedFileConsumer.accept(downloadedFile);
                    }
                }
            }, new URI(urls.get(0)).toURL(), true).start();
        }
        catch (MalformedURLException | URISyntaxException e) {
            e.printStackTrace();
        }
    }
}

