/*
 * Decompiled with CFR 0.152.
 */
package ui.diskcollection;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Locale;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TextField;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.stage.DirectoryChooser;
import libsidplay.sidtune.SidTuneError;
import libsidutils.IOUtils;
import net.java.truevfs.access.TFile;
import net.java.truevfs.access.TFileInputStream;
import net.java.truevfs.access.TVFS;
import net.java.truevfs.kernel.spec.FsSyncException;
import sidplay.Player;
import ui.common.C64VBox;
import ui.common.C64Window;
import ui.common.Convenience;
import ui.common.UIPart;
import ui.common.download.DownloadThread;
import ui.common.download.ProgressListener;
import ui.common.filefilter.DiskFileFilter;
import ui.common.filefilter.DocsFileFilter;
import ui.common.filefilter.ScreenshotFileFilter;
import ui.common.filefilter.TapeFileFilter;
import ui.common.filefilter.TuneFileFilter;
import ui.common.util.DesktopUtil;
import ui.directory.Directory;
import ui.diskcollection.DiskCollectionTreeItem;
import ui.diskcollection.DiskCollectionType;
import ui.entities.config.SidPlay2Section;

public class DiskCollection
extends C64VBox
implements UIPart {
    private static final String HVMEC_DATA = "DATA";
    private static final String HVMEC_CONTROL = "CONTROL";
    @FXML
    private CheckBox autoConfiguration;
    @FXML
    private Directory directory;
    @FXML
    private ImageView screenshot;
    @FXML
    private TreeView<File> fileBrowser;
    @FXML
    private ContextMenu contextMenu;
    @FXML
    private MenuItem start;
    @FXML
    private MenuItem attachDisk;
    @FXML
    private TextField collectionDir;
    private Convenience convenience;
    private ObjectProperty<DiskCollectionType> type;
    private String downloadUrl;
    private final FileFilter screenshotsFileFilter = new ScreenshotFileFilter();
    protected final FileFilter diskFileFilter = new DiskFileFilter();
    private final FileFilter fileBrowserFileFilter = new FileFilter(){
        private final TuneFileFilter tuneFileFilter = new TuneFileFilter();
        private final TapeFileFilter tapeFileFilter = new TapeFileFilter();
        private final DocsFileFilter docsFileFilter = new DocsFileFilter();

        @Override
        public boolean accept(File file) {
            if (DiskCollection.this.getType() == DiskCollectionType.HVMEC && file.isDirectory() && file.getName().equals(DiskCollection.HVMEC_CONTROL)) {
                return false;
            }
            return file.getName().toLowerCase(Locale.ENGLISH).endsWith(".zip") || file.getName().toLowerCase(Locale.ENGLISH).endsWith(".gz") || this.tuneFileFilter.accept(file) || DiskCollection.this.diskFileFilter.accept(file) || this.tapeFileFilter.accept(file) || this.docsFileFilter.accept(file);
        }
    };

    public DiskCollectionType getType() {
        return (DiskCollectionType)((Object)this.type.get());
    }

    public void setType(DiskCollectionType type2) {
        this.type.set((Object)type2);
    }

    public DiskCollection() {
    }

    public DiskCollection(C64Window window, Player player) {
        super(window, player);
    }

    @Override
    @FXML
    protected void initialize() {
        this.convenience = new Convenience(this.util.getPlayer());
        this.directory.setPrefHeight(Double.MAX_VALUE);
        this.directory.getAutoStartFileProperty().addListener(observable -> this.attachAndRunDemo((File)((TreeItem)this.fileBrowser.getSelectionModel().getSelectedItem()).getValue(), (String)this.directory.getAutoStartFileProperty().get()));
        this.fileBrowser.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue != null && ((File)newValue.getValue()).isFile()) {
                File file = (File)newValue.getValue();
                this.showScreenshot(file);
                try {
                    this.directory.loadPreview(IOUtils.extract(this.util.getConfig().getSidplay2Section().getTmpDir(), file));
                }
                catch (Exception e) {
                    System.err.println(String.format("Cannot insert media file '%s'.", file.getAbsolutePath()));
                }
            }
        });
        this.fileBrowser.setOnKeyPressed(event -> {
            File file;
            TreeItem selectedItem = (TreeItem)this.fileBrowser.getSelectionModel().getSelectedItem();
            if (event.getCode() == KeyCode.ENTER && selectedItem != null && ((File)selectedItem.getValue()).isFile() && (file = (File)selectedItem.getValue()).isFile()) {
                this.attachAndRunDemo((File)selectedItem.getValue(), null);
            }
        });
        this.fileBrowser.setOnMousePressed(event -> {
            TreeItem selectedItem = (TreeItem)this.fileBrowser.getSelectionModel().getSelectedItem();
            if (selectedItem != null && ((File)selectedItem.getValue()).isFile() && event.isPrimaryButtonDown() && event.getClickCount() > 1) {
                this.attachAndRunDemo((File)((TreeItem)this.fileBrowser.getSelectionModel().getSelectedItem()).getValue(), null);
            }
        });
        this.contextMenu.setOnShown(event -> {
            TreeItem selectedItem = (TreeItem)this.fileBrowser.getSelectionModel().getSelectedItem();
            boolean disable = selectedItem == null || !((File)selectedItem.getValue()).isFile();
            this.start.setDisable(disable);
            this.attachDisk.setDisable(disable);
        });
        this.type = new SimpleObjectProperty();
        this.type.addListener((observable, oldValue, newValue) -> Platform.runLater(() -> {
            File initialRoot;
            switch (this.getType()) {
                case HVMEC: {
                    this.downloadUrl = this.util.getConfig().getOnlineSection().getHvmecUrl();
                    initialRoot = this.util.getConfig().getSidplay2Section().getHVMEC();
                    break;
                }
                case DEMOS: {
                    this.downloadUrl = this.util.getConfig().getOnlineSection().getDemosUrl();
                    initialRoot = this.util.getConfig().getSidplay2Section().getDemos();
                    break;
                }
                case MAGS: {
                    this.downloadUrl = this.util.getConfig().getOnlineSection().getMagazinesUrl();
                    initialRoot = this.util.getConfig().getSidplay2Section().getMags();
                    break;
                }
                default: {
                    throw new RuntimeException("Illegal disk collection type : " + this.type);
                }
            }
            if (initialRoot != null) {
                this.setRootFile(initialRoot);
            }
        }));
    }

    @Override
    public void doClose() {
        if (this.fileBrowser.getRoot() != null && this.fileBrowser.getRoot().getValue() instanceof TFile) {
            TFile tf = (TFile)this.fileBrowser.getRoot().getValue();
            try {
                TVFS.umount((TFile)tf);
            }
            catch (FsSyncException e) {
                e.printStackTrace();
            }
        }
    }

    @FXML
    private void doAutoConfiguration() {
        if (this.autoConfiguration.isSelected()) {
            this.autoConfiguration.setDisable(true);
            try {
                DownloadThread downloadThread = new DownloadThread(this.util.getConfig(), new ProgressListener(this.util, this.fileBrowser.getScene()){

                    @Override
                    public void downloaded(File downloadedFile) {
                        Platform.runLater(() -> {
                            DiskCollection.this.autoConfiguration.setDisable(false);
                            if (downloadedFile != null) {
                                DiskCollection.this.setRootFile(downloadedFile);
                            }
                        });
                    }
                }, new URI(this.downloadUrl).toURL(), true);
                downloadThread.start();
            }
            catch (MalformedURLException | URISyntaxException e2) {
                e2.printStackTrace();
            }
        }
    }

    @FXML
    private void attachDisk() {
        File file = (File)((TreeItem)this.fileBrowser.getSelectionModel().getSelectedItem()).getValue();
        try {
            File extractedFile = IOUtils.extract(this.util.getConfig().getSidplay2Section().getTmpDir(), file);
            this.util.getPlayer().insertDisk(extractedFile);
        }
        catch (IOException e) {
            System.err.println(String.format("Cannot insert media file '%s'.", file.getAbsolutePath()));
        }
    }

    @FXML
    private void start() {
        this.attachAndRunDemo((File)((TreeItem)this.fileBrowser.getSelectionModel().getSelectedItem()).getValue(), null);
    }

    @FXML
    private void doBrowse() {
        DirectoryChooser fileDialog = new DirectoryChooser();
        SidPlay2Section sidplay2 = this.util.getConfig().getSidplay2Section();
        fileDialog.setInitialDirectory(sidplay2.getLastDirectory());
        File directory = fileDialog.showDialog(this.autoConfiguration.getScene().getWindow());
        if (directory != null) {
            sidplay2.setLastDirectory(directory);
            this.setRootFile(directory);
        }
    }

    protected void setRootFile(File rootFile) {
        if (rootFile.exists()) {
            this.collectionDir.setText(rootFile.getAbsolutePath());
            TFile theRootFile = new TFile(rootFile);
            this.fileBrowser.setRoot((TreeItem)new DiskCollectionTreeItem((File)theRootFile, (File)theRootFile, this.fileBrowserFileFilter));
            if (this.getType() == DiskCollectionType.HVMEC) {
                this.util.getConfig().getSidplay2Section().setHVMEC((File)theRootFile);
            } else if (this.getType() == DiskCollectionType.DEMOS) {
                this.util.getConfig().getSidplay2Section().setDemos((File)theRootFile);
            } else if (this.getType() == DiskCollectionType.MAGS) {
                this.util.getConfig().getSidplay2Section().setMags((File)theRootFile);
            }
        }
    }

    protected void attachAndRunDemo(File file, String dirEntry) {
        try {
            File extractedFile = IOUtils.extract(this.util.getConfig().getSidplay2Section().getTmpDir(), file);
            if (file.getName().toLowerCase(Locale.ENGLISH).endsWith(".pdf")) {
                DesktopUtil.open(extractedFile);
            } else if (this.convenience.autostart(extractedFile, Convenience.LEXICALLY_FIRST_MEDIA, dirEntry, true).isSuccess()) {
                this.util.setPlayingTab((Node)this, new ObjectProperty[0]);
            }
        }
        catch (IOException | SidTuneError e) {
            System.err.println(String.format("Cannot insert media file '%s'.", file.getAbsolutePath()));
        }
    }

    protected void showScreenshot(File file) {
        Image image = this.createImage(file);
        if (image != null) {
            this.screenshot.setImage(image);
        }
    }

    private Image createImage(File file) {
        File screenshot = this.findScreenshot(file);
        if (screenshot != null && screenshot.exists()) {
            Image image;
            TFileInputStream is = new TFileInputStream(screenshot);
            try {
                image = new Image((InputStream)is);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            is.close();
            return image;
        }
        return null;
    }

    private File findScreenshot(File file) {
        TreeItem rootItem = this.fileBrowser.getRoot();
        if (rootItem == null) {
            return null;
        }
        String parentPath = this.getType() == DiskCollectionType.HVMEC ? file.getParentFile().getPath().replace(HVMEC_DATA, HVMEC_CONTROL) : file.getParentFile().getPath();
        List<File> parentFiles = IOUtils.getFiles(parentPath, (File)rootItem.getValue(), null);
        if (parentFiles.size() > 0) {
            File parentFile = parentFiles.get(parentFiles.size() - 1);
            File[] listFiles = parentFile.listFiles();
            if (listFiles == null) {
                return null;
            }
            for (File photoFile : listFiles) {
                if (photoFile.isDirectory() || !this.screenshotsFileFilter.accept(photoFile)) continue;
                return photoFile;
            }
        }
        return null;
    }
}

