/*
 * Decompiled with CFR 0.152.
 */
package ui.entities.config;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javax.persistence.CascadeType;
import javax.persistence.Convert;
import javax.persistence.Embeddable;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import libsidplay.common.CPUClock;
import libsidplay.common.ChipModel;
import libsidplay.common.Emulation;
import libsidplay.common.Engine;
import libsidplay.common.SidReads;
import libsidplay.common.Ultimate64Mode;
import libsidplay.config.IEmulationSection;
import server.restful.common.Connectors;
import sidplay.ini.IniDefaults;
import sidplay.ini.converter.BeanToStringConverter;
import sidplay.ini.converter.FileToStringConverter;
import ui.common.converter.FileAttributeConverter;
import ui.common.converter.FileToStringDeserializer;
import ui.common.converter.FileToStringSerializer;
import ui.common.converter.FileXmlAdapter;
import ui.common.properties.LazyListField;
import ui.common.properties.ShadowField;
import ui.entities.config.DeviceMapping;

@Embeddable
@Parameters(resourceBundle="ui.entities.config.EmulationSection")
public class EmulationSection
implements IEmulationSection {
    public static final boolean DEFAULT_DETECT_PSID64_CHIP_MODEL = true;
    public static final Connectors DEFAULT_CONNECTORS = Connectors.HTTP;
    public static final int DEFAULT_APP_SERVER_PORT = 8080;
    public static final int DEFAULT_APP_SERVER_SECURE_PORT = 8443;
    public static final String DEFAULT_ULTIMATE64_STREAMING_TARGET = "127.0.0.1";
    public static final int DEFAULT_ULTIMATE64_STREAMING_AUDIO_PORT = 30000;
    public static final int DEFAULT_ULTIMATE64_STREAMING_VIDEO_PORT = 30001;
    public static final List<DeviceMapping> DEFAULT_SIDBLASTER_DEVICES = IniDefaults.DEFAULT_SIDBLASTER_DEVICE_LIST.stream().map(DeviceMapping::new).collect(Collectors.toList());
    private ShadowField<ObjectProperty<Engine>, Engine> engine = new ShadowField<ObjectProperty, Engine>(SimpleObjectProperty::new, IniDefaults.DEFAULT_ENGINE);
    private ShadowField<ObjectProperty<Emulation>, Emulation> defaultEmulation = new ShadowField<ObjectProperty, Emulation>(SimpleObjectProperty::new, IniDefaults.DEFAULT_EMULATION);
    private ShadowField<ObjectProperty<Emulation>, Emulation> userEmulation = new ShadowField<ObjectProperty, Emulation>(SimpleObjectProperty::new, IniDefaults.DEFAULT_USER_EMULATION);
    private ShadowField<ObjectProperty<Emulation>, Emulation> stereoEmulation = new ShadowField<ObjectProperty, Emulation>(SimpleObjectProperty::new, IniDefaults.DEFAULT_STEREO_EMULATION);
    private ShadowField<ObjectProperty<Emulation>, Emulation> thirdEmulation = new ShadowField<ObjectProperty, Emulation>(SimpleObjectProperty::new, IniDefaults.DEFAULT_3SID_EMULATION);
    private ShadowField<ObjectProperty<CPUClock>, CPUClock> defaultClockSpeed = new ShadowField<ObjectProperty, CPUClock>(SimpleObjectProperty::new, IniDefaults.DEFAULT_CLOCK_SPEED);
    private ShadowField<ObjectProperty<CPUClock>, CPUClock> userClockSpeed = new ShadowField<ObjectProperty, CPUClock>(SimpleObjectProperty::new, IniDefaults.DEFAULT_USER_CLOCK_SPEED);
    private ShadowField<ObjectProperty<ChipModel>, ChipModel> defaultSidModel = new ShadowField<ObjectProperty, ChipModel>(SimpleObjectProperty::new, IniDefaults.DEFAULT_SID_MODEL);
    private ShadowField<ObjectProperty<ChipModel>, ChipModel> userSidModel = new ShadowField<ObjectProperty, ChipModel>(SimpleObjectProperty::new, IniDefaults.DEFAULT_USER_MODEL);
    private ShadowField<ObjectProperty<ChipModel>, ChipModel> stereoSidModel = new ShadowField<ObjectProperty, ChipModel>(SimpleObjectProperty::new, IniDefaults.DEFAULT_STEREO_MODEL);
    private ShadowField<ObjectProperty<ChipModel>, ChipModel> thirdSIDModel = new ShadowField<ObjectProperty, ChipModel>(SimpleObjectProperty::new, IniDefaults.DEFAULT_3SID_MODEL);
    private ShadowField<BooleanProperty, Boolean> detectPSID64ChipModel = new ShadowField<BooleanProperty, Boolean>(SimpleBooleanProperty::new, true);
    private ShadowField<ObjectProperty<Integer>, Integer> hardsid6581 = new ShadowField<ObjectProperty, Integer>(SimpleObjectProperty::new, IniDefaults.DEFAULT_HARD_SID_6581);
    private ShadowField<ObjectProperty<Integer>, Integer> hardsid8580 = new ShadowField<ObjectProperty, Integer>(SimpleObjectProperty::new, IniDefaults.DEFAULT_HARD_SID_8580);
    private LazyListField<DeviceMapping> sidBlasterDeviceList = new LazyListField();
    private ShadowField<ObjectProperty<Integer>, Integer> sidBlasterWriteBufferSize = new ShadowField<ObjectProperty, Integer>(SimpleObjectProperty::new, IniDefaults.DEFAULT_SIDBLASTER_WRITE_BUFFER_SIZE);
    private ShadowField<StringProperty, String> sidBlasterSerialNumber = new ShadowField<StringProperty, String>(SimpleStringProperty::new, IniDefaults.DEFAULT_SIDBLASTER_SERIAL_NUMBER);
    private ShadowField<BooleanProperty, Boolean> sidBlasterRead = new ShadowField<BooleanProperty, Boolean>(SimpleBooleanProperty::new, IniDefaults.DEFAULT_SIDBLASTER_READ);
    private ShadowField<ObjectProperty<Short>, Short> sidBlasterLatencyTimer = new ShadowField<ObjectProperty, Short>(SimpleObjectProperty::new, IniDefaults.DEFAULT_SIDBLASTER_LATENCY_TIMER);
    private ShadowField<BooleanProperty, Boolean> exsidFakeStereo = new ShadowField<BooleanProperty, Boolean>(SimpleBooleanProperty::new, IniDefaults.DEFAULT_EXSID_FAKE_STEREO);
    private ShadowField<StringProperty, String> netSidDevHost = new ShadowField<StringProperty, String>(SimpleStringProperty::new, IniDefaults.DEFAULT_NETSIDDEV_HOST);
    private ShadowField<ObjectProperty<Integer>, Integer> netSidDevPort = new ShadowField<ObjectProperty, Integer>(SimpleObjectProperty::new, IniDefaults.DEFAULT_NETSIDDEV_PORT);
    private ShadowField<ObjectProperty<Ultimate64Mode>, Ultimate64Mode> ultimate64Mode = new ShadowField<ObjectProperty, Ultimate64Mode>(SimpleObjectProperty::new, IniDefaults.DEFAULT_ULTIMATE64_MODE);
    private ShadowField<StringProperty, String> ultimate64Host = new ShadowField<StringProperty, String>(SimpleStringProperty::new, IniDefaults.DEFAULT_ULTIMATE64_HOST);
    private ShadowField<ObjectProperty<Integer>, Integer> ultimate64Port = new ShadowField<ObjectProperty, Integer>(SimpleObjectProperty::new, IniDefaults.DEFAULT_ULTIMATE64_PORT);
    private ShadowField<ObjectProperty<Integer>, Integer> ultimate64SyncDelay = new ShadowField<ObjectProperty, Integer>(SimpleObjectProperty::new, IniDefaults.DEFAULT_ULTIMATE64_SYNC_DELAY);
    private ShadowField<StringProperty, String> ultimate64StreamingTarget = new ShadowField<StringProperty, String>(SimpleStringProperty::new, "127.0.0.1");
    private ShadowField<ObjectProperty<Integer>, Integer> ultimate64StreamingAudioPort = new ShadowField<ObjectProperty, Integer>(SimpleObjectProperty::new, 30000);
    private ShadowField<ObjectProperty<Integer>, Integer> ultimate64StreamingVideoPort = new ShadowField<ObjectProperty, Integer>(SimpleObjectProperty::new, 30001);
    private ShadowField<ObjectProperty<Connectors>, Connectors> appServerConnectors = new ShadowField<ObjectProperty, Connectors>(SimpleObjectProperty::new, DEFAULT_CONNECTORS);
    private ShadowField<ObjectProperty<Integer>, Integer> appServerPort = new ShadowField<ObjectProperty, Integer>(SimpleObjectProperty::new, 8080);
    private ShadowField<ObjectProperty<Integer>, Integer> appServerSecurePort = new ShadowField<ObjectProperty, Integer>(SimpleObjectProperty::new, 8443);
    private ShadowField<ObjectProperty<File>, File> appServerKeystore = new ShadowField<ObjectProperty, Object>(SimpleObjectProperty::new, null);
    private ShadowField<StringProperty, String> appServerKeystorePassword = new ShadowField<StringProperty, Object>(SimpleStringProperty::new, null);
    private ShadowField<StringProperty, String> appServerKeyAlias = new ShadowField<StringProperty, Object>(SimpleStringProperty::new, null);
    private ShadowField<StringProperty, String> appServerKeyPassword = new ShadowField<StringProperty, Object>(SimpleStringProperty::new, null);
    private ShadowField<BooleanProperty, Boolean> filter = new ShadowField<BooleanProperty, Boolean>(SimpleBooleanProperty::new, IniDefaults.DEFAULT_USE_FILTER);
    private ShadowField<BooleanProperty, Boolean> stereoFilter = new ShadowField<BooleanProperty, Boolean>(SimpleBooleanProperty::new, IniDefaults.DEFAULT_USE_STEREO_FILTER);
    private ShadowField<BooleanProperty, Boolean> thirdSIDFilter = new ShadowField<BooleanProperty, Boolean>(SimpleBooleanProperty::new, IniDefaults.DEFAULT_USE_3SID_FILTER);
    private ShadowField<ObjectProperty<SidReads>, SidReads> sidToRead = new ShadowField<ObjectProperty, SidReads>(SimpleObjectProperty::new, IniDefaults.DEFAULT_SID_TO_READ);
    private ShadowField<BooleanProperty, Boolean> digiBoosted8580 = new ShadowField<BooleanProperty, Boolean>(SimpleBooleanProperty::new, IniDefaults.DEFAULT_DIGI_BOOSTED_8580);
    private ShadowField<BooleanProperty, Boolean> fakeStereo = new ShadowField<BooleanProperty, Boolean>(SimpleBooleanProperty::new, IniDefaults.DEFAULT_FAKE_STEREO);
    private ShadowField<IntegerProperty, Number> dualSidBase = new ShadowField<IntegerProperty, Integer>(number -> new SimpleIntegerProperty(number.intValue()), IniDefaults.DEFAULT_DUAL_SID_BASE);
    private ShadowField<IntegerProperty, Number> thirdSIDBase = new ShadowField<IntegerProperty, Integer>(number -> new SimpleIntegerProperty(number.intValue()), IniDefaults.DEFAULT_THIRD_SID_BASE);
    private ShadowField<BooleanProperty, Boolean> forceStereoTune = new ShadowField<BooleanProperty, Boolean>(SimpleBooleanProperty::new, IniDefaults.DEFAULT_FORCE_STEREO_TUNE);
    private ShadowField<BooleanProperty, Boolean> force3SIDTune = new ShadowField<BooleanProperty, Boolean>(SimpleBooleanProperty::new, IniDefaults.DEFAULT_FORCE_3SID_TUNE);
    private ShadowField<BooleanProperty, Boolean> muteVoice1 = new ShadowField<BooleanProperty, Boolean>(SimpleBooleanProperty::new, IniDefaults.DEFAULT_MUTE_VOICE1);
    private ShadowField<BooleanProperty, Boolean> muteVoice2 = new ShadowField<BooleanProperty, Boolean>(SimpleBooleanProperty::new, IniDefaults.DEFAULT_MUTE_VOICE2);
    private ShadowField<BooleanProperty, Boolean> muteVoice3 = new ShadowField<BooleanProperty, Boolean>(SimpleBooleanProperty::new, IniDefaults.DEFAULT_MUTE_VOICE3);
    private ShadowField<BooleanProperty, Boolean> muteVoice4 = new ShadowField<BooleanProperty, Boolean>(SimpleBooleanProperty::new, IniDefaults.DEFAULT_MUTE_VOICE4);
    private ShadowField<BooleanProperty, Boolean> muteStereoVoice1 = new ShadowField<BooleanProperty, Boolean>(SimpleBooleanProperty::new, IniDefaults.DEFAULT_MUTE_STEREO_VOICE1);
    private ShadowField<BooleanProperty, Boolean> muteStereoVoice2 = new ShadowField<BooleanProperty, Boolean>(SimpleBooleanProperty::new, IniDefaults.DEFAULT_MUTE_STEREO_VOICE2);
    private ShadowField<BooleanProperty, Boolean> muteStereoVoice3 = new ShadowField<BooleanProperty, Boolean>(SimpleBooleanProperty::new, IniDefaults.DEFAULT_MUTE_STEREO_VOICE3);
    private ShadowField<BooleanProperty, Boolean> muteStereoVoice4 = new ShadowField<BooleanProperty, Boolean>(SimpleBooleanProperty::new, IniDefaults.DEFAULT_MUTE_STEREO_VOICE4);
    private ShadowField<BooleanProperty, Boolean> muteThirdSIDVoice1 = new ShadowField<BooleanProperty, Boolean>(SimpleBooleanProperty::new, IniDefaults.DEFAULT_MUTE_THIRDSID_VOICE1);
    private ShadowField<BooleanProperty, Boolean> muteThirdSIDVoice2 = new ShadowField<BooleanProperty, Boolean>(SimpleBooleanProperty::new, IniDefaults.DEFAULT_MUTE_THIRDSID_VOICE2);
    private ShadowField<BooleanProperty, Boolean> muteThirdSIDVoice3 = new ShadowField<BooleanProperty, Boolean>(SimpleBooleanProperty::new, IniDefaults.DEFAULT_MUTE_THIRDSID_VOICE3);
    private ShadowField<BooleanProperty, Boolean> muteThirdSIDVoice4 = new ShadowField<BooleanProperty, Boolean>(SimpleBooleanProperty::new, IniDefaults.DEFAULT_MUTE_THIRDSID_VOICE4);
    private ShadowField<StringProperty, String> netSIDFilter6581 = new ShadowField<StringProperty, String>(SimpleStringProperty::new, IniDefaults.DEFAULT_NETSID_FILTER_6581);
    private ShadowField<StringProperty, String> netSIDStereoFilter6581 = new ShadowField<StringProperty, String>(SimpleStringProperty::new, IniDefaults.DEFAULT_NETSID_STEREO_FILTER_6581);
    private ShadowField<StringProperty, String> netSID3rdSIDFilter6581 = new ShadowField<StringProperty, String>(SimpleStringProperty::new, IniDefaults.DEFAULT_NETSID_3SID_FILTER_6581);
    private ShadowField<StringProperty, String> netSIDFilter8580 = new ShadowField<StringProperty, String>(SimpleStringProperty::new, IniDefaults.DEFAULT_NETSID_FILTER_8580);
    private ShadowField<StringProperty, String> netSIDStereoFilter8580 = new ShadowField<StringProperty, String>(SimpleStringProperty::new, IniDefaults.DEFAULT_NETSID_STEREO_FILTER_8580);
    private ShadowField<StringProperty, String> netSID3rdSIDFilter8580 = new ShadowField<StringProperty, String>(SimpleStringProperty::new, IniDefaults.DEFAULT_NETSID_3SID_FILTER_8580);
    private ShadowField<StringProperty, String> filter6581 = new ShadowField<StringProperty, String>(SimpleStringProperty::new, IniDefaults.DEFAULT_FILTER_6581);
    private ShadowField<StringProperty, String> stereoFilter6581 = new ShadowField<StringProperty, String>(SimpleStringProperty::new, IniDefaults.DEFAULT_STEREO_FILTER_6581);
    private ShadowField<StringProperty, String> thirdSIDFilter6581 = new ShadowField<StringProperty, String>(SimpleStringProperty::new, IniDefaults.DEFAULT_3SID_FILTER_6581);
    private ShadowField<StringProperty, String> filter8580 = new ShadowField<StringProperty, String>(SimpleStringProperty::new, IniDefaults.DEFAULT_FILTER_8580);
    private ShadowField<StringProperty, String> stereoFilter8580 = new ShadowField<StringProperty, String>(SimpleStringProperty::new, IniDefaults.DEFAULT_STEREO_FILTER_8580);
    private ShadowField<StringProperty, String> thirdSIDFilter8580 = new ShadowField<StringProperty, String>(SimpleStringProperty::new, IniDefaults.DEFAULT_3SID_FILTER_8580);
    private ShadowField<StringProperty, String> reSIDfpFilter6581 = new ShadowField<StringProperty, String>(SimpleStringProperty::new, IniDefaults.DEFAULT_ReSIDfp_FILTER_6581);
    private ShadowField<StringProperty, String> reSIDfpStereoFilter6581 = new ShadowField<StringProperty, String>(SimpleStringProperty::new, IniDefaults.DEFAULT_ReSIDfp_STEREO_FILTER_6581);
    private ShadowField<StringProperty, String> reSIDfp3rdSIDFilter6581 = new ShadowField<StringProperty, String>(SimpleStringProperty::new, IniDefaults.DEFAULT_ReSIDfp_3SID_FILTER_6581);
    private ShadowField<StringProperty, String> reSIDfpFilter8580 = new ShadowField<StringProperty, String>(SimpleStringProperty::new, IniDefaults.DEFAULT_ReSIDfp_FILTER_8580);
    private ShadowField<StringProperty, String> reSIDfpStereoFilter8580 = new ShadowField<StringProperty, String>(SimpleStringProperty::new, IniDefaults.DEFAULT_ReSIDfp_STEREO_FILTER_8580);
    private ShadowField<StringProperty, String> reSIDfp3rdSIDFilter8580 = new ShadowField<StringProperty, String>(SimpleStringProperty::new, IniDefaults.DEFAULT_ReSIDfp_3SID_FILTER_8580);
    private IEmulationSection.OverrideSection overrideSection = new IEmulationSection.OverrideSection();

    @Override
    @Enumerated(value=EnumType.STRING)
    public Engine getEngine() {
        return this.engine.get();
    }

    @Override
    public void setEngine(Engine engine) {
        this.engine.set(engine);
    }

    public final ObjectProperty<Engine> engineProperty() {
        return this.engine.property();
    }

    @Override
    @Enumerated(value=EnumType.STRING)
    public Emulation getDefaultEmulation() {
        return this.defaultEmulation.get();
    }

    @Override
    public void setDefaultEmulation(Emulation emulation) {
        this.defaultEmulation.set(emulation);
    }

    public final ObjectProperty<Emulation> defaultEmulationProperty() {
        return this.defaultEmulation.property();
    }

    @Override
    @Enumerated(value=EnumType.STRING)
    public Emulation getUserEmulation() {
        return this.userEmulation.get();
    }

    @Override
    public void setUserEmulation(Emulation userEmulation) {
        this.userEmulation.set(userEmulation);
    }

    public final ObjectProperty<Emulation> userEmulationProperty() {
        return this.userEmulation.property();
    }

    @Override
    @Enumerated(value=EnumType.STRING)
    public Emulation getStereoEmulation() {
        return this.stereoEmulation.get();
    }

    @Override
    public void setStereoEmulation(Emulation stereoEmulation) {
        this.stereoEmulation.set(stereoEmulation);
    }

    public final ObjectProperty<Emulation> stereoEmulationProperty() {
        return this.stereoEmulation.property();
    }

    @Override
    @Enumerated(value=EnumType.STRING)
    public Emulation getThirdEmulation() {
        return this.thirdEmulation.get();
    }

    @Override
    public void setThirdEmulation(Emulation thirdEmulation) {
        this.thirdEmulation.set(thirdEmulation);
    }

    public final ObjectProperty<Emulation> thirdEmulationProperty() {
        return this.thirdEmulation.property();
    }

    @Override
    @Enumerated(value=EnumType.STRING)
    public CPUClock getDefaultClockSpeed() {
        return this.defaultClockSpeed.get();
    }

    @Override
    public void setDefaultClockSpeed(CPUClock speed) {
        this.defaultClockSpeed.set(speed);
    }

    public final ObjectProperty<CPUClock> defaultClockSpeedProperty() {
        return this.defaultClockSpeed.property();
    }

    @Override
    @Enumerated(value=EnumType.STRING)
    public CPUClock getUserClockSpeed() {
        return this.userClockSpeed.get();
    }

    @Override
    public void setUserClockSpeed(CPUClock userClockSpeed) {
        this.userClockSpeed.set(userClockSpeed);
    }

    public final ObjectProperty<CPUClock> userClockSpeedProperty() {
        return this.userClockSpeed.property();
    }

    @Override
    @Enumerated(value=EnumType.STRING)
    public ChipModel getDefaultSidModel() {
        return this.defaultSidModel.get();
    }

    @Override
    public void setDefaultSidModel(ChipModel defaultSidModel) {
        this.defaultSidModel.set(defaultSidModel);
    }

    public final ObjectProperty<ChipModel> defaultSidModelProperty() {
        return this.defaultSidModel.property();
    }

    @Override
    @Enumerated(value=EnumType.STRING)
    public ChipModel getUserSidModel() {
        return this.userSidModel.get();
    }

    @Override
    public void setUserSidModel(ChipModel userSidModel) {
        this.userSidModel.set(userSidModel);
    }

    public final ObjectProperty<ChipModel> userSidModelProperty() {
        return this.userSidModel.property();
    }

    @Override
    @Enumerated(value=EnumType.STRING)
    public ChipModel getStereoSidModel() {
        return this.stereoSidModel.get();
    }

    @Override
    public void setStereoSidModel(ChipModel stereoSidModel) {
        this.stereoSidModel.set(stereoSidModel);
    }

    public final ObjectProperty<ChipModel> stereoSidModelProperty() {
        return this.stereoSidModel.property();
    }

    @Override
    @Enumerated(value=EnumType.STRING)
    public ChipModel getThirdSIDModel() {
        return this.thirdSIDModel.get();
    }

    @Override
    public void setThirdSIDModel(ChipModel stereoSidModel) {
        this.thirdSIDModel.set(stereoSidModel);
    }

    public final ObjectProperty<ChipModel> thirdSIDModelProperty() {
        return this.thirdSIDModel.property();
    }

    @Override
    public boolean isDetectPSID64ChipModel() {
        return this.detectPSID64ChipModel.get();
    }

    @Override
    public void setDetectPSID64ChipModel(boolean detectPSID64ChipModel) {
        this.detectPSID64ChipModel.set(detectPSID64ChipModel);
    }

    public final BooleanProperty detectPSID64ChipModelProperty() {
        return this.detectPSID64ChipModel.property();
    }

    @Override
    public int getHardsid6581() {
        return this.hardsid6581.get();
    }

    @Override
    public void setHardsid6581(int hardsid6581) {
        this.hardsid6581.set(hardsid6581);
    }

    public final ObjectProperty<Integer> hardsid6581Property() {
        return this.hardsid6581.property();
    }

    @Override
    public int getHardsid8580() {
        return this.hardsid8580.get();
    }

    @Override
    public void setHardsid8580(int hardsid8580) {
        this.hardsid8580.set(hardsid8580);
    }

    public final ObjectProperty<Integer> hardsid8580Property() {
        return this.hardsid8580.property();
    }

    @OneToMany(cascade={CascadeType.ALL})
    public List<DeviceMapping> getSidBlasterDeviceList() {
        return this.sidBlasterDeviceList.get(() -> DEFAULT_SIDBLASTER_DEVICES.stream().map(DeviceMapping::new).collect(Collectors.toList()));
    }

    public void setSidBlasterDeviceList(List<DeviceMapping> sidBlasterDeviceList) {
        this.sidBlasterDeviceList.set(sidBlasterDeviceList);
    }

    @Override
    public int getSidBlasterWriteBufferSize() {
        return this.sidBlasterWriteBufferSize.get();
    }

    @Override
    public void setSidBlasterWriteBufferSize(int sidBlasterWriteBufferSize) {
        this.sidBlasterWriteBufferSize.set(sidBlasterWriteBufferSize);
    }

    public final ObjectProperty<Integer> sidBlasterWriteBufferSizeProperty() {
        return this.sidBlasterWriteBufferSize.property();
    }

    @Override
    public String getSidBlasterSerialNumber() {
        return this.sidBlasterSerialNumber.get();
    }

    @Override
    public void setSidBlasterSerialNumber(String sidBlasterSerialNumber) {
        this.sidBlasterSerialNumber.set(sidBlasterSerialNumber);
    }

    public final StringProperty sidBlasterSerialNumberProperty() {
        return this.sidBlasterSerialNumber.property();
    }

    @Override
    public boolean isSidBlasterRead() {
        return this.sidBlasterRead.get();
    }

    @Override
    public void setSidBlasterRead(boolean sidBlasterRead) {
        this.sidBlasterRead.set(sidBlasterRead);
    }

    public final BooleanProperty sidBlasterReadProperty() {
        return this.sidBlasterRead.property();
    }

    @Override
    public short getSidBlasterLatencyTimer() {
        return this.sidBlasterLatencyTimer.get();
    }

    @Override
    public void setSidBlasterLatencyTimer(short sidBlasterLatencyTimer) {
        this.sidBlasterLatencyTimer.set(sidBlasterLatencyTimer);
    }

    public final ObjectProperty<Short> sidBlasterLatencyTimerProperty() {
        return this.sidBlasterLatencyTimer.property();
    }

    @Override
    public boolean isExsidFakeStereo() {
        return this.exsidFakeStereo.get();
    }

    @Override
    public void setExsidFakeStereo(boolean exsidFakeStereo) {
        this.exsidFakeStereo.set(exsidFakeStereo);
    }

    public final BooleanProperty exsidFakeStereoProperty() {
        return this.exsidFakeStereo.property();
    }

    @Override
    public String getNetSIDDevHost() {
        return this.netSidDevHost.get();
    }

    @Override
    public void setNetSIDDevHost(String hostname) {
        this.netSidDevHost.set(hostname);
    }

    public final StringProperty netSidDevHostProperty() {
        return this.netSidDevHost.property();
    }

    @Override
    public int getNetSIDDevPort() {
        return this.netSidDevPort.get();
    }

    @Override
    public void setNetSIDDevPort(int port) {
        this.netSidDevPort.set(port);
    }

    public final ObjectProperty<Integer> netSidDevPortProperty() {
        return this.netSidDevPort.property();
    }

    @Override
    @Enumerated(value=EnumType.STRING)
    public Ultimate64Mode getUltimate64Mode() {
        return this.ultimate64Mode.get();
    }

    @Override
    public void setUltimate64Mode(Ultimate64Mode ultimate64Mode) {
        this.ultimate64Mode.set(ultimate64Mode);
    }

    public final ObjectProperty<Ultimate64Mode> ultimate64ModeProperty() {
        return this.ultimate64Mode.property();
    }

    @Override
    public String getUltimate64Host() {
        return this.ultimate64Host.get();
    }

    @Override
    public void setUltimate64Host(String hostname) {
        this.ultimate64Host.set(hostname);
    }

    public final StringProperty ultimate64HostProperty() {
        return this.ultimate64Host.property();
    }

    @Override
    public int getUltimate64Port() {
        return this.ultimate64Port.get();
    }

    @Override
    public void setUltimate64Port(int port) {
        this.ultimate64Port.set(port);
    }

    public final ObjectProperty<Integer> ultimate64PortProperty() {
        return this.ultimate64Port.property();
    }

    @Override
    public int getUltimate64SyncDelay() {
        return this.ultimate64SyncDelay.get();
    }

    @Override
    public void setUltimate64SyncDelay(int syncDelay) {
        this.ultimate64SyncDelay.set(syncDelay);
    }

    public final ObjectProperty<Integer> ultimate64SyncDelayProperty() {
        return this.ultimate64SyncDelay.property();
    }

    public String getUltimate64StreamingTarget() {
        return this.ultimate64StreamingTarget.get();
    }

    public void setUltimate64StreamingTarget(String ultimate64StreamingTarget) {
        this.ultimate64StreamingTarget.set(ultimate64StreamingTarget);
    }

    public final StringProperty ultimate64StreamingTargetProperty() {
        return this.ultimate64StreamingTarget.property();
    }

    public int getUltimate64StreamingAudioPort() {
        return this.ultimate64StreamingAudioPort.get();
    }

    public void setUltimate64StreamingAudioPort(int ultimate64StreamingAudioPort) {
        this.ultimate64StreamingAudioPort.set(ultimate64StreamingAudioPort);
    }

    public final ObjectProperty<Integer> ultimate64StreamingAudioPortProperty() {
        return this.ultimate64StreamingAudioPort.property();
    }

    public int getUltimate64StreamingVideoPort() {
        return this.ultimate64StreamingVideoPort.get();
    }

    public void setUltimate64StreamingVideoPort(int ultimate64StreamingVideoPort) {
        this.ultimate64StreamingVideoPort.set(ultimate64StreamingVideoPort);
    }

    public final ObjectProperty<Integer> ultimate64StreamingVideoPortProperty() {
        return this.ultimate64StreamingVideoPort.property();
    }

    @Enumerated(value=EnumType.STRING)
    public Connectors getAppServerConnectors() {
        return this.appServerConnectors.get();
    }

    @Parameter(names={"--appServerConnectors"}, descriptionKey="APP_SERVER_CONNECTORS", order=1000)
    public void setAppServerConnectors(Connectors appServerConnectors) {
        this.appServerConnectors.set(appServerConnectors);
    }

    public final ObjectProperty<Connectors> appServerConnectorsProperty() {
        return this.appServerConnectors.property();
    }

    public int getAppServerPort() {
        return this.appServerPort.get();
    }

    @Parameter(names={"--appServerPort"}, descriptionKey="APP_SERVER_PORT", order=1001)
    public void setAppServerPort(int port) {
        this.appServerPort.set(port);
    }

    public final ObjectProperty<Integer> appServerPortProperty() {
        return this.appServerPort.property();
    }

    public int getAppServerSecurePort() {
        return this.appServerSecurePort.get();
    }

    @Parameter(names={"--appServerSecurePort"}, descriptionKey="APP_SERVER_SECURE_PORT", order=1002)
    public void setAppServerSecurePort(int securePort) {
        this.appServerSecurePort.set(securePort);
    }

    public final ObjectProperty<Integer> appServerSecurePortProperty() {
        return this.appServerSecurePort.property();
    }

    @Convert(converter=FileAttributeConverter.class)
    @XmlJavaTypeAdapter(value=FileXmlAdapter.class)
    @JsonSerialize(using=FileToStringSerializer.class)
    @JsonDeserialize(using=FileToStringDeserializer.class)
    public File getAppServerKeystoreFile() {
        return this.appServerKeystore.get();
    }

    @Parameter(names={"--appServerKeystore"}, descriptionKey="APP_SERVER_KEYSTORE", converter=FileToStringConverter.class, order=1003)
    public void setAppServerKeystoreFile(File appServerKeystoreFile) {
        this.appServerKeystore.set(appServerKeystoreFile);
    }

    public final ObjectProperty<File> appServerKeystoreFile() {
        return this.appServerKeystore.property();
    }

    @Transient
    @XmlTransient
    @JsonIgnore
    public final String getAppServerKeystorePassword() {
        return this.appServerKeystorePassword.get();
    }

    @Parameter(names={"--appServerKeystorePassword"}, descriptionKey="APP_SERVER_KEYSTORE_PASSWORD", order=1004)
    public final void setAppServerKeystorePassword(String appServerKeyStorePassword) {
        this.appServerKeystorePassword.set(appServerKeyStorePassword);
    }

    public final StringProperty appServerKeystorePasswordProperty() {
        return this.appServerKeystorePassword.property();
    }

    public String getAppServerKeyAlias() {
        return this.appServerKeyAlias.get();
    }

    @Parameter(names={"--appServerKeyAlias"}, descriptionKey="APP_SERVER_KEY_ALIAS", order=1005)
    public void setAppServerKeyAlias(String appServerKeyAlias) {
        this.appServerKeyAlias.set(appServerKeyAlias);
    }

    public final StringProperty appServerKeyAliasProperty() {
        return this.appServerKeyAlias.property();
    }

    @Transient
    @XmlTransient
    @JsonIgnore
    public final String getAppServerKeyPassword() {
        return this.appServerKeyPassword.get();
    }

    @Parameter(names={"--appServerKeyPassword"}, descriptionKey="APP_SERVER_KEY_PASSWORD", order=1006)
    public final void setAppServerKeyPassword(String appServerKeyPassword) {
        this.appServerKeyPassword.set(appServerKeyPassword);
    }

    public final StringProperty appServerKeyPasswordProperty() {
        return this.appServerKeyPassword.property();
    }

    @Override
    public boolean isFilter() {
        return this.filter.get();
    }

    @Override
    public void setFilter(boolean isFilter) {
        this.filter.set(isFilter);
    }

    public final BooleanProperty filterProperty() {
        return this.filter.property();
    }

    @Override
    public boolean isStereoFilter() {
        return this.stereoFilter.get();
    }

    @Override
    public void setStereoFilter(boolean isFilter) {
        this.stereoFilter.set(isFilter);
    }

    public final BooleanProperty stereoFilterProperty() {
        return this.stereoFilter.property();
    }

    @Override
    public boolean isThirdSIDFilter() {
        return this.thirdSIDFilter.get();
    }

    @Override
    public void setThirdSIDFilter(boolean isFilter) {
        this.thirdSIDFilter.set(isFilter);
    }

    public final BooleanProperty thirdSIDFilterProperty() {
        return this.thirdSIDFilter.property();
    }

    @Override
    @Enumerated(value=EnumType.STRING)
    public SidReads getSidToRead() {
        return this.sidToRead.get();
    }

    @Override
    public void setSidToRead(SidReads engine) {
        this.sidToRead.set(engine);
    }

    public final ObjectProperty<SidReads> sidToReadProperty() {
        return this.sidToRead.property();
    }

    @Override
    public boolean isDigiBoosted8580() {
        return this.digiBoosted8580.get();
    }

    @Override
    public void setDigiBoosted8580(boolean isDigiBoosted8580) {
        this.digiBoosted8580.set(isDigiBoosted8580);
    }

    public final BooleanProperty digiBoosted8580Property() {
        return this.digiBoosted8580.property();
    }

    @Override
    public boolean isFakeStereo() {
        return this.fakeStereo.get();
    }

    @Override
    public void setFakeStereo(boolean fakeStereo) {
        this.fakeStereo.set(fakeStereo);
    }

    public final BooleanProperty fakeStereoProperty() {
        return this.fakeStereo.property();
    }

    @Override
    public int getDualSidBase() {
        return this.dualSidBase.get().intValue();
    }

    @Override
    public void setDualSidBase(int dualSidBase) {
        this.dualSidBase.set(dualSidBase);
    }

    public final IntegerProperty dualSidBaseProperty() {
        return this.dualSidBase.property();
    }

    @Override
    public int getThirdSIDBase() {
        return this.thirdSIDBase.get().intValue();
    }

    @Override
    public void setThirdSIDBase(int dualSidBase) {
        this.thirdSIDBase.set(dualSidBase);
    }

    public final IntegerProperty thirdSIDBaseProperty() {
        return this.thirdSIDBase.property();
    }

    @Override
    public boolean isForceStereoTune() {
        return this.forceStereoTune.get();
    }

    @Override
    public void setForceStereoTune(boolean isForceStereoTune) {
        this.forceStereoTune.set(isForceStereoTune);
    }

    public final BooleanProperty forceStereoTuneProperty() {
        return this.forceStereoTune.property();
    }

    @Override
    public boolean isForce3SIDTune() {
        return this.force3SIDTune.get();
    }

    @Override
    public void setForce3SIDTune(boolean isForceStereoTune) {
        this.force3SIDTune.set(isForceStereoTune);
    }

    public final BooleanProperty force3SIDTuneProperty() {
        return this.force3SIDTune.property();
    }

    @Override
    public boolean isMuteVoice1() {
        return this.muteVoice1.get();
    }

    @Override
    public void setMuteVoice1(boolean mute) {
        this.muteVoice1.set(mute);
    }

    public final BooleanProperty muteVoice1Property() {
        return this.muteVoice1.property();
    }

    @Override
    public boolean isMuteVoice2() {
        return this.muteVoice2.get();
    }

    @Override
    public void setMuteVoice2(boolean mute) {
        this.muteVoice2.set(mute);
    }

    public final BooleanProperty muteVoice2Property() {
        return this.muteVoice2.property();
    }

    @Override
    public boolean isMuteVoice3() {
        return this.muteVoice3.get();
    }

    @Override
    public void setMuteVoice3(boolean mute) {
        this.muteVoice3.set(mute);
    }

    public final BooleanProperty muteVoice3Property() {
        return this.muteVoice3.property();
    }

    @Override
    public boolean isMuteVoice4() {
        return this.muteVoice4.get();
    }

    @Override
    public void setMuteVoice4(boolean mute) {
        this.muteVoice4.set(mute);
    }

    public final BooleanProperty muteVoice4Property() {
        return this.muteVoice4.property();
    }

    @Override
    public boolean isMuteStereoVoice1() {
        return this.muteStereoVoice1.get();
    }

    @Override
    public void setMuteStereoVoice1(boolean mute) {
        this.muteStereoVoice1.set(mute);
    }

    public final BooleanProperty muteStereoVoice1Property() {
        return this.muteStereoVoice1.property();
    }

    @Override
    public boolean isMuteStereoVoice2() {
        return this.muteStereoVoice2.get();
    }

    @Override
    public void setMuteStereoVoice2(boolean mute) {
        this.muteStereoVoice2.set(mute);
    }

    public final BooleanProperty muteStereoVoice2Property() {
        return this.muteStereoVoice2.property();
    }

    @Override
    public boolean isMuteStereoVoice3() {
        return this.muteStereoVoice3.get();
    }

    @Override
    public void setMuteStereoVoice3(boolean mute) {
        this.muteStereoVoice3.set(mute);
    }

    public final BooleanProperty muteStereoVoice3Property() {
        return this.muteStereoVoice3.property();
    }

    @Override
    public boolean isMuteStereoVoice4() {
        return this.muteStereoVoice4.get();
    }

    @Override
    public void setMuteStereoVoice4(boolean mute) {
        this.muteStereoVoice4.set(mute);
    }

    public final BooleanProperty muteStereoVoice4Property() {
        return this.muteStereoVoice4.property();
    }

    @Override
    public boolean isMuteThirdSIDVoice1() {
        return this.muteThirdSIDVoice1.get();
    }

    @Override
    public void setMuteThirdSIDVoice1(boolean mute) {
        this.muteThirdSIDVoice1.set(mute);
    }

    public final BooleanProperty muteThirdSIDVoice1Property() {
        return this.muteThirdSIDVoice1.property();
    }

    @Override
    public boolean isMuteThirdSIDVoice2() {
        return this.muteThirdSIDVoice2.get();
    }

    @Override
    public void setMuteThirdSIDVoice2(boolean mute) {
        this.muteThirdSIDVoice2.set(mute);
    }

    public final BooleanProperty muteThirdSIDVoice2Property() {
        return this.muteThirdSIDVoice2.property();
    }

    @Override
    public boolean isMuteThirdSIDVoice3() {
        return this.muteThirdSIDVoice3.get();
    }

    @Override
    public void setMuteThirdSIDVoice3(boolean mute) {
        this.muteThirdSIDVoice3.set(mute);
    }

    public final BooleanProperty muteThirdSIDVoice3Property() {
        return this.muteThirdSIDVoice3.property();
    }

    @Override
    public boolean isMuteThirdSIDVoice4() {
        return this.muteThirdSIDVoice4.get();
    }

    @Override
    public void setMuteThirdSIDVoice4(boolean mute) {
        this.muteThirdSIDVoice4.set(mute);
    }

    public final BooleanProperty muteThirdSIDVoice4Property() {
        return this.muteThirdSIDVoice4.property();
    }

    @Override
    public String getNetSIDFilter6581() {
        return this.netSIDFilter6581.get();
    }

    @Override
    public void setNetSIDFilter6581(String netSIDFilter6581) {
        this.netSIDFilter6581.set(netSIDFilter6581);
    }

    public final StringProperty netSIDFilter6581Property() {
        return this.netSIDFilter6581.property();
    }

    @Override
    public String getNetSIDStereoFilter6581() {
        return this.netSIDStereoFilter6581.get();
    }

    @Override
    public void setNetSIDStereoFilter6581(String netSIDFilter6581) {
        this.netSIDStereoFilter6581.set(netSIDFilter6581);
    }

    public final StringProperty netSIDStereoFilter6581Property() {
        return this.netSIDStereoFilter6581.property();
    }

    @Override
    public String getNetSIDThirdSIDFilter6581() {
        return this.netSID3rdSIDFilter6581.get();
    }

    @Override
    public void setNetSIDThirdSIDFilter6581(String netSIDFilter6581) {
        this.netSID3rdSIDFilter6581.set(netSIDFilter6581);
    }

    public final StringProperty netSID3rdSIDFilter6581Property() {
        return this.netSID3rdSIDFilter6581.property();
    }

    @Override
    public String getNetSIDFilter8580() {
        return this.netSIDFilter8580.get();
    }

    @Override
    public void setNetSIDFilter8580(String netSIDFilter8580) {
        this.netSIDFilter8580.set(netSIDFilter8580);
    }

    public final StringProperty netSIDFilter8580Property() {
        return this.netSIDFilter8580.property();
    }

    @Override
    public String getNetSIDStereoFilter8580() {
        return this.netSIDStereoFilter8580.get();
    }

    @Override
    public void setNetSIDStereoFilter8580(String netSIDFilter8580) {
        this.netSIDStereoFilter8580.set(netSIDFilter8580);
    }

    public final StringProperty netSIDStereoFilter858Property() {
        return this.netSIDStereoFilter8580.property();
    }

    @Override
    public String getNetSIDThirdSIDFilter8580() {
        return this.netSID3rdSIDFilter8580.get();
    }

    @Override
    public void setNetSIDThirdSIDFilter8580(String netSIDFilter8580) {
        this.netSID3rdSIDFilter8580.set(netSIDFilter8580);
    }

    public final StringProperty netSID3rdSIDFilter8580Property() {
        return this.netSID3rdSIDFilter8580.property();
    }

    @Override
    public String getFilter6581() {
        return this.filter6581.get();
    }

    @Override
    public void setFilter6581(String filter6581) {
        this.filter6581.set(filter6581);
    }

    public final StringProperty filter6581Property() {
        return this.filter6581.property();
    }

    @Override
    public String getStereoFilter6581() {
        return this.stereoFilter6581.get();
    }

    @Override
    public void setStereoFilter6581(String filter6581) {
        this.stereoFilter6581.set(filter6581);
    }

    public final StringProperty stereoFilter6581Property() {
        return this.stereoFilter6581.property();
    }

    @Override
    public String getThirdSIDFilter6581() {
        return this.thirdSIDFilter6581.get();
    }

    @Override
    public void setThirdSIDFilter6581(String filter6581) {
        this.thirdSIDFilter6581.set(filter6581);
    }

    public final StringProperty thirdSIDFilter6581Property() {
        return this.thirdSIDFilter6581.property();
    }

    @Override
    public String getFilter8580() {
        return this.filter8580.get();
    }

    @Override
    public void setFilter8580(String filter8580) {
        this.filter8580.set(filter8580);
    }

    public final StringProperty filter8580Property() {
        return this.filter8580.property();
    }

    @Override
    public String getStereoFilter8580() {
        return this.stereoFilter8580.get();
    }

    @Override
    public void setStereoFilter8580(String filter8580) {
        this.stereoFilter8580.set(filter8580);
    }

    public final StringProperty stereoFilter8580Property() {
        return this.stereoFilter8580.property();
    }

    @Override
    public String getThirdSIDFilter8580() {
        return this.thirdSIDFilter8580.get();
    }

    @Override
    public void setThirdSIDFilter8580(String filter8580) {
        this.thirdSIDFilter8580.set(filter8580);
    }

    public final StringProperty thirdSIDFilter8580Property() {
        return this.thirdSIDFilter8580.property();
    }

    @Override
    public String getReSIDfpFilter6581() {
        return this.reSIDfpFilter6581.get();
    }

    @Override
    public void setReSIDfpFilter6581(String reSIDfpFilter6581) {
        this.reSIDfpFilter6581.set(reSIDfpFilter6581);
    }

    public final StringProperty reSIDfpFilter6581Property() {
        return this.reSIDfpFilter6581.property();
    }

    @Override
    public String getReSIDfpStereoFilter6581() {
        return this.reSIDfpStereoFilter6581.get();
    }

    @Override
    public void setReSIDfpStereoFilter6581(String reSIDfpFilter6581) {
        this.reSIDfpStereoFilter6581.set(reSIDfpFilter6581);
    }

    public final StringProperty reSIDfpStereoFilter6581Property() {
        return this.reSIDfpStereoFilter6581.property();
    }

    @Override
    public String getReSIDfpThirdSIDFilter6581() {
        return this.reSIDfp3rdSIDFilter6581.get();
    }

    @Override
    public void setReSIDfpThirdSIDFilter6581(String reSIDfpFilter6581) {
        this.reSIDfp3rdSIDFilter6581.set(reSIDfpFilter6581);
    }

    public final StringProperty reSIDfp3rdSIDFilter6581Property() {
        return this.reSIDfp3rdSIDFilter6581.property();
    }

    @Override
    public String getReSIDfpFilter8580() {
        return this.reSIDfpFilter8580.get();
    }

    @Override
    public void setReSIDfpFilter8580(String reSIDfpFilter8580) {
        this.reSIDfpFilter8580.set(reSIDfpFilter8580);
    }

    public final StringProperty reSIDfpFilter8580Property() {
        return this.reSIDfpFilter8580.property();
    }

    @Override
    public String getReSIDfpStereoFilter8580() {
        return this.reSIDfpStereoFilter8580.get();
    }

    @Override
    public void setReSIDfpStereoFilter8580(String reSIDfpFilter8580) {
        this.reSIDfpStereoFilter8580.set(reSIDfpFilter8580);
    }

    public final StringProperty reSIDfpStereoFilter858Property() {
        return this.reSIDfpStereoFilter8580.property();
    }

    @Override
    public String getReSIDfpThirdSIDFilter8580() {
        return this.reSIDfp3rdSIDFilter8580.get();
    }

    @Override
    public void setReSIDfpThirdSIDFilter8580(String reSIDfpFilter8580) {
        this.reSIDfp3rdSIDFilter8580.set(reSIDfpFilter8580);
    }

    public final StringProperty reSIDfp3rdSIDFilter8580Property() {
        return this.reSIDfp3rdSIDFilter8580.property();
    }

    @Override
    @Transient
    @XmlTransient
    @JsonIgnore
    public final IEmulationSection.OverrideSection getOverrideSection() {
        return this.overrideSection;
    }

    public final String toString() {
        return BeanToStringConverter.toString(this);
    }
}

