/*
 * Decompiled with CFR 0.152.
 */
package ui.entities.config.service;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import javax.persistence.EntityManager;
import javax.persistence.Persistence;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import libsidutils.IOUtils;
import org.hsqldb.DatabaseManager;
import ui.entities.DatabaseType;
import ui.entities.PersistenceProperties;
import ui.entities.config.Configuration;

public class ConfigService {
    public static final String CONFIG_FILE = "jsidplay2";
    private EntityManager em;
    private final ConfigurationType configurationType;

    public ConfigService(ConfigurationType configurationType) {
        this.configurationType = configurationType;
    }

    public Configuration load() {
        File configPath = this.getConfigPath();
        switch (this.configurationType.ordinal()) {
            case 2: {
                this.em = Persistence.createEntityManagerFactory((String)"configuration-ds", (Map)new PersistenceProperties(DatabaseType.HSQL_FILE, "", "", configPath.getAbsolutePath())).createEntityManager();
                return this.get(configPath);
            }
            case 0: {
                this.em = Persistence.createEntityManagerFactory((String)"configuration-ds", (Map)new PersistenceProperties(DatabaseType.HSQL_MEM, "", "", CONFIG_FILE)).createEntityManager();
                return this.importJson(configPath);
            }
        }
        this.em = Persistence.createEntityManagerFactory((String)"configuration-ds", (Map)new PersistenceProperties(DatabaseType.HSQL_MEM, "", "", CONFIG_FILE)).createEntityManager();
        return this.importXml(configPath);
    }

    public void save(Configuration configuration) {
        this.save(configuration, this.getConfigPath());
    }

    private void save(Configuration configuration, File configPath) {
        switch (this.configurationType.ordinal()) {
            case 2: {
                this.persist(configuration);
                break;
            }
            case 0: {
                this.exportJson(configuration, configPath);
                break;
            }
            default: {
                this.exportXml(configuration, configPath);
            }
        }
    }

    private Configuration get(File configPath) {
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaQuery q = cb.createQuery(Configuration.class);
        Root h = q.from(Configuration.class);
        q.select((Selection)h);
        Optional first = this.em.createQuery(q).getResultList().stream().findFirst();
        if (first.isPresent()) {
            Configuration configuration = (Configuration)first.get();
            if (configuration.getSidplay2Section().getVersion() == 25) {
                return configuration;
            }
            this.remove(configuration);
        }
        return this.create();
    }

    private Configuration create() {
        Configuration configuration = new Configuration();
        configuration.getSidplay2Section().setVersion(25);
        this.persist(configuration);
        return configuration;
    }

    private void remove(Configuration configuration) {
        block2: {
            try {
                this.em.getTransaction().begin();
                this.em.remove((Object)configuration);
                this.em.getTransaction().commit();
            }
            catch (Exception e) {
                e.printStackTrace();
                if (!this.em.getTransaction().isActive()) break block2;
                this.em.getTransaction().rollback();
            }
        }
    }

    private void persist(Configuration config) {
        block2: {
            try {
                this.em.getTransaction().begin();
                this.em.persist((Object)config);
                this.em.getTransaction().commit();
            }
            catch (Exception e) {
                e.printStackTrace();
                if (!this.em.getTransaction().isActive()) break block2;
                this.em.getTransaction().rollback();
            }
        }
    }

    public void close() {
        this.em.close();
        DatabaseManager.closeDatabases((int)2);
    }

    private Configuration importXml(File file) {
        if (file.exists()) {
            try {
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Configuration.class});
                Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
                Object obj = unmarshaller.unmarshal(file);
                if (obj instanceof Configuration) {
                    Configuration detachedConfig = (Configuration)obj;
                    if (detachedConfig.getSidplay2Section().getVersion() == 25) {
                        Configuration mergedConfig = (Configuration)this.em.merge((Object)detachedConfig);
                        this.persist(mergedConfig);
                        return mergedConfig;
                    }
                    this.createBackup(detachedConfig, file);
                }
            }
            catch (JAXBException e) {
                System.err.println(e.getMessage());
            }
        }
        return this.create();
    }

    private Configuration importJson(File file) {
        if (file.exists()) {
            try {
                ObjectMapper objectMapper = new ObjectMapper();
                objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
                Configuration detachedConfig = (Configuration)objectMapper.readValue(file, Configuration.class);
                if (detachedConfig.getSidplay2Section().getVersion() == 25) {
                    Configuration mergedConfig = (Configuration)this.em.merge((Object)detachedConfig);
                    this.persist(mergedConfig);
                    return mergedConfig;
                }
                this.createBackup(detachedConfig, file);
                return detachedConfig;
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
            }
        } else {
            File fileAsXml = new File(IOUtils.getFilenameWithoutSuffix(file.getAbsolutePath()) + ".xml");
            if (fileAsXml.exists()) {
                return this.importXml(fileAsXml);
            }
        }
        return this.create();
    }

    private void exportXml(Configuration configuration, File file) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Configuration.class});
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.marshal((Object)configuration, file);
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
    }

    private void exportJson(Configuration configuration, File file) {
        try {
            new ObjectMapper().writerWithDefaultPrettyPrinter().writeValue(file, (Object)configuration);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private File getConfigPath() {
        for (String s : new String[]{System.getProperty("user.dir"), System.getProperty("user.home")}) {
            File configPlace = new File(s, CONFIG_FILE + this.configurationType.fileExt);
            if (!configPlace.exists()) continue;
            return configPlace;
        }
        return new File(System.getProperty("user.home"), CONFIG_FILE + this.configurationType.fileExt);
    }

    private void createBackup(Configuration configuration, File configPath) {
        File bakFile = new File(configPath.getParentFile(), configPath.getName() + ".bak");
        this.save(configuration, bakFile);
        int currentVersion = configuration.getSidplay2Section().getVersion();
        System.out.println("Configuration file version=" + currentVersion + " is older than expected version=" + 25 + ", a backup has been created: " + bakFile);
    }

    public static enum ConfigurationType {
        JSON(".json"),
        XML(".xml"),
        DATABASE("");

        private String fileExt;

        private ConfigurationType(String fileExt) {
            this.fileExt = fileExt;
        }
    }
}

