/*
 * Decompiled with CFR 0.152.
 */
package ui.joysticksettings;

import libsidplay.components.joystick.IJoystick;
import net.java.games.input.Component;
import net.java.games.input.Controller;

final class JoystickReader
implements IJoystick {
    private static final double DELTA_VALUE = 0.1;
    private static final int POLL_DELAY_IN_MS = 5;
    private Controller controller;
    private Component up;
    private Component down;
    private Component left;
    private Component right;
    private Component fire;
    private long lastPollingTime;
    private byte bits;
    private float upValue;
    private float downValue;
    private float leftValue;
    private float rightValue;
    private float fireValue;

    public JoystickReader(Controller controller, Component up, Component down, Component left, Component right, Component fire, float upValue, float downValue, float leftValue, float rightValue, float fireValue) {
        this.controller = controller;
        this.up = up;
        this.down = down;
        this.left = left;
        this.right = right;
        this.fire = fire;
        this.upValue = upValue;
        this.downValue = downValue;
        this.leftValue = leftValue;
        this.rightValue = rightValue;
        this.fireValue = fireValue;
    }

    @Override
    public byte getValue() {
        if (this.controller == null) {
            return -1;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime > this.lastPollingTime + 5L) {
            this.controller.poll();
            this.lastPollingTime = currentTime;
            this.bits = (byte)-1;
            if (this.up != null && (double)Math.abs(this.up.getPollData() - this.upValue) < 0.1) {
                this.bits = (byte)(this.bits ^ 1);
            }
            if (this.down != null && (double)Math.abs(this.down.getPollData() - this.downValue) < 0.1) {
                this.bits = (byte)(this.bits ^ 2);
            }
            if (this.left != null && (double)Math.abs(this.left.getPollData() - this.leftValue) < 0.1) {
                this.bits = (byte)(this.bits ^ 4);
            }
            if (this.right != null && (double)Math.abs(this.right.getPollData() - this.rightValue) < 0.1) {
                this.bits = (byte)(this.bits ^ 8);
            }
            if (this.fire != null && (double)Math.abs(this.fire.getPollData() - this.fireValue) < 0.1) {
                this.bits = (byte)(this.bits ^ 0x10);
            }
        }
        return this.bits;
    }
}

