/*
 * Decompiled with CFR 0.152.
 */
package ui.oscilloscope;

import java.net.URL;
import java.util.Arrays;
import javafx.fxml.FXML;
import javafx.scene.control.TitledPane;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.PixelFormat;
import javafx.scene.image.WritableImage;
import libsidplay.common.SIDEmu;
import sidplay.Player;
import ui.common.C64VBox;
import ui.common.C64Window;
import ui.common.ImageQueue;
import ui.common.UIPart;
import ui.oscilloscope.GaugeImage;

public class Gauge
extends C64VBox
implements UIPart {
    private static final int ALPHA = -16777216;
    private static final int[] gaugeColors = new int[256];
    private String text;
    private int voice;
    private int width;
    private int height;
    private float[] dataMin = new float[256];
    private float[] dataMax = new float[256];
    private int dataPos = 0;
    private ImageQueue<GaugeImage> imageQueue = new ImageQueue();

    public Gauge() {
    }

    public Gauge(C64Window window, Player player) {
        super(window, player);
    }

    @Override
    @FXML
    protected void initialize() {
        this.width = (int)this.getArea().getFitWidth();
        this.height = (int)this.getArea().getFitHeight();
    }

    @Override
    public String getBundleName() {
        return Gauge.class.getName();
    }

    @Override
    public URL getFxml() {
        return this.getClass().getResource(Gauge.class.getSimpleName() + ".fxml");
    }

    public int getVoice() {
        return this.voice;
    }

    public void setVoice(int voice) {
        this.voice = voice;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    protected void accumulate(float value) {
        if (value < this.dataMin[this.dataPos]) {
            this.dataMin[this.dataPos] = value;
        }
        if (value > this.dataMax[this.dataPos]) {
            this.dataMax[this.dataPos] = value;
        }
    }

    protected void advance() {
        float min = this.dataMin[this.dataPos];
        float max = this.dataMax[this.dataPos];
        this.dataPos = this.dataPos + 1 & this.dataMin.length - 1;
        this.dataMin[this.dataPos] = max;
        this.dataMax[this.dataPos] = min;
    }

    public void reset() {
        Arrays.fill(this.dataMin, 0.0f);
        Arrays.fill(this.dataMax, 0.0f);
        this.dataPos = 0;
        this.imageQueue.clear();
        this.addImage(null);
        this.updateGauge();
    }

    public void updateGauge() {
        GaugeImage gaugeImage = this.imageQueue.pull();
        if (gaugeImage != null) {
            this.getTitledPane().setText(gaugeImage.getText());
            WritableImage image = new WritableImage(this.width, this.height);
            image.getPixelWriter().setPixels(0, 0, this.width, this.height, (PixelFormat)PixelFormat.getIntArgbInstance(), gaugeImage.getPixels(), 0, this.width);
            this.getArea().setImage((Image)image);
        }
    }

    public void addImage(SIDEmu sidemu) {
        int[] pixels = new int[this.width * this.height];
        int shade = 255;
        for (int x = 0; x < this.width; ++x) {
            int intEndPos;
            int intStartPos;
            float endPos;
            int readPos = this.dataPos - this.width + x & this.dataMin.length - 1;
            float startPos = (1.0f - this.dataMax[readPos]) * (float)(this.height - 1);
            if (startPos < 0.0f) {
                startPos = 0.0f;
            }
            if ((endPos = (1.0f - this.dataMin[readPos]) * (float)(this.height - 1)) > (float)(this.height - 1)) {
                endPos = this.height - 1;
            }
            if ((intStartPos = (int)Math.floor(startPos)) == (intEndPos = (int)Math.ceil(endPos))) {
                this.drawPoint(pixels, x, intStartPos, gaugeColors[255]);
                continue;
            }
            float firstPixel = startPos - (float)intStartPos;
            if ((firstPixel = 1.0f - firstPixel) < 0.0f) {
                firstPixel = 0.0f;
            }
            if (firstPixel > 1.0f) {
                firstPixel = 1.0f;
            }
            float lastPixel = (float)intEndPos - endPos;
            if ((lastPixel = 1.0f - lastPixel) < 0.0f) {
                lastPixel = 0.0f;
            }
            if (lastPixel > 1.0f) {
                lastPixel = 1.0f;
            }
            this.drawPoint(pixels, x, intStartPos, gaugeColors[(int)(255.0f * firstPixel)]);
            this.drawPoint(pixels, x, intEndPos, gaugeColors[(int)(255.0f * lastPixel)]);
            if (++intStartPos > --intEndPos) continue;
            this.drawLine(pixels, x, intStartPos, x, intEndPos, gaugeColors[255]);
        }
        this.imageQueue.push(new GaugeImage(pixels, this.text));
    }

    private void drawPoint(int[] pixels, int x, int y, int c) {
        x = Math.min(Math.max(0, x), this.width - 1);
        y = Math.min(Math.max(0, y), this.height - 1);
        pixels[x + this.width * y] = c;
    }

    private void drawLine(int[] pixels, int x1, int y1, int x2, int y2, int c) {
        x1 = Math.min(Math.max(0, x1), this.width - 1);
        x2 = Math.min(Math.max(0, x2), this.width - 1);
        y1 = Math.min(Math.max(0, y1), this.height - 1);
        y2 = Math.min(Math.max(0, y2), this.height - 1);
        int d = 0;
        int dx = Math.abs(x2 - x1);
        int dy = Math.abs(y2 - y1);
        int dx2 = 2 * dx;
        int dy2 = 2 * dy;
        int ix = x1 < x2 ? 1 : -1;
        int iy = y1 < y2 ? 1 : -1;
        int x = x1;
        int y = y1;
        if (dx >= dy) {
            while (true) {
                pixels[x + this.width * y] = c;
                if (x != x2) {
                    x += ix;
                    if ((d += dy2) <= dx) continue;
                    y += iy;
                    d -= dx2;
                    continue;
                }
                break;
            }
        } else {
            while (true) {
                pixels[x + this.width * y] = c;
                if (y == y2) break;
                y += iy;
                if ((d += dx2) <= dy) continue;
                x += ix;
                d -= dy2;
            }
        }
    }

    protected TitledPane getTitledPane() {
        return null;
    }

    protected ImageView getArea() {
        return null;
    }

    @Override
    public void doClose() {
        this.imageQueue.dispose();
    }

    static {
        for (int i = 0; i < gaugeColors.length; ++i) {
            int color = Math.round((float)Math.sqrt((float)i / 255.0f) * 255.0f);
            Gauge.gaugeColors[i] = 0xFF000000 | (color & 0xFF) << 8 | color >> 8;
        }
    }
}

