/*
 * Decompiled with CFR 0.152.
 */
package ui.sidreg;

import libsidplay.common.Event;
import libsidplay.common.EventScheduler;
import libsidplay.common.SIDListener;
import sidplay.audio.sidreg.SidRegWrite;

public abstract class SidRegExtension
implements SIDListener {
    private EventScheduler context;
    private long fTime;

    @Override
    public void write(int addr, byte data) {
        long time = this.context.getTime(Event.Phase.PHI2);
        if (this.fTime == 0L) {
            this.fTime = time;
        }
        long relTime = time - this.fTime;
        this.sidWrite(new SidRegWrite(time, relTime, addr, data));
        this.fTime = time;
    }

    public void init(EventScheduler context) {
        this.clear();
        this.context = context;
        this.fTime = 0L;
    }

    public abstract void clear();

    public abstract void sidWrite(SidRegWrite var1);
}

