/*
 * Decompiled with CFR 0.152.
 */
package ui.videoscreen;

import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Consumer;
import javafx.animation.Animation;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.PauseTransition;
import javafx.animation.SequentialTransition;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.Slider;
import javafx.scene.control.TitledPane;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.PixelFormat;
import javafx.scene.image.WritableImage;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javafx.util.Duration;
import libsidplay.common.CPUClock;
import libsidplay.common.ChipModel;
import libsidplay.common.Event;
import libsidplay.common.EventScheduler;
import libsidplay.components.c1530.Datasette;
import libsidplay.components.c1541.C1541;
import libsidplay.components.c1541.FloppyType;
import libsidplay.components.cart.CartridgeType;
import libsidplay.components.keyboard.KeyTableEntry;
import libsidplay.components.mos656x.VIC;
import libsidplay.sidtune.SidTune;
import libsidplay.sidtune.SidTuneError;
import sidplay.Player;
import sidplay.audio.VideoDriver;
import sidplay.ini.IniDefaults;
import sidplay.player.State;
import ui.common.C64VBox;
import ui.common.C64Window;
import ui.common.ImageQueue;
import ui.common.UIPart;
import ui.common.converter.NumberToStringConverter;
import ui.common.fileextension.CartFileExtensions;
import ui.common.fileextension.DiskFileExtensions;
import ui.common.fileextension.TapeFileExtensions;
import ui.entities.config.EmulationSection;
import ui.entities.config.KeyTableEntity;
import ui.entities.config.SidPlay2Section;
import ui.virtualKeyboard.Keyboard;

public class Video
extends C64VBox
implements UIPart,
VideoDriver {
    public static final String ID = "VIDEO";
    private static final double SCALE_X = 1.2;
    private static final double PAL_SCALE_Y = 1.2;
    private static final double NTSC_SCALE_Y = 1.0;
    private static final int TRANSLATE_Y = 8;
    @FXML
    private TitledPane monitor;
    @FXML
    private ImageView screen;
    @FXML
    private ImageView monitorBorder;
    @FXML
    private ImageView breadbox;
    @FXML
    private ImageView pc64;
    @FXML
    private Slider scaling;
    @FXML
    private Slider brightness;
    @FXML
    private Slider contrast;
    @FXML
    private Slider gamma;
    @FXML
    private Slider saturation;
    @FXML
    private Slider phaseShift;
    @FXML
    private Slider offset;
    @FXML
    private Slider tint;
    @FXML
    private Slider blur;
    @FXML
    private Slider bleed;
    @FXML
    private CheckBox palEmulation;
    @FXML
    private CheckBox applyImmediately;
    @FXML
    private CheckBox showMonitorBorder;
    @FXML
    private Label scalingValue;
    @FXML
    private Label brightnessValue;
    @FXML
    private Label contrastValue;
    @FXML
    private Label gammaValue;
    @FXML
    private Label saturationValue;
    @FXML
    private Label phaseShiftValue;
    @FXML
    private Label offsetValue;
    @FXML
    private Label tintValue;
    @FXML
    private Label blurValue;
    @FXML
    private Label bleedValue;
    @FXML
    private ImageView datasetteOff;
    @FXML
    private ImageView datasetteLoad;
    @FXML
    private ImageView datasetteSave;
    @FXML
    private ImageView c1541Off;
    @FXML
    private ImageView c1541On;
    @FXML
    private ImageView c1541Load;
    @FXML
    private ImageView c1541IIOff;
    @FXML
    private ImageView c1541IIOn;
    @FXML
    private ImageView c1541IILoad;
    @FXML
    private Label tapeName;
    @FXML
    private Label diskName;
    @FXML
    private Label cartridgeName;
    private Keyboard virtualKeyboard;
    private Timeline timer;
    private ImageQueue<Image> imageQueue;
    private static volatile Image currentImage;
    private double scaleY;
    private PauseTransition pauseTransition;
    private SequentialTransition sequentialTransition;
    private PropertyChangeListener stateListener;

    public Video() {
    }

    public Video(C64Window window, Player player) {
        super(window, player);
    }

    @Override
    @FXML
    protected void initialize() {
        SidPlay2Section sidplay2Section = this.util.getConfig().getSidplay2Section();
        EmulationSection emulationSection = this.util.getConfig().getEmulationSection();
        this.stateListener = event -> {
            if (event.getNewValue() == State.START) {
                Platform.runLater(() -> {
                    SidTune tune = this.util.getPlayer().getTune();
                    this.setupVideoScreen(CPUClock.getCPUClock(emulationSection, tune));
                    this.setVisibilityBasedOnChipType(tune);
                });
            }
        };
        this.util.getPlayer().stateProperty().addListener(this.stateListener);
        this.scaling.setLabelFormatter(new NumberToStringConverter(2));
        this.scaling.valueProperty().bindBidirectional((Property)sidplay2Section.videoScalingProperty());
        this.scalingValue.textProperty().bindBidirectional((Property)sidplay2Section.videoScalingProperty(), new NumberToStringConverter(2));
        this.scaling.valueProperty().addListener((observable, oldValue, newValue) -> {
            if (this.applyImmediately.isSelected()) {
                this.updateScaling();
            }
        });
        this.palEmulation.selectedProperty().bindBidirectional((Property)sidplay2Section.palEmulationProperty());
        this.palEmulation.selectedProperty().addListener((observable, oldValue, newValue) -> this.util.getPlayer().configureVICs(vic -> vic.getPalEmulation().setPalEmulationEnable((boolean)newValue)));
        this.brightness.setLabelFormatter(new NumberToStringConverter(2));
        this.brightness.valueProperty().bindBidirectional((Property)sidplay2Section.brightnessProperty());
        this.brightnessValue.textProperty().bindBidirectional((Property)sidplay2Section.brightnessProperty(), new NumberToStringConverter(2));
        this.brightness.valueProperty().addListener((observable, oldValue, newValue) -> this.updateVICChipConfiguration(vic -> vic.getPalEmulation().getPalette().setBrightness(newValue.floatValue()), this.applyImmediately.isSelected()));
        this.contrast.setLabelFormatter(new NumberToStringConverter(2));
        this.contrast.valueProperty().bindBidirectional((Property)sidplay2Section.contrastProperty());
        this.contrastValue.textProperty().bindBidirectional((Property)sidplay2Section.contrastProperty(), new NumberToStringConverter(2));
        this.contrast.valueProperty().addListener((observable, oldValue, newValue) -> this.updateVICChipConfiguration(vic -> vic.getPalEmulation().getPalette().setContrast(newValue.floatValue()), this.applyImmediately.isSelected()));
        this.gamma.setLabelFormatter(new NumberToStringConverter(2));
        this.gamma.valueProperty().bindBidirectional((Property)sidplay2Section.gammaProperty());
        this.gammaValue.textProperty().bindBidirectional((Property)sidplay2Section.gammaProperty(), new NumberToStringConverter(2));
        this.gamma.valueProperty().addListener((observable, oldValue, newValue) -> this.updateVICChipConfiguration(vic -> vic.getPalEmulation().getPalette().setGamma(newValue.floatValue()), this.applyImmediately.isSelected()));
        this.saturation.setLabelFormatter(new NumberToStringConverter(2));
        this.saturation.valueProperty().bindBidirectional((Property)sidplay2Section.saturationProperty());
        this.saturationValue.textProperty().bindBidirectional((Property)sidplay2Section.saturationProperty(), new NumberToStringConverter(2));
        this.saturation.valueProperty().addListener((observable, oldValue, newValue) -> this.updateVICChipConfiguration(vic -> vic.getPalEmulation().getPalette().setSaturation(newValue.floatValue()), this.applyImmediately.isSelected()));
        this.phaseShift.setLabelFormatter(new NumberToStringConverter(2));
        this.phaseShift.valueProperty().bindBidirectional((Property)sidplay2Section.phaseShiftProperty());
        this.phaseShiftValue.textProperty().bindBidirectional((Property)sidplay2Section.phaseShiftProperty(), new NumberToStringConverter(2));
        this.phaseShift.valueProperty().addListener((observable, oldValue, newValue) -> this.updateVICChipConfiguration(vic -> vic.getPalEmulation().getPalette().setPhaseShift(newValue.floatValue()), this.applyImmediately.isSelected()));
        this.offset.setLabelFormatter(new NumberToStringConverter(2));
        this.offset.valueProperty().bindBidirectional((Property)sidplay2Section.offsetProperty());
        this.offsetValue.textProperty().bindBidirectional((Property)sidplay2Section.offsetProperty(), new NumberToStringConverter(2));
        this.offset.valueProperty().addListener((observable, oldValue, newValue) -> this.updateVICChipConfiguration(vic -> vic.getPalEmulation().getPalette().setOffset(newValue.floatValue()), this.applyImmediately.isSelected()));
        this.tint.setLabelFormatter(new NumberToStringConverter(2));
        this.tint.valueProperty().bindBidirectional((Property)sidplay2Section.tintProperty());
        this.tintValue.textProperty().bindBidirectional((Property)sidplay2Section.tintProperty(), new NumberToStringConverter(2));
        this.tint.valueProperty().addListener((observable, oldValue, newValue) -> this.updateVICChipConfiguration(vic -> vic.getPalEmulation().getPalette().setTint(newValue.floatValue()), this.applyImmediately.isSelected()));
        this.blur.setLabelFormatter(new NumberToStringConverter(2));
        this.blur.valueProperty().bindBidirectional((Property)sidplay2Section.blurProperty());
        this.blurValue.textProperty().bindBidirectional((Property)sidplay2Section.blurProperty(), new NumberToStringConverter(2));
        this.blur.valueProperty().addListener((observable, oldValue, newValue) -> this.updateVICChipConfiguration(vic -> vic.getPalEmulation().getPalette().setLuminanceC(newValue.floatValue()), this.applyImmediately.isSelected()));
        this.bleed.setLabelFormatter(new NumberToStringConverter(2));
        this.bleed.valueProperty().bindBidirectional((Property)sidplay2Section.bleedProperty());
        this.bleedValue.textProperty().bindBidirectional((Property)sidplay2Section.bleedProperty(), new NumberToStringConverter(2));
        this.bleed.valueProperty().addListener((observable, oldValue, newValue) -> this.updateVICChipConfiguration(vic -> vic.getPalEmulation().getPalette().setDotCreep(newValue.floatValue()), this.applyImmediately.isSelected()));
        this.showMonitorBorder.selectedProperty().bindBidirectional(sidplay2Section.showMonitorProperty());
        this.pauseTransition = new PauseTransition();
        this.sequentialTransition = new SequentialTransition(new Animation[]{this.pauseTransition});
        this.pauseTransition.setOnFinished(evt -> {
            Image image = this.imageQueue.pull();
            if (image != null) {
                currentImage = image;
                this.screen.setImage(image);
            }
        });
        this.sequentialTransition.setCycleCount(-1);
        this.imageQueue = new ImageQueue();
        SidTune tune = this.util.getPlayer().getTune();
        this.setupVideoScreen(CPUClock.getCPUClock(emulationSection, tune));
        this.setVisibilityBasedOnChipType(tune);
        this.setupKeyboard();
        this.updatePeripheralImages();
        this.sequentialTransition.playFromStart();
    }

    @Override
    public void doClose() {
        this.util.getPlayer().stateProperty().removeListener(this.stateListener);
        this.util.getPlayer().removeVideoDriver(this);
        this.sequentialTransition.stop();
        this.timer.stop();
        this.imageQueue.dispose();
        currentImage = null;
    }

    @FXML
    private void showVirtualKeyboard() {
        this.virtualKeyboard = new Keyboard(this.util.getPlayer());
        this.virtualKeyboard.getStage().initModality(Modality.WINDOW_MODAL);
        this.virtualKeyboard.getStage().initOwner(this.screen.getScene().getWindow());
        this.virtualKeyboard.open();
    }

    @FXML
    private void insertTape() {
        FileChooser fileDialog = new FileChooser();
        fileDialog.setInitialDirectory(this.util.getConfig().getSidplay2Section().getLastDirectory());
        fileDialog.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("C64 Tapes", TapeFileExtensions.EXTENSIONS));
        fileDialog.setTitle(this.util.getBundle().getString("INSERT_TAPE"));
        File file = fileDialog.showOpenDialog(this.screen.getScene().getWindow());
        if (file != null) {
            try {
                this.util.getPlayer().insertTape(file);
            }
            catch (IOException | SidTuneError e) {
                System.err.println(String.format("Cannot insert media file '%s'.", file.getAbsolutePath()));
            }
        }
    }

    @FXML
    private void insertDisk() {
        FileChooser fileDialog = new FileChooser();
        fileDialog.setInitialDirectory(this.util.getConfig().getSidplay2Section().getLastDirectory());
        fileDialog.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("C64 Disks", DiskFileExtensions.EXTENSIONS));
        fileDialog.setTitle(this.util.getBundle().getString("INSERT_DISK"));
        File file = fileDialog.showOpenDialog(this.screen.getScene().getWindow());
        if (file != null) {
            try {
                this.util.getPlayer().insertDisk(file);
            }
            catch (IOException e) {
                System.err.println(String.format("Cannot insert media file '%s'.", file.getAbsolutePath()));
            }
        }
    }

    @FXML
    private void insertCartridge() {
        FileChooser fileDialog = new FileChooser();
        fileDialog.setInitialDirectory(this.util.getConfig().getSidplay2Section().getLastDirectory());
        fileDialog.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("C64 Cartridges", CartFileExtensions.EXTENSIONS));
        fileDialog.setTitle(this.util.getBundle().getString("INSERT_CARTRIDGE"));
        File file = fileDialog.showOpenDialog(this.screen.getScene().getWindow());
        if (file != null) {
            try {
                this.util.getPlayer().insertCartridge(CartridgeType.CRT, file);
                this.util.getPlayer().play(SidTune.RESET);
            }
            catch (IOException e) {
                System.err.println(String.format("Cannot insert media file '%s'.", file.getAbsolutePath()));
            }
        }
    }

    @FXML
    private void apply() {
        this.updateScaling();
        this.util.getPlayer().configureVICs(vic -> vic.getPalEmulation().updatePalette());
    }

    @FXML
    private void showMonitorBorder() {
        this.util.getConfig().getSidplay2Section().setShowMonitor(this.showMonitorBorder.isSelected());
        this.setVisibilityBasedOnChipType(this.util.getPlayer().getTune());
    }

    @FXML
    private void defaultPalette() {
        this.applyImmediately.setSelected(false);
        this.scaling.setValue(1.75);
        this.brightness.setValue((double)IniDefaults.DEFAULT_BRIGHTNESS);
        this.contrast.setValue((double)IniDefaults.DEFAULT_CONTRAST);
        this.gamma.setValue((double)IniDefaults.DEFAULT_GAMMA);
        this.saturation.setValue((double)IniDefaults.DEFAULT_SATURATION);
        this.phaseShift.setValue((double)IniDefaults.DEFAULT_PHASE_SHIFT);
        this.offset.setValue((double)IniDefaults.DEFAULT_OFFSET);
        this.tint.setValue((double)IniDefaults.DEFAULT_TINT);
        this.blur.setValue((double)IniDefaults.DEFAULT_BLUR);
        this.bleed.setValue((double)IniDefaults.DEFAULT_BLEED);
        this.apply();
        this.util.getConfig().getSidplay2Section().setShowMonitor(true);
        this.showMonitorBorder();
        this.applyImmediately.setSelected(true);
    }

    private void setupVideoScreen(CPUClock cpuClock) {
        this.scaleY = cpuClock == CPUClock.PAL ? 1.2 : 1.0;
        this.pauseTransition.setDuration(Duration.millis((double)(1000.0 / cpuClock.getScreenRefresh())));
        this.screen.setFitWidth((double)this.util.getPlayer().getC64().getVIC().getBorderWidth());
        this.screen.setFitHeight((double)this.util.getPlayer().getC64().getVIC().getBorderHeight());
        this.updateScaling();
    }

    private void updateScaling() {
        SidPlay2Section sidplay2Section = this.util.getConfig().getSidplay2Section();
        double scale = sidplay2Section.getVideoScaling();
        for (Node node : Arrays.asList(this.monitorBorder, this.screen, this.breadbox, this.pc64)) {
            node.setScaleX(scale);
            node.setScaleY(scale);
        }
        this.monitorBorder.setScaleX(this.monitorBorder.getScaleX() * 1.2);
        this.monitorBorder.setScaleY(this.monitorBorder.getScaleY() * this.scaleY);
        this.monitorBorder.setTranslateY(8.0 * this.monitorBorder.getScaleY());
    }

    private void setupKeyboard() {
        this.monitor.setOnKeyPressed(event -> {
            event.consume();
            Optional<KeyTableEntry> keyTableEntry = this.util.getConfig().getKeyCodeMap().stream().filter(keyCode -> keyCode.getKeyCodeName().equals(event.getCode().getName())).map(KeyTableEntity::getEntry).findFirst();
            if (event.isShiftDown()) {
                this.pressC64Key(KeyTableEntry.SHIFT_LEFT);
            }
            if (event.isControlDown()) {
                this.pressC64Key(KeyTableEntry.COMMODORE);
            }
            if (keyTableEntry.isPresent()) {
                this.pressC64Key(keyTableEntry.get());
                this.releaseC64Key(keyTableEntry.get());
            }
            if (event.isControlDown()) {
                this.releaseC64Key(KeyTableEntry.COMMODORE);
            }
            if (event.isShiftDown()) {
                this.releaseC64Key(KeyTableEntry.SHIFT_LEFT);
            }
            this.monitor.requestFocus();
        });
    }

    private void pressC64Key(KeyTableEntry key) {
        EventScheduler ctx = this.util.getPlayer().getC64().getEventScheduler();
        ctx.scheduleThreadSafeKeyEvent(Event.of("Virtual Keyboard Key Pressed: " + key.name(), event -> this.util.getPlayer().getC64().getKeyboard().keyPressed(key)));
    }

    private void releaseC64Key(KeyTableEntry key) {
        EventScheduler ctx = this.util.getPlayer().getC64().getEventScheduler();
        ctx.scheduleThreadSafeKeyEvent(Event.of("Virtual Keyboard Key Released: " + key.name(), event -> this.util.getPlayer().getC64().getKeyboard().keyReleased(key)));
    }

    private void updatePeripheralImages() {
        Duration duration = Duration.millis((double)1000.0);
        KeyFrame oneFrame = new KeyFrame(duration, evt -> {
            Datasette.DatasetteStatus datasetteStatus = this.util.getPlayer().getDatasette().getStatus();
            this.tapeName.setText(this.util.getPlayer().getDatasette().getTapeImage().getName());
            switch (datasetteStatus) {
                case OFF: {
                    this.datasetteOff.setVisible(true);
                    for (ImageView imageView : Arrays.asList(this.datasetteLoad, this.datasetteSave)) {
                        imageView.setVisible(false);
                    }
                    break;
                }
                case LOAD: {
                    this.datasetteLoad.setVisible(true);
                    for (ImageView imageView : Arrays.asList(this.datasetteOff, this.datasetteSave)) {
                        imageView.setVisible(false);
                    }
                    break;
                }
                case SAVE: {
                    this.datasetteSave.setVisible(true);
                    for (ImageView imageView : Arrays.asList(this.datasetteOff, this.datasetteLoad)) {
                        imageView.setVisible(false);
                    }
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected datasette status: " + (Object)((Object)datasetteStatus));
                }
            }
            C1541 firstC1541 = this.util.getPlayer().getFloppies()[0];
            this.diskName.setText(firstC1541.getDiskName());
            C1541.FloppyStatus floppyStatus = firstC1541.getStatus();
            switch (floppyStatus) {
                case OFF: {
                    this.c1541Off.setVisible(firstC1541.getFloppyType() == FloppyType.C1541);
                    this.c1541IIOff.setVisible(firstC1541.getFloppyType() == FloppyType.C1541_II);
                    for (ImageView imageView : Arrays.asList(this.c1541On, this.c1541IIOn, this.c1541Load, this.c1541IILoad)) {
                        imageView.setVisible(false);
                    }
                    break;
                }
                case ON: {
                    this.c1541On.setVisible(firstC1541.getFloppyType() == FloppyType.C1541);
                    this.c1541IIOn.setVisible(firstC1541.getFloppyType() == FloppyType.C1541_II);
                    for (ImageView imageView : Arrays.asList(this.c1541Off, this.c1541IIOff, this.c1541Load, this.c1541IILoad)) {
                        imageView.setVisible(false);
                    }
                    break;
                }
                case LOAD: {
                    this.c1541Load.setVisible(firstC1541.getFloppyType() == FloppyType.C1541);
                    this.c1541IILoad.setVisible(firstC1541.getFloppyType() == FloppyType.C1541_II);
                    for (ImageView imageView : Arrays.asList(this.c1541Off, this.c1541IIOff, this.c1541On, this.c1541IIOn)) {
                        imageView.setVisible(false);
                    }
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected floppy status: " + (Object)((Object)floppyStatus));
                }
            }
            this.cartridgeName.setText(this.util.getPlayer().getC64().getCartridge().toString());
        }, new KeyValue[0]);
        this.timer = new Timeline(new KeyFrame[]{oneFrame});
        this.timer.setCycleCount(-1);
        this.timer.playFromStart();
    }

    private void setVisibilityBasedOnChipType(SidTune sidTune) {
        this.util.getPlayer().removeVideoDriver(this);
        EmulationSection emulationSection = this.util.getConfig().getEmulationSection();
        if (sidTune != SidTune.RESET && sidTune.getInfo().getPlayAddr() != 0) {
            this.screen.setVisible(false);
            this.monitorBorder.setVisible(false);
            if (ChipModel.getChipModel(emulationSection, sidTune, 0) == ChipModel.MOS6581) {
                this.breadbox.setVisible(true);
                this.pc64.setVisible(false);
            } else {
                this.pc64.setVisible(true);
                this.breadbox.setVisible(false);
            }
        } else {
            this.breadbox.setVisible(false);
            this.pc64.setVisible(false);
            this.screen.setVisible(true);
            this.monitorBorder.setVisible(this.showMonitorBorder.isSelected());
            this.util.getPlayer().addVideoDriver(this);
        }
    }

    private void updateVICChipConfiguration(Consumer<VIC> action, boolean apply) {
        this.util.getPlayer().configureVICs(action.andThen(vic -> {
            if (apply) {
                this.apply();
            }
        }));
    }

    @Override
    public void accept(VIC vic) {
        WritableImage image = new WritableImage(vic.getBorderWidth(), vic.getBorderHeight());
        image.getPixelWriter().setPixels(0, 0, vic.getBorderWidth(), vic.getBorderHeight(), (PixelFormat)PixelFormat.getByteBgraPreInstance(), vic.getPalEmulation().getPixels().array(), 0, vic.getBorderWidth() << 2);
        this.imageQueue.push((Image)image);
    }

    public static Image getVicImage() {
        return currentImage;
    }
}

