/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.mediatool.demos;

import com.xuggle.mediatool.IMediaWriter;
import com.xuggle.mediatool.ToolFactory;
import com.xuggle.xuggler.IRational;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.util.concurrent.TimeUnit;

public class CaptureScreenToFile {
    private static IRational FRAME_RATE = IRational.make(3, 1);
    private static final int SECONDS_TO_RUN_FOR = 15;

    public static void main(String[] args) {
        try {
            String outFile = args.length > 0 ? args[0] : "output.mp4";
            Robot robot = new Robot();
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Rectangle screenBounds = new Rectangle(toolkit.getScreenSize());
            IMediaWriter writer = ToolFactory.makeWriter(outFile);
            writer.addVideoStream(0, 0, FRAME_RATE, screenBounds.width, screenBounds.height);
            long startTime = System.nanoTime();
            int index = 0;
            while ((double)index < 15.0 * FRAME_RATE.getDouble()) {
                BufferedImage screen = robot.createScreenCapture(screenBounds);
                BufferedImage bgrScreen = CaptureScreenToFile.convertToType(screen, 5);
                writer.encodeVideo(0, bgrScreen, System.nanoTime() - startTime, TimeUnit.NANOSECONDS);
                System.out.println("encoded image: " + index);
                Thread.sleep((long)(1000.0 / FRAME_RATE.getDouble()));
                ++index;
            }
            writer.close();
        }
        catch (Throwable e) {
            System.err.println("an error occurred: " + e.getMessage());
        }
    }

    public static BufferedImage convertToType(BufferedImage sourceImage, int targetType) {
        BufferedImage image;
        if (sourceImage.getType() == targetType) {
            image = sourceImage;
        } else {
            image = new BufferedImage(sourceImage.getWidth(), sourceImage.getHeight(), targetType);
            image.getGraphics().drawImage(sourceImage, 0, 0, null);
        }
        return image;
    }
}

