/*
 * Decompiled with CFR 0.152.
 */
package kickass.parsing.preprocessor.directives;

import java.io.IOException;
import kickass.common.diagnostics.AsmError;
import kickass.parsing.baselang.TokenType;
import kickass.parsing.baselang.tokens.IToken;
import kickass.parsing.baselang.tokenstreams.TokenStreamList;
import kickass.parsing.preprocessor.PreProcessor;
import kickass.parsing.preprocessor.PreprocessorParser;
import kickass.parsing.preprocessor.directives.IPreProcessorDirective;
import kickass.state.EvaluationState;

public class PpdImportIf
implements IPreProcessorDirective {
    private PreProcessor preprocessor;

    public PpdImportIf(PreProcessor preProcessor) {
        this.preprocessor = preProcessor;
    }

    @Override
    public void executeDirective(IToken iToken, TokenStreamList tokenStreamList) throws IOException {
        EvaluationState evaluationState = this.preprocessor.getState();
        TokenStreamList tokenStreamList2 = null;
        try {
            tokenStreamList2 = tokenStreamList.getUntilType(TokenType.StringQuote);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Boolean bl = PreprocessorParser.parse(tokenStreamList2, evaluationState);
        if (bl == null) {
            return;
        }
        IToken iToken2 = tokenStreamList2.getTerminatingToken();
        if (iToken2.getType() != TokenType.StringQuote) {
            evaluationState.diagnosticMgr.add(new AsmError("Filename string expected", iToken.getSourceRange()));
            return;
        }
        IToken iToken3 = tokenStreamList.next();
        if (!iToken3.isEos()) {
            evaluationState.diagnosticMgr.add(new AsmError("Invalid token", iToken3.getSourceRange()));
            return;
        }
        boolean bl2 = evaluationState.preprocessorMgr.isInPassiveState();
        if (bl2) {
            return;
        }
        if (!bl.booleanValue()) {
            return;
        }
        String string = iToken2.getStringValue();
        this.preprocessor.importFile(string, iToken2.getSourceRange());
    }
}

