/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.asmnode.directives;

import java.util.List;
import kickass.common.diagnostics.AsmError;
import kickass.nonasm.tools.tuples.Triple;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.asmnode.AsmNode;
import kickass.pass.asmnode.directives.Directive;
import kickass.pass.asmnode.output.SideEffectOnlyOutput;
import kickass.pass.expressions.expr.ExprNode;
import kickass.pass.sideeffect.SESymbolAssignment;
import kickass.pass.valueholder.ConstantValueHolder;
import kickass.pass.valueholder.IValueHolder;
import kickass.pass.values.NumberValue;
import kickass.pass.values.Value;
import kickass.state.EvaluationState;
import kickass.state.scope.SymbolScope;
import kickass.state.scope.symboltable.ISymbolPageIdx;
import kickass.state.scope.symboltable.SymbolStatus;

public class EnumDirective
extends Directive {
    private boolean evalFinished = false;
    private List<Triple<String, SourceRange, ExprNode>> enumList;
    private ISymbolPageIdx[] symbolPageIdxs;

    public EnumDirective(List<Triple<String, SourceRange, ExprNode>> list, SourceRange sourceRange) {
        super(sourceRange);
        this.enumList = list;
        this.symbolPageIdxs = new ISymbolPageIdx[list.size()];
    }

    private EnumDirective(EnumDirective enumDirective) {
        super(enumDirective.range);
        this.enumList = enumDirective.enumList;
        this.symbolPageIdxs = enumDirective.symbolPageIdxs;
    }

    @Override
    public AsmNode copy() {
        return new EnumDirective(this);
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        SymbolScope symbolScope = evaluationState.scopeMgr.getCurrentScope();
        int n = 0;
        for (Triple<String, SourceRange, ExprNode> triple : this.enumList) {
            String string = triple.getA();
            SourceRange sourceRange = triple.getB();
            if (symbolScope.isDefined(string)) {
                evaluationState.diagnosticMgr.add(new AsmError("The symbol '" + string + "' is already defined", sourceRange));
                ++n;
                continue;
            }
            this.symbolPageIdxs[n++] = symbolScope.define(string, ConstantValueHolder.initializer);
        }
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        int n = 0;
        for (Triple<String, SourceRange, ExprNode> triple : this.enumList) {
            ExprNode exprNode;
            ISymbolPageIdx iSymbolPageIdx;
            if ((iSymbolPageIdx = this.symbolPageIdxs[n++]) != null) {
                iSymbolPageIdx.setStatus(SymbolStatus.defined);
            }
            if ((exprNode = triple.getC()) == null) continue;
            exprNode.executePrepass(evaluationState);
        }
        return this;
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        evaluationState.sideeffectMgr.clearFunctionSideOutput();
        int n = 0;
        int n2 = 0;
        for (Triple<String, SourceRange, ExprNode> triple : this.enumList) {
            Value value;
            ExprNode exprNode = triple.getC();
            ISymbolPageIdx iSymbolPageIdx = this.symbolPageIdxs[n2++];
            if (exprNode == null) {
                value = new NumberValue(n++);
            } else {
                value = exprNode.evaluate(evaluationState);
                if (value.isInvalidOrInvalidContent()) {
                    evaluationState.sideeffectMgr.setInvalidSideEffectsDuringFunctionEvaluation();
                }
            }
            IValueHolder iValueHolder = iSymbolPageIdx.getValueHolder();
            iValueHolder.setWithoutSideEffect(value);
            evaluationState.sideeffectMgr.addSideEffect(new SESymbolAssignment(value, iValueHolder));
        }
        boolean bl = this.evalFinished = !evaluationState.sideeffectMgr.getErrorDuringFunctionEvaluation();
        if (evaluationState.sideeffectMgr.getErrorOrInvalidSideEffectsDuringFunctionEvaluation()) {
            return this;
        }
        return new SideEffectOnlyOutput(evaluationState.sideeffectMgr.getFunctionSideOutput());
    }

    @Override
    public boolean isFinished() {
        return this.evalFinished;
    }
}

