/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.asmnode.directives;

import kickass.common.exceptions.AsmErrorException;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.asmnode.AsmNode;
import kickass.pass.asmnode.directives.AsmDirective;
import kickass.pass.asmnode.output.reciever.IOutputReciever;
import kickass.pass.expressions.expr.ExprNode;
import kickass.pass.values.Value;
import kickass.state.EvaluationState;

public class PseudoPCDirective
extends AsmDirective {
    private ExprNode orgAddressExpr;
    private AsmNode body;
    boolean functionsEvalOk = false;

    public PseudoPCDirective(ExprNode exprNode, AsmNode asmNode, SourceRange sourceRange) {
        super(sourceRange);
        this.orgAddressExpr = exprNode;
        this.body = asmNode;
    }

    @Override
    public AsmNode copy() {
        return new PseudoPCDirective(this.orgAddressExpr, this.body.copy(), this.range);
    }

    @Override
    public boolean isFinished() {
        return this.functionsEvalOk && this.body.isFinished();
    }

    @Override
    public void deliverOutput(IOutputReciever iOutputReciever) {
        this.body.deliverOutput(iOutputReciever);
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        this.body = this.body.executeMetaRegistrations(evaluationState);
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        this.orgAddressExpr.executePrepass(evaluationState);
        this.body = this.body.executePrepass(evaluationState);
        return this;
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        int n;
        evaluationState.sideeffectMgr.clearFunctionSideOutput();
        Value value = this.orgAddressExpr.evaluate(evaluationState);
        if (value.isInvalid()) {
            evaluationState.sideeffectMgr.setErrorDuringFunctionEvaluation(true);
            n = -1;
        } else {
            n = value.getInt(this.range);
            if (n < 0) {
                throw new AsmErrorException("Memory address may not be negative!", this.range);
            }
        }
        this.functionsEvalOk = !evaluationState.sideeffectMgr.getErrorOrInvalidSideEffectsDuringFunctionEvaluation();
        evaluationState.segmentMgr.enterPseudoPcMode(n, this.range);
        this.body = this.body.executePass(evaluationState);
        evaluationState.segmentMgr.exitPseudoPcMode();
        return this;
    }
}

