/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.asmnode.directives;

import java.util.Collections;
import kickass.common.diagnostics.AsmError;
import kickass.common.exceptions.AsmErrorException;
import kickass.parsing.misc.ParameterMap;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.asmnode.AsmNode;
import kickass.pass.asmnode.directives.AsmDirective;
import kickass.pass.asmnode.output.SideEffectOnlyOutput;
import kickass.pass.values.NullValue;
import kickass.state.EvaluationState;
import kickass.state.c64output.C64File;
import kickass.state.c64output.C64FileType;
import kickass.state.segments.Segment;
import kickass.state.segments.SegmentParser;
import kickass.state.segments.resolvers.AfterSegmentStartResolver;
import kickass.state.segments.resolvers.ConstantStartResolver;

public class SegmentDefDirective
extends AsmDirective {
    private boolean isDefOnly;
    private String segmentId;
    private ParameterMap parameters;
    private boolean isFirstExec = true;

    public SegmentDefDirective(boolean bl, String string, ParameterMap parameterMap, SourceRange sourceRange) {
        super(sourceRange);
        this.isDefOnly = bl;
        this.segmentId = string;
        this.parameters = parameterMap != null ? parameterMap : new ParameterMap(sourceRange);
    }

    @Override
    public AsmNode copy() {
        return new SegmentDefDirective(this.isDefOnly, this.segmentId, this.parameters, this.range);
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        SegmentParser.addErrorIfNotExists(this.parameters, Collections.emptySet(), true, evaluationState);
        SegmentParser.addErrorForUnknownParameters(this.parameters, SegmentParser.codeInputParameters, true, evaluationState);
        this.parameters.addErrorsForMutualExclusiveParameres(evaluationState, "start", "startAfter");
        this.parameters.executePrepass(evaluationState);
        return this;
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        evaluationState.sideeffectMgr.clearFunctionSideOutput();
        boolean bl = this.parameters.evaluateAllParameters(evaluationState);
        boolean bl2 = this.parameters.anyInvalidValues(SegmentParser.codeInputParameters);
        if (bl2) {
            throw new AsmErrorException("All segment definition parameters must be valid in first pass", this.range);
        }
        if (this.isFirstExec) {
            Object object;
            boolean bl3;
            Segment segment = SegmentParser.createCodeInputSegment(this.segmentId, this.parameters, this.range, evaluationState);
            if (segment.getOutPrg() != null && !(bl3 = evaluationState.c64OutputMgr.addC64File((C64File)(object = new C64File(segment.getOutPrg(), segment.getName()))))) {
                throw new AsmErrorException("A file called '" + ((C64File)object).getFilename() + "' already exist", this.range);
            }
            if (segment.getOutBin() != null) {
                object = new C64File(segment.getOutBin(), segment.getName());
                ((C64File)object).setType(C64FileType.bin);
                bl3 = evaluationState.c64OutputMgr.addC64File((C64File)object);
                if (!bl3) {
                    throw new AsmErrorException("A file called '" + ((C64File)object).getFilename() + "' already exist", this.range);
                }
            }
            if (!((String)(object = segment.getLoadInto())).isEmpty()) {
                this.loadIntoBaseSegment((String)object, segment, evaluationState);
            }
            segment.initPass();
            evaluationState.segmentMgr.addSegment(segment);
            this.isFirstExec = false;
        }
        return bl ? this : SideEffectOnlyOutput.create(evaluationState.sideeffectMgr.getFunctionSideOutput());
    }

    private void loadIntoBaseSegment(String string, Segment segment, EvaluationState evaluationState) {
        Segment segment2 = evaluationState.segmentMgr.getSegment(string);
        if (segment2 == null) {
            evaluationState.diagnosticMgr.add(new AsmError("Unknown 'loadInto' segment name: " + string, this.range));
            return;
        }
        segment2.addSubSegmentIds(segment.getName());
        Segment segment3 = segment2.getLastLoadedSegment();
        segment2.setLastLoadedSegmant(segment);
        if (segment.getBank() == NullValue.instance) {
            segment.setBank(segment2.getBank());
        }
        if (segment.hasDefaultStartResolver()) {
            if (segment3 == null) {
                segment.setStartResolver(new ConstantStartResolver(segment2.getMin(), segment.getAlign()));
            } else {
                segment.setStartResolver(new AfterSegmentStartResolver(segment3.getName(), segment.getAlign(), this.range, evaluationState));
            }
        }
    }
}

