/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.asmnode.directives;

import kickass.nonasm.c64.CharToPetsciiConverter;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.asmnode.AsmNode;
import kickass.pass.asmnode.directives.AsmDirective;
import kickass.pass.asmnode.output.SideEffectOnlyOutput;
import kickass.pass.expressions.expr.ExprNode;
import kickass.pass.values.Value;
import kickass.state.EvaluationState;
import kickass.state.segments.SegmentMemoryBlock;

public class TextBlockDirective
extends AsmDirective {
    private ExprNode stringExpr;
    private SegmentMemoryBlock.Entry memEntry;

    public TextBlockDirective(ExprNode exprNode, SourceRange sourceRange) {
        super(sourceRange);
        this.stringExpr = exprNode;
    }

    @Override
    public AsmNode copy() {
        return new TextBlockDirective(this.stringExpr, this.range);
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        this.stringExpr.executePrepass(evaluationState);
        return this;
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        if (evaluationState.getPassNo() == 1) {
            this.memEntry = evaluationState.segmentMgr.getCurrentSegment().getCurrentMemoryBlock().createNewEntry();
        }
        evaluationState.sideeffectMgr.clearFunctionSideOutput();
        Value value = this.stringExpr.evaluate(evaluationState);
        if (value.isInvalid()) {
            return this.invalidatePcAndReturnThis(evaluationState);
        }
        String string = value.getString(this.range);
        if (!this.memEntry.isFilled()) {
            byte[] byArray = new byte[string.length()];
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = CharToPetsciiConverter.convertOrChar(string.charAt(i), true);
            }
            this.memEntry.fillEntry(byArray, this.range);
        }
        evaluationState.segmentMgr.increaseMemoryPosition(string.length());
        if (evaluationState.sideeffectMgr.getErrorOrInvalidSideEffectsDuringFunctionEvaluation()) {
            return this;
        }
        return SideEffectOnlyOutput.create(evaluationState.sideeffectMgr.getFunctionSideOutput());
    }
}

