/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.values;

import kickass.nonasm.c64.CharToPetsciiConverter;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.function.Function;
import kickass.pass.function.table.FunctionTable;
import kickass.pass.function.table.StdFunctionTable;
import kickass.pass.values.BooleanValue;
import kickass.pass.values.NumberValue;
import kickass.pass.values.Value;
import kickass.state.EvaluationState;

public class CharValue
extends NumberValue {
    public static Value invalid = new CharValue();
    private char c;
    static FunctionTable functions = new StdFunctionTable((StdFunctionTable)NumberValue.functions);

    public static CharValue encode(char c) {
        double d = Byte.valueOf(CharToPetsciiConverter.convertOrChar(c, true)).doubleValue();
        return new CharValue(c, d);
    }

    private CharValue() {
        super(Double.NaN);
        this.setInvalid();
    }

    public CharValue(char c, double d) {
        super(d);
        this.c = c;
    }

    @Override
    public String getType() {
        return this.isInvalid() ? "Invalid Char" : "Char";
    }

    @Override
    public boolean hasString() {
        return true;
    }

    @Override
    public String getString(SourceRange sourceRange) {
        return this.isInvalid() ? "<<Invalid Char>>" : String.valueOf(this.c);
    }

    @Override
    public FunctionTable getFunctions() {
        return functions;
    }

    static {
        functions.add(new Function("==", 2, BooleanValue.invalid){

            @Override
            public Value execute(Value[] valueArray, EvaluationState evaluationState, SourceRange sourceRange) {
                Value value = valueArray[0];
                Value value2 = valueArray[1];
                if (value2.hasDouble()) {
                    return BooleanValue.get(value.getDouble(sourceRange) == value2.getDouble(sourceRange));
                }
                return BooleanValue.get(value.getString(sourceRange).equals(value2.getString(sourceRange)));
            }
        }, true, null);
        functions.add(new Function("!=", 2, BooleanValue.invalid){

            @Override
            public Value execute(Value[] valueArray, EvaluationState evaluationState, SourceRange sourceRange) {
                Value value = valueArray[0];
                Value value2 = valueArray[1];
                if (value2.hasDouble()) {
                    return BooleanValue.get(value.getDouble(sourceRange) != value2.getDouble(sourceRange));
                }
                return BooleanValue.get(!value.getString(sourceRange).equals(value2.getString(sourceRange)));
            }
        }, true, null);
    }
}

