/*
 * Decompiled with CFR 0.152.
 */
package com.ftdi.handler;

import com.ftdi.AbstractEventNotificationHandler;
import com.ftdi.FTD2XXException;
import com.ftdi.FTDevice;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinNT;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventNotificationHandlerWindows
extends AbstractEventNotificationHandler<WinNT.HANDLE> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventNotificationHandlerWindows.class);
    private static final Kernel32 kernel32 = Kernel32.INSTANCE;

    @Override
    protected void createEventHandle() {
        WinBase.SECURITY_ATTRIBUTES lpEventAttributes = null;
        WinNT.HANDLE hEvent = kernel32.CreateEvent(lpEventAttributes, false, false, "");
        this.setEventHandle(hEvent);
    }

    @Override
    protected void waitForNotificationEvent(FTDevice ftDevice, int eventMask) throws FTD2XXException {
        ftDevice.SetEventNotification(((WinNT.HANDLE)this.eventHandle).getPointer(), eventMask);
        kernel32.WaitForSingleObject((WinNT.HANDLE)this.eventHandle, -1);
    }

    @Override
    protected void closeHandle() {
        LOGGER.info("Close the handle: {}", this.eventHandle);
        if (this.eventHandle != null) {
            kernel32.SetEvent((WinNT.HANDLE)this.eventHandle);
            kernel32.CloseHandle((WinNT.HANDLE)this.eventHandle);
            this.eventHandle = null;
        }
    }

    @Override
    protected void processMessages(byte[] bytes) {
    }
}

