/*
 * Decompiled with CFR 0.152.
 */
package usbsid;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum Command {
    WRITE(0),
    READ(1),
    CYCLED_WRITE(2),
    COMMAND(3),
    PAUSE(10),
    UNPAUSE(11),
    MUTE(12),
    UNMUTE(13),
    RESET_SID(14),
    DISABLE_SID(15),
    ENABLE_SID(16),
    CLEAR_BUS(17),
    CONFIG(18),
    RESET_MCU(19),
    BOOTLOADER(20);

    private int cmd;
    private static final Map<Integer, Command> lookup;

    private Command(int cmd) {
        this.cmd = cmd;
    }

    public int getCommand() {
        return this.cmd;
    }

    public static Command get(int cmd) {
        return lookup.get(cmd);
    }

    static {
        lookup = Collections.unmodifiableMap(Arrays.asList(Command.values()).stream().collect(Collectors.toMap(Command::getCommand, Function.identity())));
    }
}

