/*
 * Decompiled with CFR 0.152.
 */
package kickass.nonasm.c64;

import kickass.common.exceptions.AsmErrorException;
import kickass.parsing.sourcelocation.SourceRange;

public class SidFile {
    private static int POS_HEADER = 0;
    private static int POS_VERSION = 4;
    private static int POS_DATAOFFSET = 6;
    private static int POS_LOADADDR = 8;
    private static int POS_INITADDR = 10;
    private static int POS_PLAYADDR = 12;
    private static int POS_SONGS = 14;
    private static int POS_STARTSONG = 16;
    private static int POS_SPEED = 18;
    private static int POS_NAME = 22;
    private static int POS_AUTHOR = 54;
    private static int POS_COPYRIGHT = 86;
    private static int POS_FLAGS = 118;
    private static int POS_STARTPAGE = 120;
    private static int POS_PAGELENGTH = 121;
    private static String FM_PSID = "PSID";
    private static String FM_RSID = "RSID";
    private byte[] file;
    private byte[] data;
    private int dataOffset;
    private int location;
    private int size;

    public SidFile(byte[] byArray, SourceRange sourceRange) {
        this.file = byArray;
        String string = this.getString(POS_HEADER, 32, byArray);
        if (!string.equals(FM_PSID) && !string.equals(FM_RSID)) {
            throw new AsmErrorException("Unknown sid format : " + string, sourceRange);
        }
        this.dataOffset = this.getInt(POS_DATAOFFSET, 2, byArray);
        this.location = this.getInt(POS_LOADADDR, 2, byArray);
        if (this.location == 0) {
            this.location = (byArray[this.dataOffset] & 0xFF) + 256 * (byArray[this.dataOffset + 1] & 0xFF);
            this.dataOffset += 2;
        }
        this.size = byArray.length - this.dataOffset;
        this.data = new byte[this.size];
        System.arraycopy(byArray, this.dataOffset, this.data, 0, this.size);
    }

    public byte[] getData() {
        return this.data;
    }

    public String getHeader() {
        return this.getString(POS_HEADER, 4, this.file);
    }

    public int getLocation() {
        return this.location;
    }

    public int getVersion() {
        return this.getInt(POS_VERSION, 2, this.file);
    }

    public int getInit() {
        return this.getInt(POS_INITADDR, 2, this.file);
    }

    public int getPlay() {
        return this.getInt(POS_PLAYADDR, 2, this.file);
    }

    public int getSongs() {
        return this.getInt(POS_SONGS, 2, this.file);
    }

    public int getStartSong() {
        return this.getInt(POS_STARTSONG, 2, this.file);
    }

    public int getSpeed() {
        return this.getInt(POS_SPEED, 4, this.file);
    }

    public String getName() {
        return this.getString(POS_NAME, 32, this.file);
    }

    public String getAuthor() {
        return this.getString(POS_AUTHOR, 32, this.file);
    }

    public String getCopyright() {
        return this.getString(POS_COPYRIGHT, 32, this.file);
    }

    public int getSize() {
        return this.size;
    }

    public int getFlags() {
        return this.getVersion() < 2 ? -1 : this.getInt(POS_FLAGS, 2, this.file);
    }

    public int getStartPage() {
        return this.getVersion() < 2 ? -1 : this.getInt(POS_STARTPAGE, 1, this.file);
    }

    public int getPageLength() {
        return this.getVersion() < 2 ? -1 : this.getInt(POS_PAGELENGTH, 1, this.file);
    }

    private int getInt(int n, int n2, byte[] byArray) {
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            if (i > 0) {
                n3 <<= 8;
            }
            n3 += byArray[n + i] & 0xFF;
        }
        return n3;
    }

    private String getString(int n, int n2, byte[] byArray) {
        int n3;
        char[] cArray = new char[n2];
        for (n3 = 0; n3 < n2 && byArray[n + n3] != 0; ++n3) {
            cArray[n3] = (char)byArray[n + n3];
        }
        return String.valueOf(cArray, 0, n3);
    }
}

