/*
 * Decompiled with CFR 0.152.
 */
package kickass.parsing.mainparse.tailparsers;

import java.io.IOException;
import kickass.nonasm.util.functions.Func4;
import kickass.parsing.baselang.TokenType;
import kickass.parsing.baselang.tokens.IToken;
import kickass.parsing.baselang.tokenstreams.ITokenStream;
import kickass.parsing.baselang.tokenstreams.TokenStreamList;
import kickass.parsing.mainparse.tailparsers.ITailParser;
import kickass.parsing.misc.ParameterMap;
import kickass.parsing.script.ExprParser;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.expressions.expr.ExprNode;
import kickass.state.EvaluationState;

public class SegmentTailParser<NODE>
implements ITailParser<NODE> {
    private boolean isDefOnly;
    private Func4<String, ExprNode, ParameterMap, SourceRange, NODE> nodeCreator;

    public SegmentTailParser(boolean bl, Func4<String, ExprNode, ParameterMap, SourceRange, NODE> func4) {
        this.isDefOnly = bl;
        this.nodeCreator = func4;
    }

    @Override
    public NODE parse(IToken iToken, SourceRange sourceRange, ITokenStream iTokenStream, EvaluationState evaluationState) throws IOException {
        TokenStreamList tokenStreamList = iTokenStream.getUntilSemiOrNlSkipWs();
        tokenStreamList.skipWsAndNl();
        IToken iToken2 = tokenStreamList.expectType(TokenType.Id, evaluationState);
        if (iToken2 == null) {
            return null;
        }
        String string = iToken2.getStringValue();
        ParameterMap parameterMap = null;
        tokenStreamList.skipWs();
        IToken iToken3 = tokenStreamList.peek();
        if (iToken3.getType() == TokenType.SquareBracketRange) {
            tokenStreamList.next();
            parameterMap = ExprParser.parseParametersMap(iToken3.getChildStream(), evaluationState, iToken3.getSourceRange());
            if (parameterMap == null) {
                return null;
            }
        }
        tokenStreamList.skipWs();
        IToken iToken4 = tokenStreamList.peek();
        ExprNode exprNode = null;
        if (!this.isDefOnly && !iToken4.isEos() && (exprNode = ExprParser.parse(tokenStreamList, evaluationState)) == null) {
            return null;
        }
        return this.nodeCreator.apply(string, exprNode, parameterMap, sourceRange);
    }
}

