/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.asmnode.directives;

import java.util.List;
import kickass.common.diagnostics.IDiagnostic;
import kickass.common.exceptions.AsmErrorException;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.asmnode.AsmNode;
import kickass.pass.asmnode.directives.AsmDirective;
import kickass.pass.asmnode.output.SideEffectOnlyOutput;
import kickass.pass.expressions.expr.ExprNode;
import kickass.pass.values.Value;
import kickass.state.EvaluationState;

public class AssertErrorDirective
extends AsmDirective {
    private ExprNode testNameExpr;
    private ExprNode expr;
    private List<IDiagnostic> errorsFound = null;
    boolean preparsed = false;

    public AssertErrorDirective(ExprNode exprNode, ExprNode exprNode2, SourceRange sourceRange) {
        super(sourceRange);
        this.testNameExpr = exprNode;
        this.expr = exprNode2;
    }

    @Override
    public AsmNode copy() {
        return new AssertErrorDirective(this.testNameExpr, this.expr, this.range);
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        this.testNameExpr.executePrepass(evaluationState);
        evaluationState.diagnosticMgr.startExpectDiagnosticMode();
        this.expr.executePrepass(evaluationState);
        evaluationState.diagnosticMgr.endExpectDiagnosticMode();
        this.errorsFound = evaluationState.diagnosticMgr.getExpectedErrors();
        return this;
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        evaluationState.sideeffectMgr.clearFunctionSideOutput();
        int n = evaluationState.callStack.getStackSize();
        IDiagnostic iDiagnostic = null;
        if (!this.errorsFound.isEmpty()) {
            iDiagnostic = this.errorsFound.get(0);
        } else {
            try {
                this.expr.evaluate(evaluationState);
            }
            catch (AsmErrorException asmErrorException) {
                iDiagnostic = asmErrorException.getError();
            }
        }
        evaluationState.callStack.popTilDepth(n);
        Value value = this.testNameExpr.evaluate(evaluationState);
        boolean bl = evaluationState.sideeffectMgr.getErrorOrInvalidSideEffectsDuringFunctionEvaluation();
        if (iDiagnostic == null && bl) {
            return this;
        }
        String string = value.getString(this.range);
        String string2 = iDiagnostic != null ? string + " -- OK. | " + iDiagnostic.getMessage() : string + " -- ERROR IN ASSERTION!";
        evaluationState.sideeffectMgr.addTextOutput(string2);
        evaluationState.assertMgr.madeAssert(iDiagnostic == null);
        return new SideEffectOnlyOutput(evaluationState.sideeffectMgr.getFunctionSideOutput());
    }
}

