/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.asmnode.directives;

import java.io.InputStream;
import java.io.OutputStream;
import kickass.common.exceptions.AsmErrorException;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.asmnode.AsmNode;
import kickass.pass.asmnode.directives.AsmDirective;
import kickass.pass.asmnode.output.EmptyOutput;
import kickass.state.EvaluationState;

public class EasterEggDirective
extends AsmDirective {
    public EasterEggDirective(SourceRange sourceRange) {
        super(sourceRange);
    }

    @Override
    public AsmNode copy() {
        return this;
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        return this;
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        String string = "/data/easteregg.prg";
        InputStream inputStream = this.getClass().getResourceAsStream(string);
        if (inputStream == null) {
            throw new AsmErrorException("Can't find the resource " + string, this.range);
        }
        try {
            evaluationState.log.println("Congratulations - You found the easter egg!!");
            String string2 = "easteregg.prg";
            evaluationState.log.println("Writing " + string2);
            OutputStream outputStream = evaluationState.outputMgr.OpenOutputStream(string2, false);
            this.readDecodeAndWriteFile(inputStream, outputStream);
            inputStream.close();
            outputStream.close();
        }
        catch (Exception exception) {
            evaluationState.log.error("Error while writing the easteregg");
            evaluationState.log.error(exception);
        }
        return EmptyOutput.instance;
    }

    private void readDecodeAndWriteFile(InputStream inputStream, OutputStream outputStream) throws Exception {
        int n;
        int n2 = 0;
        while ((n = inputStream.read()) != -1) {
            outputStream.write(n ^ n2 & 0xFF);
            ++n2;
        }
    }
}

