/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.asmnode.directives;

import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.asmnode.AsmNode;
import kickass.pass.asmnode.directives.AsmDirective;
import kickass.pass.asmnode.output.EmptyOutput;
import kickass.pass.values.LabelValue;
import kickass.pass.values.NumberValue;
import kickass.state.EvaluationState;
import kickass.state.scope.SymbolScope;
import kickass.state.scope.symboltable.ISymbolPageIdx;

public class MultiLabelDirective
extends AsmDirective {
    private String name;
    private ISymbolPageIdx symbolIdx;

    public MultiLabelDirective(String string, SourceRange sourceRange) {
        super(sourceRange);
        this.name = string;
    }

    private MultiLabelDirective(MultiLabelDirective multiLabelDirective) {
        super(multiLabelDirective.range);
        this.name = multiLabelDirective.name;
        this.symbolIdx = multiLabelDirective.symbolIdx;
    }

    @Override
    public AsmNode copy() {
        return new MultiLabelDirective(this);
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        SymbolScope symbolScope = evaluationState.scopeMgr.getCurrentScope();
        this.symbolIdx = symbolScope.defineMultiSymbol(this.name, LabelValue.getInitializer(evaluationState));
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        SymbolScope symbolScope = evaluationState.scopeMgr.getCurrentScope();
        symbolScope.increaseMultiSymbolIdx(this.name);
        return this;
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        int n = evaluationState.segmentMgr.getMemoryPosition();
        if (n < 0) {
            return this;
        }
        NumberValue numberValue = new NumberValue(n);
        this.symbolIdx.getValueHolder().setWithoutSideEffect(numberValue);
        evaluationState.setMadeMetaProgress();
        return EmptyOutput.instance;
    }

    @Override
    public String toString() {
        return "MultiLabel(" + this.name + ")";
    }
}

