/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.asmnode.directives;

import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.asmnode.AsmNode;
import kickass.pass.asmnode.directives.Directive;
import kickass.pass.asmnode.output.reciever.IOutputReciever;
import kickass.state.EvaluationState;

public class ZpDirective
extends Directive {
    private AsmNode body;

    public ZpDirective(AsmNode asmNode, SourceRange sourceRange) {
        super(sourceRange);
        this.body = asmNode;
    }

    @Override
    public AsmNode copy() {
        return new ZpDirective(this.body.copy(), this.range);
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        boolean bl = evaluationState.replaceZeropageFlag(true);
        this.body.executeMetaRegistrations(evaluationState);
        evaluationState.setZeropageFlag(bl);
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        boolean bl = evaluationState.replaceZeropageFlag(true);
        this.body.executePrepass(evaluationState);
        evaluationState.setZeropageFlag(bl);
        return this;
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        boolean bl = evaluationState.replaceZeropageFlag(true);
        this.body.executePass(evaluationState);
        evaluationState.setZeropageFlag(bl);
        return this;
    }

    @Override
    public void deliverOutput(IOutputReciever iOutputReciever) {
        this.body.deliverOutput(iOutputReciever);
    }

    @Override
    public boolean isFinished() {
        return this.body.isFinished();
    }
}

