/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.asmnode.output.reciever;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import kickass.common.exceptions.AsmErrorException;
import kickass.common.log.Logger;
import kickass.common.outputmanager.IOutputManager;
import kickass.pass.asmnode.output.reciever.IOutputReciever;
import kickass.pass.asmnode.output.reciever.OutputStreamType;

public class MainOutputReciever
implements IOutputReciever {
    private Map<String, Writer> fileOutStreams = new HashMap<String, Writer>();
    private IOutputManager outputManager;
    private Logger log;

    public MainOutputReciever(IOutputManager iOutputManager, Logger logger) {
        this.log = logger;
        this.outputManager = iOutputManager;
    }

    @Override
    public void addToStream(OutputStreamType outputStreamType, String string, Object object) {
        if (outputStreamType == OutputStreamType.CONSOLE) {
            this.log.println("  " + (String)object);
        } else if (outputStreamType == OutputStreamType.FILE) {
            this.addToFileStream(string, object);
        }
    }

    private void addToFileStream(String string, Object object) {
        Writer writer = this.fileOutStreams.get(string);
        if (writer == null) {
            try {
                OutputStream outputStream = this.outputManager.OpenOutputStream(string, true);
                writer = new OutputStreamWriter(outputStream);
            }
            catch (Exception exception) {
                throw new AsmErrorException("Unable to create the file " + string, null);
            }
            this.fileOutStreams.put(string, writer);
        }
        try {
            writer.write((String)object);
        }
        catch (Exception exception) {
            throw new AsmErrorException("Error while writing to file " + string, null);
        }
    }

    private void closeStreams() {
        for (Writer writer : this.fileOutStreams.values()) {
            try {
                writer.close();
            }
            catch (Exception exception) {}
        }
    }

    public void finish() {
        this.closeStreams();
        if (this.fileOutStreams.isEmpty()) {
            return;
        }
        for (String string : this.fileOutStreams.keySet()) {
            this.log.println("Wrote file: " + string);
        }
    }
}

