/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.expressions.expr;

import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.expressions.expr.ExprNode;
import kickass.pass.expressions.refexpr.IReferenceExpr;
import kickass.pass.expressions.refexpr.ReferenceOperation;
import kickass.pass.function.IFunction;
import kickass.pass.valueholder.IValueHolder;
import kickass.pass.values.NumberValue;
import kickass.pass.values.Value;
import kickass.state.EvaluationState;

public class OperatorRefPlusPlus
extends ExprNode {
    private IReferenceExpr refExpr;

    public OperatorRefPlusPlus(IReferenceExpr iReferenceExpr, SourceRange sourceRange) {
        super(sourceRange);
        this.refExpr = iReferenceExpr;
    }

    @Override
    public void executePrepass(EvaluationState evaluationState) {
        this.refExpr.executePrepass(evaluationState, ReferenceOperation.readAndWrite);
    }

    @Override
    public Value evaluate(EvaluationState evaluationState) {
        IValueHolder iValueHolder = this.refExpr.getValueHolder(evaluationState);
        Value value = iValueHolder.get(evaluationState, this.range);
        if (value.isInvalid()) {
            return value;
        }
        Value[] valueArray = new Value[]{value, NumberValue.one};
        IFunction iFunction = value.getFunctions().getOrError("+", 2, this.range);
        Value value2 = iFunction.execute(valueArray, evaluationState, this.range);
        iValueHolder.set(value2, evaluationState, this.range);
        return value;
    }
}

