/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.expressions.stmt;

import kickass.common.diagnostics.AsmError;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.expressions.expr.ExprNode;
import kickass.pass.expressions.stmt.StmtNode;
import kickass.pass.sideeffect.SESymbolAssignment;
import kickass.pass.valueholder.ConstantValueHolder;
import kickass.pass.valueholder.IValueHolder;
import kickass.pass.values.Value;
import kickass.state.EvaluationState;
import kickass.state.scope.SymbolScope;
import kickass.state.scope.symboltable.ISymbolPageIdx;
import kickass.state.scope.symboltable.SymbolStatus;

public class ConstDeclaration
extends StmtNode {
    private String name;
    private ExprNode expr;
    private boolean isFunctionMode;
    private ISymbolPageIdx symbolPageIdx;

    public ConstDeclaration(String string, ExprNode exprNode, boolean bl, SourceRange sourceRange) {
        super(sourceRange);
        this.name = string;
        this.expr = exprNode;
        this.isFunctionMode = bl;
    }

    public String toString() {
        return "ConstDeclaration";
    }

    @Override
    public void executeMetaRegistrations(EvaluationState evaluationState) {
        boolean bl = this.name.startsWith("@");
        String string = bl ? this.name.substring(1) : this.name;
        SymbolScope symbolScope = evaluationState.scopeMgr.getRootOrCurrentScope(bl);
        if (symbolScope.isDefined(string)) {
            evaluationState.diagnosticMgr.add(new AsmError("The symbol '" + this.name + "' is already defined", this.range));
            return;
        }
        this.symbolPageIdx = symbolScope.define(string, ConstantValueHolder.initializer);
    }

    @Override
    public void executePrepass(EvaluationState evaluationState) {
        this.expr.executePrepass(evaluationState);
        if (this.symbolPageIdx != null) {
            this.symbolPageIdx.setStatus(SymbolStatus.defined);
        }
    }

    @Override
    public Value evaluate(EvaluationState evaluationState) {
        Value value = this.expr.evaluate(evaluationState);
        if (value.isInvalidOrInvalidContent()) {
            evaluationState.sideeffectMgr.setInvalidSideEffectsDuringFunctionEvaluation();
        }
        IValueHolder iValueHolder = this.symbolPageIdx.getValueHolder();
        iValueHolder.setWithoutSideEffect(value);
        if (!this.isFunctionMode) {
            evaluationState.sideeffectMgr.addSideEffect(new SESymbolAssignment(value, iValueHolder));
        }
        return value;
    }
}

