/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.sideeffect;

import kickass.pass.asmnode.output.reciever.OutputStreamType;
import kickass.pass.sideeffect.SideEffect;
import kickass.state.FunctionSideOutput;

public class SideeffectManager {
    private boolean errorDuringFunctionEvaluation;
    private boolean invalidSideEffectsDuringFunctionEvaluation;
    private FunctionSideOutput sideOutput = null;

    public void clearFunctionSideOutput() {
        this.sideOutput = null;
        this.errorDuringFunctionEvaluation = false;
        this.invalidSideEffectsDuringFunctionEvaluation = false;
    }

    public FunctionSideOutput getFunctionSideOutput() {
        return this.sideOutput;
    }

    public void addSideEffect(SideEffect sideEffect) {
        this.getOrNewFunctionSideOutput().addSideEffect(sideEffect);
    }

    public void addTextOutput(String string) {
        this.addStreamOutput(OutputStreamType.CONSOLE, null, string);
    }

    public void addStreamOutput(OutputStreamType outputStreamType, String string, Object object) {
        this.getOrNewFunctionSideOutput().addStreamOutput(outputStreamType, string, object);
    }

    private FunctionSideOutput getOrNewFunctionSideOutput() {
        if (this.sideOutput == null) {
            this.sideOutput = new FunctionSideOutput();
        }
        return this.sideOutput;
    }

    public boolean getErrorDuringFunctionEvaluation() {
        return this.errorDuringFunctionEvaluation;
    }

    public boolean getInvalidSideEffectsDuringFunctionEvaluation() {
        return this.invalidSideEffectsDuringFunctionEvaluation;
    }

    public boolean getErrorOrInvalidSideEffectsDuringFunctionEvaluation() {
        return this.getErrorDuringFunctionEvaluation() || this.getInvalidSideEffectsDuringFunctionEvaluation();
    }

    public void setErrorDuringFunctionEvaluation(boolean bl) {
        this.errorDuringFunctionEvaluation = bl;
    }

    public void setInvalidSideEffectsDuringFunctionEvaluation() {
        this.invalidSideEffectsDuringFunctionEvaluation = true;
    }
}

