/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.values;

import kickass.common.exceptions.AsmErrorException;
import kickass.common.exceptions.AsmException;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.function.Function;
import kickass.pass.function.table.FunctionTable;
import kickass.pass.function.table.StdFunctionTable;
import kickass.pass.valueholder.ConstantValueHolder;
import kickass.pass.valueholder.IValueHolder;
import kickass.pass.values.ImmutableValue;
import kickass.pass.values.NullValue;
import kickass.pass.values.NumberValue;
import kickass.pass.values.StringValue;
import kickass.pass.values.Value;
import kickass.state.EvaluationState;

public class SidFileValue
extends ImmutableValue {
    public static Value invalid = new SidFileValue();
    private static int POS_HEADER = 0;
    private static int POS_VERSION = 4;
    private static int POS_DATAOFFSET = 6;
    private static int POS_LOADADDR = 8;
    private static int POS_INITADDR = 10;
    private static int POS_PLAYADDR = 12;
    private static int POS_SONGS = 14;
    private static int POS_STARTSONG = 16;
    private static int POS_SPEED = 18;
    private static int POS_NAME = 22;
    private static int POS_AUTHOR = 54;
    private static int POS_COPYRIGHT = 86;
    private static int POS_FLAGS = 118;
    private static int POS_STARTPAGE = 120;
    private static int POS_PAGELENGTH = 121;
    private static String FM_PSID = "PSID";
    private static String FM_RSID = "RSID";
    protected byte[] file;
    private int dataOffset;
    private int location;
    private ConstantValueHolder sizeHolder;
    static FunctionTable functions = new StdFunctionTable(SidFileValue.getStandardFunctions());

    public SidFileValue() {
        this.setInvalid();
    }

    public SidFileValue(byte[] byArray, SourceRange sourceRange) {
        this.file = byArray;
        String string = this.getString(POS_HEADER, 32, byArray);
        if (!string.equals(FM_PSID) && !string.equals(FM_RSID)) {
            throw new AsmErrorException("Unknown sid format : " + string, sourceRange);
        }
        this.dataOffset = this.getInt(POS_DATAOFFSET, 2, byArray);
        this.location = this.getInt(POS_LOADADDR, 2, byArray);
        if (this.location == 0) {
            this.location = (byArray[this.dataOffset] & 0xFF) + 256 * (byArray[this.dataOffset + 1] & 0xFF);
            this.dataOffset += 2;
        }
        this.sizeHolder = new ConstantValueHolder(new NumberValue(byArray.length - this.dataOffset));
    }

    @Override
    public String getType() {
        return "SID file";
    }

    @Override
    public boolean hasString() {
        return true;
    }

    @Override
    public String getString(SourceRange sourceRange) {
        return this.isInvalid() ? "<<Invalid Sid File>>" : "SID<\"" + this.getString(POS_NAME, 32, this.file) + "\">";
    }

    @Override
    public IValueHolder localGetVariable(String string, SourceRange sourceRange) throws AsmException {
        if (string.equals("header")) {
            return new ConstantValueHolder(new StringValue(this.getString(POS_HEADER, 4, this.file)));
        }
        if (string.equals("version")) {
            return new ConstantValueHolder(new NumberValue(this.getInt(POS_VERSION, 2, this.file)));
        }
        if (string.equals("location")) {
            return new ConstantValueHolder(new NumberValue(this.location));
        }
        if (string.equals("init")) {
            return new ConstantValueHolder(new NumberValue(this.getInt(POS_INITADDR, 2, this.file)));
        }
        if (string.equals("play")) {
            return new ConstantValueHolder(new NumberValue(this.getInt(POS_PLAYADDR, 2, this.file)));
        }
        if (string.equals("songs")) {
            return new ConstantValueHolder(new NumberValue(this.getInt(POS_SONGS, 2, this.file)));
        }
        if (string.equals("startSong")) {
            return new ConstantValueHolder(new NumberValue(this.getInt(POS_STARTSONG, 2, this.file)));
        }
        if (string.equals("speed")) {
            return new ConstantValueHolder(new NumberValue(this.getInt(POS_SPEED, 4, this.file)));
        }
        if (string.equals("name")) {
            return new ConstantValueHolder(new StringValue(this.getString(POS_NAME, 32, this.file)));
        }
        if (string.equals("author")) {
            return new ConstantValueHolder(new StringValue(this.getString(POS_AUTHOR, 32, this.file)));
        }
        if (string.equals("copyright")) {
            return new ConstantValueHolder(new StringValue(this.getString(POS_COPYRIGHT, 32, this.file)));
        }
        if (string.equals("size")) {
            return this.sizeHolder;
        }
        if (string.equals("flags")) {
            return new ConstantValueHolder(this.getVersion() < 2 ? NullValue.instance : new NumberValue(this.getInt(POS_FLAGS, 2, this.file)));
        }
        if (string.equals("startpage")) {
            return new ConstantValueHolder(this.getVersion() < 2 ? NullValue.instance : new NumberValue(this.getInt(POS_STARTPAGE, 1, this.file)));
        }
        if (string.equals("pagelength")) {
            return new ConstantValueHolder(this.getVersion() < 2 ? NullValue.instance : new NumberValue(this.getInt(POS_PAGELENGTH, 1, this.file)));
        }
        return null;
    }

    private int getVersion() {
        return this.getInt(POS_VERSION, 2, this.file);
    }

    private int getInt(int n, int n2, byte[] byArray) {
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            if (i > 0) {
                n3 <<= 8;
            }
            n3 += byArray[n + i] & 0xFF;
        }
        return n3;
    }

    private String getString(int n, int n2, byte[] byArray) {
        int n3;
        char[] cArray = new char[n2];
        for (n3 = 0; n3 < n2 && byArray[n + n3] != 0; ++n3) {
            cArray[n3] = (char)byArray[n + n3];
        }
        return String.valueOf(cArray, 0, n3);
    }

    @Override
    public FunctionTable getFunctions() {
        return functions;
    }

    static {
        functions.add(new Function("getData", 2, NumberValue.invalid){

            @Override
            public Value execute(Value[] valueArray, EvaluationState evaluationState, SourceRange sourceRange) {
                SidFileValue sidFileValue = (SidFileValue)valueArray[0];
                int n = valueArray[1].getInt(sourceRange);
                if (n < 0 || sidFileValue.file.length <= sidFileValue.dataOffset + n) {
                    throw new AsmErrorException("Index (" + n + ") out of range", sourceRange);
                }
                return new NumberValue(sidFileValue.file[sidFileValue.dataOffset + n]);
            }
        });
    }
}

