/*
 * Decompiled with CFR 0.152.
 */
package kickass.state;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kickass.common.exceptions.AsmErrorException;
import kickass.nonasm.tools.FileTool;
import kickass.nonasm.tools.FileUtil;
import kickass.parsing.sourcelocation.SourceRange;

public class FileManager {
    private File currentDirectory = null;
    private Map<String, File> fileReplacementMap = new HashMap<String, File>();
    private ArrayList<File> sourceLibraryPath;
    private Set<String> excludedImports = new HashSet<String>();
    private Set<String> sourceFiles = new HashSet<String>();

    public void setSourceLibraryPath(ArrayList<File> arrayList) {
        this.sourceLibraryPath = arrayList;
    }

    public void setFileReplacementMap(Map<String, File> map) {
        this.fileReplacementMap = map;
    }

    public void registerSourceFile(String string) {
        this.sourceFiles.add(string);
    }

    public Set<String> getSourceFiles() {
        return this.sourceFiles;
    }

    public void excludeFileForImport(File file) {
        String string = FileTool.getCanonicalFilePath(file);
        this.excludedImports.add(string);
    }

    public boolean isFileExcludedForImport(File file) {
        String string = FileTool.getCanonicalFilePath(file);
        return this.excludedImports.contains(string);
    }

    public File getCurrentDirectory() {
        return this.currentDirectory;
    }

    public File replaceCurrentDirectory(File file) {
        File file2 = this.currentDirectory;
        this.currentDirectory = file;
        return file2;
    }

    public void setCurrentDirectory(File file) {
        this.currentDirectory = file;
    }

    public InputStream openFileOrFail(String string, boolean bl, SourceRange sourceRange) {
        InputStream inputStream = this.openFile(string, bl);
        if (inputStream == null) {
            throw new AsmErrorException("Can't open file '" + string + "'", sourceRange);
        }
        return inputStream;
    }

    public InputStream openFile(String string, boolean bl) {
        File file = this.getFile(string, bl);
        if (file != null) {
            try {
                return new FileInputStream(file);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public File getFileOrFail(String string, boolean bl, SourceRange sourceRange) {
        File file = this.getFile(string, bl);
        if (file == null) {
            throw new AsmErrorException("Can't locate file '" + string + "'", sourceRange);
        }
        return file;
    }

    public File getFile(String string, boolean bl) {
        File file = this.replaceFile(FileUtil.getCanonicalFile(this.currentDirectory, string), bl);
        if (file.exists()) {
            return file;
        }
        for (int i = 0; i < this.sourceLibraryPath.size(); ++i) {
            file = this.replaceFile(new File(this.sourceLibraryPath.get(i), string), bl);
            if (!file.exists()) continue;
            return file;
        }
        file = this.replaceFile(new File(string), bl);
        if (file.exists()) {
            return file;
        }
        return null;
    }

    private File replaceFile(File file, boolean bl) {
        if (bl) {
            return file;
        }
        File file2 = this.fileReplacementMap.get(FileUtil.getCanonicalPath(file));
        return file2 == null ? file : file2;
    }
}

