/*
 * Decompiled with CFR 0.152.
 */
package kickass.state.libraries;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import kickass.common.exceptions.AsmErrorException;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.function.Function;
import kickass.pass.function.special.Function0Arg;
import kickass.pass.function.special.Function1Arg;
import kickass.pass.function.special.Function2Arg;
import kickass.pass.values.NullValue;
import kickass.pass.values.NumberValue;
import kickass.state.libraries.ILibrary;
import kickass.state.libraries.LibConstant;

public class MathLibrary
implements ILibrary {
    private static Random randomGenerator = new Random(0L);

    public static void setSeed(long l) {
        randomGenerator.setSeed(l);
    }

    public static Random getRandomGenerator() {
        return randomGenerator;
    }

    @Override
    public String getName() {
        return "Math";
    }

    public List<LibConstant> getConstants() {
        ArrayList<LibConstant> arrayList = new ArrayList<LibConstant>();
        arrayList.add(new LibConstant("PI", new NumberValue(Math.PI)));
        arrayList.add(new LibConstant("E", new NumberValue(Math.E)));
        return arrayList;
    }

    @Override
    public Collection<Function> getFunctions() {
        ArrayList<Function> arrayList = new ArrayList<Function>();
        arrayList.add(new Function1Arg("abs", NumberValue.invalid, (value, sourceRange) -> new NumberValue(Math.abs(value.getDouble((SourceRange)sourceRange)))));
        arrayList.add(new Function1Arg("acos", NumberValue.invalid, (value, sourceRange) -> new NumberValue(Math.acos(value.getDouble((SourceRange)sourceRange)))));
        arrayList.add(new Function1Arg("asin", NumberValue.invalid, (value, sourceRange) -> new NumberValue(Math.asin(value.getDouble((SourceRange)sourceRange)))));
        arrayList.add(new Function1Arg("atan", NumberValue.invalid, (value, sourceRange) -> new NumberValue(Math.atan(value.getDouble((SourceRange)sourceRange)))));
        arrayList.add(new Function2Arg("atan2", NumberValue.invalid, (value, value2, sourceRange) -> new NumberValue(Math.atan2(value.getDouble((SourceRange)sourceRange), value2.getDouble((SourceRange)sourceRange)))));
        arrayList.add(new Function1Arg("cbrt", NumberValue.invalid, (value, sourceRange) -> new NumberValue(Math.cbrt(value.getDouble((SourceRange)sourceRange)))));
        arrayList.add(new Function1Arg("ceil", NumberValue.invalid, (value, sourceRange) -> new NumberValue(Math.ceil(value.getDouble((SourceRange)sourceRange)))));
        arrayList.add(new Function1Arg("cos", NumberValue.invalid, (value, sourceRange) -> new NumberValue(Math.cos(value.getDouble((SourceRange)sourceRange)))));
        arrayList.add(new Function1Arg("cosh", NumberValue.invalid, (value, sourceRange) -> new NumberValue(Math.cosh(value.getDouble((SourceRange)sourceRange)))));
        arrayList.add(new Function1Arg("exp", NumberValue.invalid, (value, sourceRange) -> new NumberValue(Math.exp(value.getDouble((SourceRange)sourceRange)))));
        arrayList.add(new Function1Arg("expm1", NumberValue.invalid, (value, sourceRange) -> new NumberValue(Math.expm1(value.getDouble((SourceRange)sourceRange)))));
        arrayList.add(new Function1Arg("floor", NumberValue.invalid, (value, sourceRange) -> new NumberValue(Math.floor(value.getDouble((SourceRange)sourceRange)))));
        arrayList.add(new Function2Arg("hypot", NumberValue.invalid, (value, value2, sourceRange) -> new NumberValue(Math.hypot(value.getDouble((SourceRange)sourceRange), value2.getDouble((SourceRange)sourceRange)))));
        arrayList.add(new Function2Arg("IEEEremainder", NumberValue.invalid, (value, value2, sourceRange) -> new NumberValue(Math.IEEEremainder(value.getDouble((SourceRange)sourceRange), value2.getDouble((SourceRange)sourceRange)))));
        arrayList.add(new Function1Arg("log", NumberValue.invalid, (value, sourceRange) -> new NumberValue(Math.log(value.getDouble((SourceRange)sourceRange)))));
        arrayList.add(new Function1Arg("log10", NumberValue.invalid, (value, sourceRange) -> new NumberValue(Math.log10(value.getDouble((SourceRange)sourceRange)))));
        arrayList.add(new Function1Arg("log1p", NumberValue.invalid, (value, sourceRange) -> new NumberValue(Math.log1p(value.getDouble((SourceRange)sourceRange)))));
        arrayList.add(new Function2Arg("max", NumberValue.invalid, (value, value2, sourceRange) -> new NumberValue(Math.max(value.getDouble((SourceRange)sourceRange), value2.getDouble((SourceRange)sourceRange)))));
        arrayList.add(new Function2Arg("min", NumberValue.invalid, (value, value2, sourceRange) -> new NumberValue(Math.min(value.getDouble((SourceRange)sourceRange), value2.getDouble((SourceRange)sourceRange)))));
        arrayList.add(new Function2Arg("pow", NumberValue.invalid, (value, value2, sourceRange) -> new NumberValue(Math.pow(value.getDouble((SourceRange)sourceRange), value2.getDouble((SourceRange)sourceRange)))));
        arrayList.add(new Function0Arg("random", sourceRange -> new NumberValue(randomGenerator.nextDouble())));
        arrayList.add(new Function1Arg("round", NumberValue.invalid, (value, sourceRange) -> new NumberValue(Math.round(value.getDouble((SourceRange)sourceRange)))));
        arrayList.add(new Function1Arg("signum", NumberValue.invalid, (value, sourceRange) -> new NumberValue(Math.signum(value.getDouble((SourceRange)sourceRange)))));
        arrayList.add(new Function1Arg("sin", NumberValue.invalid, (value, sourceRange) -> new NumberValue(Math.sin(value.getDouble((SourceRange)sourceRange)))));
        arrayList.add(new Function1Arg("sinh", NumberValue.invalid, (value, sourceRange) -> new NumberValue(Math.sinh(value.getDouble((SourceRange)sourceRange)))));
        arrayList.add(new Function1Arg("sqrt", NumberValue.invalid, (value, sourceRange) -> new NumberValue(Math.sqrt(value.getDouble((SourceRange)sourceRange)))));
        arrayList.add(new Function1Arg("tan", NumberValue.invalid, (value, sourceRange) -> new NumberValue(Math.tan(value.getDouble((SourceRange)sourceRange)))));
        arrayList.add(new Function1Arg("tanh", NumberValue.invalid, (value, sourceRange) -> new NumberValue(Math.tanh(value.getDouble((SourceRange)sourceRange)))));
        arrayList.add(new Function1Arg("toDegrees", NumberValue.invalid, (value, sourceRange) -> new NumberValue(Math.toDegrees(value.getDouble((SourceRange)sourceRange)))));
        arrayList.add(new Function1Arg("toRadians", NumberValue.invalid, (value, sourceRange) -> new NumberValue(Math.toRadians(value.getDouble((SourceRange)sourceRange)))));
        arrayList.add(new Function2Arg("mod", NumberValue.invalid, (value, value2, sourceRange) -> {
            if (value2.getLong((SourceRange)sourceRange) == 0L) {
                throw new AsmErrorException("The second argument of the mod function can't be zero", (SourceRange)sourceRange);
            }
            return new NumberValue(value.getLong((SourceRange)sourceRange) % value2.getLong((SourceRange)sourceRange));
        }));
        arrayList.add(new Function1Arg("setSeed", NullValue.instance, (value, sourceRange) -> {
            randomGenerator.setSeed(value.getLong((SourceRange)sourceRange));
            return NullValue.instance;
        }));
        return arrayList;
    }
}

