/*
 * Decompiled with CFR 0.152.
 */
package kickass.state.libraries;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.function.Function;
import kickass.pass.function.special.Function1Arg;
import kickass.pass.function.special.Function2Arg;
import kickass.pass.values.StringValue;
import kickass.state.libraries.ILibrary;
import kickass.state.libraries.LibConstant;

public class PrintLibrary
implements ILibrary {
    @Override
    public String getName() {
        return "Print";
    }

    public List<LibConstant> getConstants() {
        return new ArrayList<LibConstant>();
    }

    @Override
    public Collection<Function> getFunctions() {
        ArrayList<Function> arrayList = new ArrayList<Function>();
        arrayList.add(new Function1Arg("toIntString", StringValue.invalid, (value, sourceRange) -> new StringValue(Long.toString(value.getLong((SourceRange)sourceRange)))));
        arrayList.add(new Function2Arg("toIntString", StringValue.invalid, (value, value2, sourceRange) -> new StringValue(PrintLibrary.padLeft(Long.toString(value.getLong((SourceRange)sourceRange)), value2.getInt((SourceRange)sourceRange), ' '))));
        arrayList.add(new Function1Arg("toHexString", StringValue.invalid, (value, sourceRange) -> new StringValue(Long.toHexString(value.getLong((SourceRange)sourceRange)))));
        arrayList.add(new Function2Arg("toHexString", StringValue.invalid, (value, value2, sourceRange) -> new StringValue(PrintLibrary.padLeft(Long.toHexString(value.getLong((SourceRange)sourceRange)), value2.getInt((SourceRange)sourceRange), '0'))));
        arrayList.add(new Function1Arg("toBinaryString", StringValue.invalid, (value, sourceRange) -> new StringValue(Long.toBinaryString(value.getLong((SourceRange)sourceRange)))));
        arrayList.add(new Function2Arg("toBinaryString", StringValue.invalid, (value, value2, sourceRange) -> new StringValue(PrintLibrary.padLeft(Long.toBinaryString(value.getLong((SourceRange)sourceRange)), value2.getInt((SourceRange)sourceRange), '0'))));
        arrayList.add(new Function1Arg("toOctalString", StringValue.invalid, (value, sourceRange) -> new StringValue(Long.toOctalString(value.getLong((SourceRange)sourceRange)))));
        arrayList.add(new Function2Arg("toOctalString", StringValue.invalid, (value, value2, sourceRange) -> new StringValue(PrintLibrary.padLeft(Long.toOctalString(value.getLong((SourceRange)sourceRange)), value2.getInt((SourceRange)sourceRange), '0'))));
        return arrayList;
    }

    private static String padLeft(String string, int n, char c) {
        int n2 = n - string.length();
        if (n2 <= 0) {
            return string;
        }
        char[] cArray = new char[n2];
        Arrays.fill(cArray, c);
        String string2 = new String(cArray);
        return string2 + string;
    }
}

