/*
 * Decompiled with CFR 0.152.
 */
package kickass.state.namespace;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kickass.common.diagnostics.AsmError;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.asmnode.metanodes.MacroDefinitionRootNode;
import kickass.pass.function.functionselector.IFunctionSelector;
import kickass.pass.valueholder.ConstantValueHolder;
import kickass.pass.values.NamespaceValue;
import kickass.plugins.interf.macro.IMacro;
import kickass.plugins.interf.modifier.IModifier;
import kickass.plugins.interf.segmentmodifier.ISegmentModifier;
import kickass.state.EvaluationState;
import kickass.state.scope.EntityScope;
import kickass.state.scope.StdEntityScope;
import kickass.state.scope.SymbolScope;
import kickass.state.scope.symboltable.ISymbolPageIdx;
import kickass.state.scope.symboltable.SymbolStatus;
import kickass.state.scope.symboltable.SymbolTable;

public class Namespace {
    private String name;
    private boolean isSpecial;
    private String fullName;
    private Namespace parent;
    private SymbolScope scope;
    private EntityScope<MacroDefinitionRootNode> macros;
    private EntityScope<MacroDefinitionRootNode> pseudoCommands;
    private EntityScope<IMacro> macroPlugins;
    private EntityScope<IModifier> modifierPlugins;
    private EntityScope<ISegmentModifier> segmentModifierPlugins;
    private EntityScope<IFunctionSelector> functions;
    private List<Namespace> subspaces = new ArrayList<Namespace>();
    private Map<String, Namespace> globalSharedNamespaceMap;

    public static Namespace createSystemNamespace() {
        return new Namespace();
    }

    private Namespace() {
        this.fullName = this.name = "<SystemNs>";
        this.scope = new SymbolScope(null, new SymbolTable());
        this.macros = new StdEntityScope<MacroDefinitionRootNode>(null);
        this.pseudoCommands = new StdEntityScope<MacroDefinitionRootNode>(null);
        this.macroPlugins = new StdEntityScope<IMacro>(null);
        this.modifierPlugins = new StdEntityScope<IModifier>(null);
        this.segmentModifierPlugins = new StdEntityScope<ISegmentModifier>(null);
        this.functions = new StdEntityScope<IFunctionSelector>(null);
        this.parent = null;
        this.isSpecial = true;
        this.globalSharedNamespaceMap = new HashMap<String, Namespace>();
    }

    public Namespace(String string, Namespace namespace, boolean bl) {
        this.name = string;
        this.isSpecial = bl;
        this.fullName = namespace.isSpecial ? string : namespace.getFullName() + "." + string;
        this.parent = namespace;
        this.globalSharedNamespaceMap = namespace.globalSharedNamespaceMap;
        this.scope = new SymbolScope(namespace.getScope(), null);
        this.macros = new StdEntityScope<MacroDefinitionRootNode>(namespace.getMacros());
        this.pseudoCommands = new StdEntityScope<MacroDefinitionRootNode>(namespace.getPseudoCommands());
        this.macroPlugins = new StdEntityScope<IMacro>(namespace.getMacroPlugins());
        this.modifierPlugins = new StdEntityScope<IModifier>(namespace.getModifierPlugins());
        this.segmentModifierPlugins = new StdEntityScope<ISegmentModifier>(namespace.getSegmentModifierPlugins());
        this.functions = new StdEntityScope<IFunctionSelector>(namespace.getFunctions());
    }

    public String toString() {
        return this.fullName;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getName() {
        return this.name;
    }

    public SymbolScope getScope() {
        return this.scope;
    }

    public EntityScope<MacroDefinitionRootNode> getMacros() {
        return this.macros;
    }

    public EntityScope<IMacro> getMacroPlugins() {
        return this.macroPlugins;
    }

    public EntityScope<IModifier> getModifierPlugins() {
        return this.modifierPlugins;
    }

    public EntityScope<ISegmentModifier> getSegmentModifierPlugins() {
        return this.segmentModifierPlugins;
    }

    public EntityScope<MacroDefinitionRootNode> getPseudoCommands() {
        return this.pseudoCommands;
    }

    public EntityScope<IFunctionSelector> getFunctions() {
        return this.functions;
    }

    public Namespace getParent() {
        return this.parent;
    }

    public Collection<Namespace> getSubspaces() {
        return this.subspaces;
    }

    public Namespace getSubspace(String string, EvaluationState evaluationState, SourceRange sourceRange) {
        String[] stringArray;
        String string2 = this.isSpecial ? string : this.fullName + "." + string;
        Namespace namespace = this.globalSharedNamespaceMap.get(string2);
        if (namespace != null) {
            return namespace;
        }
        for (String string3 : stringArray = string.split(Pattern.quote("."))) {
            namespace = this.getOrCreateDirectSubspace(string3, evaluationState, sourceRange);
            if (namespace != null) continue;
            return null;
        }
        return namespace;
    }

    private Namespace getOrCreateDirectSubspace(String string, EvaluationState evaluationState, SourceRange sourceRange) {
        for (Namespace object2 : this.subspaces) {
            if (!object2.getName().equals(string)) continue;
            return object2;
        }
        if (this.scope.isDefined(string)) {
            evaluationState.diagnosticMgr.add(new AsmError("Can't define namespace '" + string + "'. The symbol of that name is already defined.", sourceRange));
            return null;
        }
        Namespace namespace = new Namespace(string, this, false);
        ISymbolPageIdx iSymbolPageIdx = this.scope.define(string, iValueHolderArray -> new ConstantValueHolder(new NamespaceValue(namespace, iValueHolderArray)));
        iSymbolPageIdx.setStatus(SymbolStatus.defined);
        iSymbolPageIdx.setIsScopeExposed(true);
        this.subspaces.add(namespace);
        this.globalSharedNamespaceMap.put(namespace.getFullName(), namespace);
        return namespace;
    }
}

