/*
 * Decompiled with CFR 0.152.
 */
package kickass.parsing.preprocessor;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import kickass.common.diagnostics.AsmError;
import kickass.common.syntaxinfo.SyntaxInfo;
import kickass.common.syntaxinfo.SyntaxType;
import kickass.parsing.baselang.TokenType;
import kickass.parsing.baselang.tokens.IToken;
import kickass.parsing.baselang.tokens.SubFileToken;
import kickass.parsing.baselang.tokens.ValueToken;
import kickass.parsing.baselang.tokenstreams.ITokenStream;
import kickass.parsing.baselang.tokenstreams.TokenStreamList;
import kickass.parsing.preprocessor.directives.IPreProcessorDirective;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.setup.KickAssemblerSetup;
import kickass.state.EvaluationState;
import kickass.state.FileManager;

public class PreProcessor
implements ITokenStream {
    private Map<String, IPreProcessorDirective> directiveMap = new HashMap<String, IPreProcessorDirective>();
    private EvaluationState state;
    private ITokenStream stream;
    private IToken subFileToken = null;
    private boolean onStartOfLine = true;
    private boolean skipTokens = false;

    public PreProcessor(ITokenStream iTokenStream, EvaluationState evaluationState) {
        this.stream = iTokenStream;
        this.state = evaluationState;
    }

    @Override
    public IToken getTerminatingToken() {
        return this.stream.getTerminatingToken();
    }

    public void addDirective(String string, IPreProcessorDirective iPreProcessorDirective) {
        this.directiveMap.put(string, iPreProcessorDirective);
    }

    @Override
    public IToken next() throws IOException {
        IToken iToken;
        while (true) {
            if (this.subFileToken != null) {
                iToken = this.subFileToken;
                this.subFileToken = null;
                return iToken;
            }
            iToken = this.stream.next();
            TokenType tokenType = iToken.getType();
            if (this.onStartOfLine && tokenType == TokenType.Hash) {
                this.executePreprocessorLine(iToken);
                continue;
            }
            if (tokenType == TokenType.Newline) {
                this.onStartOfLine = true;
            } else if (tokenType != TokenType.StdWhitespace) {
                this.onStartOfLine = false;
            }
            if (!this.skipTokens || iToken.isEos()) break;
        }
        return iToken;
    }

    private void executePreprocessorLine(IToken iToken) throws IOException {
        IToken iToken2 = this.stream.next();
        TokenStreamList tokenStreamList = null;
        if (iToken2.getType() != TokenType.Newline) {
            tokenStreamList = this.stream.getUntilNlSkipWs();
        }
        if (!iToken2.expectId(this.state)) {
            return;
        }
        String string = "#" + iToken2.getValue();
        SourceRange sourceRange = new SourceRange(iToken.getSourceRange(), iToken2.getSourceRange());
        ValueToken valueToken = new ValueToken(TokenType.Id, string, sourceRange);
        this.state.syntaxInfoMgr.add(new SyntaxInfo(SyntaxType.ppDirective, sourceRange));
        IPreProcessorDirective iPreProcessorDirective = this.directiveMap.get(string);
        if (iPreProcessorDirective == null) {
            this.state.diagnosticMgr.add(new AsmError("Unknown preprocessor directive " + string, valueToken.getSourceRange()));
            return;
        }
        iPreProcessorDirective.executeDirective(valueToken, tokenStreamList);
        this.skipTokens = this.state.preprocessorMgr.isInPassiveState();
    }

    public EvaluationState getState() {
        return this.state;
    }

    public void importFile(String string, SourceRange sourceRange) throws IOException {
        IToken iToken;
        File file = this.state.fileMgr.getFile(string, true);
        File file2 = this.state.fileMgr.getFile(string, false);
        if (file2 == null) {
            this.state.diagnosticMgr.add(new AsmError("Can't open file: " + string, sourceRange));
            return;
        }
        if (this.state.fileMgr.isFileExcludedForImport(file)) {
            return;
        }
        String string2 = file.getPath();
        FileInputStream fileInputStream = null;
        BufferedInputStream bufferedInputStream = null;
        try {
            fileInputStream = new FileInputStream(file2);
            bufferedInputStream = new BufferedInputStream(fileInputStream);
        }
        catch (Exception exception) {
            this.state.diagnosticMgr.add(new AsmError("Can't open file: " + string2, sourceRange));
            return;
        }
        InputStreamReader inputStreamReader = new InputStreamReader(bufferedInputStream);
        ITokenStream iTokenStream = KickAssemblerSetup.getLexer(string2, inputStreamReader, this.state);
        SubFileToken subFileToken = new SubFileToken(file, sourceRange);
        FileManager fileManager = this.state.fileMgr;
        File file3 = fileManager.replaceCurrentDirectory(file.getParentFile());
        while (!(iToken = iTokenStream.next()).isEos()) {
            subFileToken.addChild(iToken);
        }
        subFileToken.setRangeEndToken(iToken);
        fileManager.setCurrentDirectory(file3);
        this.subFileToken = subFileToken;
        ((Reader)inputStreamReader).close();
        ((InputStream)bufferedInputStream).close();
        fileInputStream.close();
    }
}

