/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.asmnode.directives;

import kickass.common.diagnostics.AsmError;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.asmnode.AsmNode;
import kickass.pass.asmnode.directives.AsmDirective;
import kickass.pass.asmnode.output.EmptyOutput;
import kickass.pass.asmnode.output.SideEffectOnlyOutput;
import kickass.pass.expressions.expr.ExprNode;
import kickass.pass.values.Value;
import kickass.state.EvaluationState;
import kickass.state.breakpoint.Breakpoint;

public class BreakDirective
extends AsmDirective {
    private ExprNode argExpr;

    public BreakDirective(ExprNode exprNode, SourceRange sourceRange) {
        super(sourceRange);
        this.argExpr = exprNode;
    }

    @Override
    public AsmNode copy() {
        return this;
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        if (this.argExpr != null) {
            this.argExpr.executePrepass(evaluationState);
        }
        return this;
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        int n;
        String string = null;
        evaluationState.sideeffectMgr.clearFunctionSideOutput();
        if (this.argExpr != null) {
            Value value = this.argExpr.evaluate(evaluationState);
            if (value.isInvalid()) {
                evaluationState.diagnosticMgr.add(new AsmError("The break directive must be able to evaluate in first pass", this.range));
                return EmptyOutput.instance;
            }
            string = value.getString(this.range);
        }
        if ((n = evaluationState.segmentMgr.getMemoryPosition()) < 0) {
            return this;
        }
        Breakpoint breakpoint = new Breakpoint(n, string, evaluationState.segmentMgr.getCurrentSegment());
        evaluationState.breakpointMgr.addBreakpoint(breakpoint);
        return SideEffectOnlyOutput.create(evaluationState.sideeffectMgr.getFunctionSideOutput());
    }

    @Override
    public String toString() {
        return "Break";
    }
}

