/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.expressions.expr;

import java.util.List;
import kickass.common.diagnostics.AsmError;
import kickass.common.exceptions.ReturnException;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.expressions.expr.ExprNode;
import kickass.pass.function.Function;
import kickass.pass.function.functionselector.IFunctionSelector;
import kickass.pass.values.Value;
import kickass.state.EvaluationState;

public class FunctionCall
extends ExprNode {
    private boolean isRootScope;
    private String functionName;
    private List<ExprNode> argExprs;
    private Function function = null;

    public FunctionCall(String string, SourceRange sourceRange, List<ExprNode> list) {
        super(sourceRange);
        this.argExprs = list;
        this.isRootScope = string.startsWith("@");
        this.functionName = this.isRootScope ? string.substring(1) : string;
    }

    @Override
    public void executePrepass(EvaluationState evaluationState) {
        for (ExprNode exprNode : this.argExprs) {
            exprNode.executePrepass(evaluationState);
        }
        IFunctionSelector iFunctionSelector = evaluationState.namespaceMgr.getRootOrCurrentNamespace(this.isRootScope).getFunctions().get(this.functionName);
        if (iFunctionSelector == null) {
            evaluationState.diagnosticMgr.add(new AsmError("Unknown function '" + this.functionName + "'", this.range));
            return;
        }
        this.function = iFunctionSelector.getFunction(this.argExprs.size());
        if (this.function == null) {
            evaluationState.diagnosticMgr.add(new AsmError("Invalid number of arguments for function '" + this.functionName + "'", this.range));
        }
    }

    @Override
    public Value evaluate(EvaluationState evaluationState) {
        Value value;
        Value[] valueArray = new Value[this.argExprs.size()];
        boolean bl = false;
        for (int i = 0; i < valueArray.length; ++i) {
            Value value2 = this.argExprs.get(i).evaluate(evaluationState);
            bl |= value2.isInvalid();
            valueArray[i] = value2;
        }
        evaluationState.callStack.push(this.range);
        try {
            value = bl && !this.function.handlesInvalidArguments() ? this.function.getInvalidResult(valueArray) : this.function.execute(valueArray, evaluationState, this.range);
        }
        catch (ReturnException returnException) {
            value = returnException.getReturnValue();
        }
        evaluationState.callStack.pop();
        return value;
    }

    public String toString() {
        return this.functionName + "()";
    }
}

