/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.values;

import kickass.common.exceptions.AsmErrorException;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.function.special.Function1Arg;
import kickass.pass.function.special.Function2Arg;
import kickass.pass.function.special.Function3Arg;
import kickass.pass.function.special.FunctionVarArg;
import kickass.pass.function.table.FunctionTable;
import kickass.pass.function.table.StdFunctionTable;
import kickass.pass.values.BooleanValue;
import kickass.pass.values.CharValue;
import kickass.pass.values.ImmutableValue;
import kickass.pass.values.NumberValue;
import kickass.pass.values.Value;

public class StringValue
extends ImmutableValue {
    public static Value invalid = new StringValue();
    public static Value emptyString = new StringValue("");
    private String string;
    static FunctionTable functions = new StdFunctionTable(StringValue.getStandardFunctions());

    private StringValue() {
        this.setInvalid();
    }

    public StringValue(String string) {
        this.string = string;
    }

    @Override
    public String getType() {
        return this.isInvalid() ? "Invalid String" : "String";
    }

    @Override
    public boolean hasString() {
        return true;
    }

    @Override
    public String getString(SourceRange sourceRange) {
        if (this.isInvalid() && this.string == null) {
            return "<<Invalid String>>";
        }
        return this.string;
    }

    @Override
    public FunctionTable getFunctions() {
        return functions;
    }

    static {
        functions.add(new Function2Arg("==", BooleanValue.invalid, (value, value2, sourceRange) -> BooleanValue.get(value.getString((SourceRange)sourceRange).equals(value2.getString((SourceRange)sourceRange)))));
        functions.add(new Function2Arg("!=", BooleanValue.invalid, (value, value2, sourceRange) -> BooleanValue.get(!value.getString((SourceRange)sourceRange).equals(value2.getString((SourceRange)sourceRange)))));
        functions.add(new Function1Arg("size", NumberValue.invalid, (value, sourceRange) -> new NumberValue(value.getString((SourceRange)sourceRange).length())));
        functions.add(new Function1Arg("asBoolean", BooleanValue.invalid, (value, sourceRange) -> BooleanValue.get(Boolean.parseBoolean(value.getString((SourceRange)sourceRange)))));
        functions.add(new Function2Arg("+", invalid, (value, value2, sourceRange) -> new StringValue(value.getString((SourceRange)sourceRange) + value2.getString((SourceRange)sourceRange))));
        functions.add(new FunctionVarArg("asNumber", NumberValue.invalid, (valueArray, sourceRange) -> {
            if (((Value[])valueArray).length < 1 || ((Value[])valueArray).length > 2) {
                throw new AsmErrorException("Invalid number of arguments. The asNumber funtion takes zero or one argument", (SourceRange)sourceRange);
            }
            String string = valueArray[0].getString((SourceRange)sourceRange);
            int n = ((Value[])valueArray).length < 2 ? 10 : valueArray[1].getInt((SourceRange)sourceRange);
            try {
                if (n == 10) {
                    return new NumberValue(Double.parseDouble(string));
                }
                return new NumberValue(Long.parseLong(string, n));
            }
            catch (NumberFormatException numberFormatException) {
                throw new AsmErrorException("Not a valid number : " + string, (SourceRange)sourceRange);
            }
        }));
        functions.add(new Function2Arg("charAt", invalid, (value, value2, sourceRange) -> {
            String string = value.getString((SourceRange)sourceRange);
            int n = value2.getInt((SourceRange)sourceRange);
            if (n < 0 || string.length() <= n) {
                throw new AsmErrorException("Index out of bounds: " + n, (SourceRange)sourceRange);
            }
            return CharValue.encode(string.charAt(n));
        }));
        functions.add(new Function3Arg("substring", invalid, (value, value2, value3, sourceRange) -> {
            String string = value.getString((SourceRange)sourceRange);
            int n = value2.getInt((SourceRange)sourceRange);
            int n2 = value3.getInt((SourceRange)sourceRange);
            if (n < 0) {
                throw new AsmErrorException("Start index out of bounds: " + n, (SourceRange)sourceRange);
            }
            if (n2 > string.length()) {
                throw new AsmErrorException("End index out of bounds: " + n2, (SourceRange)sourceRange);
            }
            if (n > n2) {
                throw new AsmErrorException("End index bigger than startindex: " + n + "," + n2, (SourceRange)sourceRange);
            }
            return new StringValue(string.substring(n, n2));
        }));
        functions.add(new Function1Arg("toUpperCase", invalid, (value, sourceRange) -> new StringValue(value.getString((SourceRange)sourceRange).toUpperCase())));
        functions.add(new Function1Arg("toLowerCase", invalid, (value, sourceRange) -> new StringValue(value.getString((SourceRange)sourceRange).toLowerCase())));
    }
}

