/*
 * Decompiled with CFR 0.152.
 */
package kickass.state.segments.resolvers;

import kickass.common.exceptions.AsmErrorException;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.state.EvaluationState;
import kickass.state.segments.Segment;
import kickass.state.segments.resolvers.IStartResolver;

public class AfterSegmentStartResolver
implements IStartResolver {
    private String segmentName;
    private Integer align;
    private EvaluationState state;
    private SourceRange range;
    boolean resolving = false;

    public AfterSegmentStartResolver(String string, Integer n, SourceRange sourceRange, EvaluationState evaluationState) {
        this.segmentName = string;
        this.align = n;
        this.state = evaluationState;
        this.range = sourceRange;
    }

    @Override
    public int resolve() {
        int n;
        Segment segment = this.state.segmentMgr.getSegment(this.segmentName);
        if (segment == null) {
            if (!this.state.segmentMgr.allSegmentsAreRegistered) {
                return -1;
            }
            throw new AsmErrorException("Unknown segment '" + this.segmentName + "'", this.range);
        }
        if (this.resolving) {
            throw new AsmErrorException("Can't resolve start address. Segment '" + this.segmentName + "' is part of a circular reference.", this.range);
        }
        this.resolving = true;
        int n2 = segment.getResolvedEndPc();
        this.resolving = false;
        if (n2 < 0) {
            return -1;
        }
        if (this.align != null && (n = this.align - n2 % this.align) != this.align) {
            n2 += n;
        }
        return n2;
    }
}

