/*
 * Decompiled with CFR 0.152.
 */
package com.github.mistertea.updater;

import com.github.mistertea.updater.ClientDatabaseEngine;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.zip.GZIPInputStream;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;

public class Updater {
    private static final String UPDATER_DB_RAN_ONCE_TOOLS_TXT = "UpdaterDB/RanOnceTools1.txt";
    private static final String UPDATER_DB_RAN_ONCE_MAIN_TXT = "UpdaterDB/RanOnceMain1.txt";
    private static final int NUM_FTP_THREADS = 3;
    boolean finished = false;
    int sumCompleted;
    int totalWork;

    public static boolean isWindows() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.indexOf("win") >= 0;
    }

    public static boolean isMac() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.indexOf("mac") >= 0;
    }

    public static boolean isUnix() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.indexOf("nix") >= 0 || os.indexOf("nux") >= 0;
    }

    public static void main(String[] args) throws Exception {
        ClientDatabaseEngine databaseEngine = new ClientDatabaseEngine(".", "UpdaterDB", false, false, true);
        final ConcurrentMap timestampMap = databaseEngine.getOrCreatePrimitiveMap("TimestampMap");
        Updater.addToolsFirewallExceptions();
        Updater app = new Updater();
        System.out.println("Updating MAMEHub, please be patient!!!");
        System.out.println("Working Directory: " + new File(".").getAbsolutePath());
        if (new File("MAMEHubRepo/.git").exists()) {
            System.out.println("MAMEHub is moving away from git for updating and moving to ftp.  Your old MAMEHubRepo folder will move to MAMEHubRepoOld and a new one will be created");
            System.out.println("Press enter to continue");
            System.in.read();
            Files.move(Paths.get("MAMEHubRepo", new String[0]), Paths.get("MAMEHubRepoOld", new String[0]), StandardCopyOption.REPLACE_EXISTING);
        }
        try {
            ExecutorService threadPool = Executors.newFixedThreadPool(3);
            ArrayList<FTPClient> ftpClients = new ArrayList<FTPClient>();
            ConcurrentLinkedQueue<String> dirsToProcess = new ConcurrentLinkedQueue<String>();
            dirsToProcess.add("/MAMEHubRepo");
            ArrayList<String> allDirs = new ArrayList<String>();
            int a = 0;
            while (a < 3) {
                String server = "10ghost.net";
                FTPClient ftp = new FTPClient();
                try {
                    ftp.connect(server);
                    System.out.println("Connected to " + server);
                    int n = ftp.getReplyCode();
                    if (!FTPReply.isPositiveCompletion(n)) {
                        ftp.disconnect();
                        System.err.println("FTP server refused connection.");
                        throw new RuntimeException("FTP server refused connection.");
                    }
                }
                catch (IOException iOException) {
                    if (ftp.isConnected()) {
                        try {
                            ftp.disconnect();
                        }
                        catch (IOException iOException2) {
                            // empty catch block
                        }
                    }
                    System.err.println("Could not connect to server.");
                    iOException.printStackTrace();
                    throw new RuntimeException("Could not connect to server.");
                }
                if (!ftp.login("anonymous", "anonymous")) {
                    System.out.println("Could not log into ftp server");
                    ftp.logout();
                    throw new RuntimeException("Could not log into ftp server.");
                }
                ftp.enterLocalPassiveMode();
                ftp.setFileType(2);
                ftpClients.add(ftp);
                if (a == 0) {
                    System.out.println("Fetching directories...");
                    while (!dirsToProcess.isEmpty()) {
                        String string = (String)dirsToProcess.poll();
                        System.out.println(string);
                        allDirs.add(string);
                        FTPFile[] fTPFileArray = ftp.listFiles(string);
                        int n = fTPFileArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            FTPFile f = fTPFileArray[n2];
                            if (f.isDirectory()) {
                                dirsToProcess.add(String.valueOf(string) + "/" + f.getName());
                            }
                            ++n2;
                        }
                    }
                }
                ++a;
            }
            final ConcurrentLinkedQueue filesToProcess = new ConcurrentLinkedQueue(allDirs);
            ArrayList futures = new ArrayList();
            final HashSet existingFiles = new HashSet(timestampMap.keySet());
            for (final FTPClient fTPClient : ftpClients) {
                Future<?> future = threadPool.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            while (!filesToProcess.isEmpty()) {
                                String dir = (String)filesToProcess.poll();
                                System.out.println("Processing " + dir);
                                FTPFile[] fTPFileArray = fTPClient.listFiles(dir);
                                int n = fTPFileArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    FTPFile f = fTPFileArray[n2];
                                    if (!f.isDirectory() && f.isFile()) {
                                        long serverTimestamp = f.getTimestamp().getTimeInMillis();
                                        String filename = f.getName();
                                        String localPath = String.valueOf(dir.substring(1)) + "/" + filename;
                                        existingFiles.remove(localPath);
                                        File localFile = new File(localPath);
                                        long sizeInBytes = f.getSize();
                                        if (!localFile.exists() || !timestampMap.containsKey(localPath) || (Long)timestampMap.get(localPath) < serverTimestamp || localFile.length() != sizeInBytes) {
                                            int bytesRead;
                                            System.out.print(String.valueOf(localPath) + " is new/changed: ");
                                            System.out.println("Sizes: " + localFile.length() + " == " + sizeInBytes);
                                            System.out.println("Modified Times: " + timestampMap.get(localPath) + " == " + serverTimestamp);
                                            localFile.getParentFile().mkdirs();
                                            FileOutputStream os = new FileOutputStream(localFile);
                                            BufferedInputStream is = new BufferedInputStream(fTPClient.retrieveFileStream(String.valueOf(dir) + "/" + filename));
                                            byte[] buffer = new byte[131072];
                                            long totalBytesRead = 0L;
                                            long lastPercent = 0L;
                                            while ((bytesRead = ((InputStream)is).read(buffer)) != -1) {
                                                long nextPercent = (totalBytesRead += (long)bytesRead) * 10L / sizeInBytes * 10L;
                                                if (nextPercent != lastPercent) {
                                                    lastPercent = nextPercent;
                                                    System.out.print(".");
                                                }
                                                ((OutputStream)os).write(buffer, 0, bytesRead);
                                            }
                                            ((InputStream)is).close();
                                            ((OutputStream)os).close();
                                            boolean ok = fTPClient.completePendingCommand();
                                            if (!ok) {
                                                throw new IOException("File transfer did not complete");
                                            }
                                            timestampMap.put(localPath, serverTimestamp);
                                        }
                                    }
                                    ++n2;
                                }
                            }
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
                futures.add(future);
            }
            for (Future future : futures) {
                future.get();
            }
            threadPool.shutdown();
            for (String string : existingFiles) {
                new File(string).delete();
                timestampMap.remove(string);
            }
            for (FTPClient fTPClient : ftpClients) {
                fTPClient.disconnect();
            }
            databaseEngine.commit();
            if (!new File("MAMEHubRepo/Binaries").exists()) {
                System.out.println("Update FAILED");
                throw new RuntimeException("Update failed.");
            }
            System.out.println("Update complete.  Fetching emulator.");
            HashSet<PosixFilePermission> hashSet = new HashSet<PosixFilePermission>();
            hashSet.add(PosixFilePermission.OWNER_READ);
            hashSet.add(PosixFilePermission.OWNER_WRITE);
            hashSet.add(PosixFilePermission.OWNER_EXECUTE);
            ArrayList<URL> urls = new ArrayList<URL>();
            if (Updater.isMac()) {
                urls.add(new URL("http://10ghost.net/MAMEHubDownloads/Emulators/Mac/csume64"));
            } else if (Updater.isUnix()) {
                if (System.getProperty("sun.arch.data.model").equals("64")) {
                    urls.add(new URL("http://10ghost.net/MAMEHubDownloads/Emulators/Linux/csume64"));
                } else {
                    urls.add(new URL("http://10ghost.net/MAMEHubDownloads/Emulators/Linux32/csume"));
                }
            } else if (Updater.isWindows()) {
                boolean is64bit;
                boolean bl = is64bit = System.getenv("ProgramFiles(x86)") != null;
                if (is64bit) {
                    urls.add(new URL("http://10ghost.net/MAMEHubDownloads/Emulators/Windows/csume64.exe"));
                    urls.add(new URL("http://10ghost.net/MAMEHubDownloads/Emulators/Windows/csume64.sym"));
                } else {
                    urls.add(new URL("http://10ghost.net/MAMEHubDownloads/Emulators/Windows/csume.exe"));
                    urls.add(new URL("http://10ghost.net/MAMEHubDownloads/Emulators/Windows/csume.sym"));
                }
            }
            int a2 = 0;
            while (a2 < urls.size()) {
                app.wget((URL)urls.get(a2), "MAMEHubRepo/Binaries/dist");
                ++a2;
            }
            try {
                if (Updater.isMac()) {
                    Files.setPosixFilePermissions(FileSystems.getDefault().getPath("MAMEHubRepo/Binaries/dist/csume64", new String[0]), hashSet);
                } else if (Updater.isUnix()) {
                    if (System.getProperty("sun.arch.data.model").equals("64")) {
                        Files.setPosixFilePermissions(FileSystems.getDefault().getPath("MAMEHubRepo/Binaries/dist/csume64", new String[0]), hashSet);
                    } else {
                        Files.setPosixFilePermissions(FileSystems.getDefault().getPath("MAMEHubRepo/Binaries/dist/csume", new String[0]), hashSet);
                    }
                } else if (Updater.isWindows()) {
                    boolean is64bit;
                    boolean bl = is64bit = System.getenv("ProgramFiles(x86)") != null;
                    if (is64bit) {
                        Files.setPosixFilePermissions(FileSystems.getDefault().getPath("MAMEHubRepo/Binaries/dist/csume64.exe", new String[0]), hashSet);
                    } else {
                        Files.setPosixFilePermissions(FileSystems.getDefault().getPath("MAMEHubRepo/Binaries/dist/csume.exe", new String[0]), hashSet);
                    }
                }
            }
            catch (UnsupportedOperationException e) {
                System.out.println("Could not chmod file" + e.toString());
            }
            System.out.println("Fetching frontend...");
            app.wget(new URL("http://10ghost.net/MAMEHubDownloads/Frontend/MAMEHubClient.jar"), "MAMEHubRepo/Binaries/dist");
            Updater.addMainFirewallExceptions();
        }
        catch (Exception e) {
            System.out.println("Error getting updates, please copy the error from the console and file a bug here: https://github.com/MisterTea/MAMEHub/issues");
            e.printStackTrace();
            System.in.read();
        }
        app.finished = true;
        databaseEngine.close();
    }

    private static void addToolsFirewallExceptions() throws IOException {
        boolean firstTime;
        boolean bl = firstTime = !new File(UPDATER_DB_RAN_ONCE_TOOLS_TXT).exists();
        if (firstTime && Updater.isWindows()) {
            String[][] lCommands;
            System.out.println("Configuring windows firewall for tools...");
            String[][] commands = System.getProperty("os.version").equals("5.1") ? (lCommands = new String[][]{{"netsh", "firewall", "add", "allowedprogram", "program=Tools\\Updater.exe", "name=MAMEHub Updater"}, {"netsh", "firewall", "add", "allowedprogram", "program=Tools\\wget.exe", "name=MAMEHub WGet"}}) : (lCommands = new String[][]{{"netsh", "advfirewall", "firewall", "add", "rule", "dir=in", "action=allow", "program=Tools\\Updater.exe", "name=MAMEHub Updater In", "enable=yes"}, {"netsh", "advfirewall", "firewall", "add", "rule", "dir=out", "action=allow", "program=Tools\\Updater.exe", "name=MAMEHub Updater Out", "enable=yes"}, {"netsh", "advfirewall", "firewall", "add", "rule", "dir=in", "action=allow", "program=Tools\\wget.exe", "name=MAMEHub WGet In", "enable=yes"}, {"netsh", "advfirewall", "firewall", "add", "rule", "dir=out", "action=allow", "program=Tools\\wget.exe", "name=MAMEHub WGet Out", "enable=yes"}});
            String[][] stringArrayArray = commands;
            int n = commands.length;
            int n2 = 0;
            while (n2 < n) {
                String[] command = stringArrayArray[n2];
                ProcessBuilder pb = new ProcessBuilder(command);
                pb.redirectErrorStream(true);
                Process process = pb.start();
                BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    System.out.println(line);
                }
                ++n2;
            }
        }
        new File(UPDATER_DB_RAN_ONCE_TOOLS_TXT).createNewFile();
    }

    private static void addMainFirewallExceptions() throws IOException {
        boolean firstTime;
        boolean bl = firstTime = !new File(UPDATER_DB_RAN_ONCE_MAIN_TXT).exists();
        if (firstTime && Updater.isWindows()) {
            String[][] lCommands;
            System.out.println("Configuring windows firewall for main binaries...");
            String[][] commands = System.getProperty("os.version").equals("5.1") ? (lCommands = new String[][]{{"netsh", "firewall", "add", "allowedprogram", "program=MAMEHubRepo\\Binaries\\dist\\MAMEHubClient.exe", "name=MAMEHub Client"}, {"netsh", "firewall", "add", "allowedprogram", "program=MAMEHubRepo\\Binaries\\dist\\csume.exe", "name=csume"}, {"netsh", "firewall", "add", "allowedprogram", "program=MAMEHubRepo\\Binaries\\dist\\csume64.exe", "name=csume"}}) : (lCommands = new String[][]{{"netsh", "advfirewall", "firewall", "add", "rule", "dir=in", "action=allow", "program=MAMEHubRepo\\Binaries\\dist\\MAMEHubClient.exe", "name=MAMEHub Client In", "enable=yes"}, {"netsh", "advfirewall", "firewall", "add", "rule", "dir=out", "action=allow", "program=MAMEHubRepo\\Binaries\\dist\\MAMEHubClient.exe", "name=MAMEHub Client Out", "enable=yes"}, {"netsh", "advfirewall", "firewall", "add", "rule", "dir=in", "action=allow", "program=MAMEHubRepo\\Binaries\\dist\\csume.exe", "name=csume In", "enable=yes"}, {"netsh", "advfirewall", "firewall", "add", "rule", "dir=out", "action=allow", "program=MAMEHubRepo\\Binaries\\dist\\csume.exe", "name=csume Out", "enable=yes"}, {"netsh", "advfirewall", "firewall", "add", "rule", "dir=in", "action=allow", "program=MAMEHubRepo\\Binaries\\dist\\csume64.exe", "name=csume64 In", "enable=yes"}, {"netsh", "advfirewall", "firewall", "add", "rule", "dir=out", "action=allow", "program=MAMEHubRepo\\Binaries\\dist\\csume64.exe", "name=csume64 Out", "enable=yes"}});
            String[][] stringArrayArray = commands;
            int n = commands.length;
            int n2 = 0;
            while (n2 < n) {
                String[] command = stringArrayArray[n2];
                ProcessBuilder pb = new ProcessBuilder(command);
                pb.redirectErrorStream(true);
                Process process = pb.start();
                BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    System.out.println(line);
                }
                ++n2;
            }
        }
        new File(UPDATER_DB_RAN_ONCE_MAIN_TXT).createNewFile();
    }

    private void stopThinking() {
        this.finished = true;
    }

    public void wget(URL url, String destination) throws IOException, InterruptedException {
        String s;
        String[] cmd = new String[]{"tools/wget", "-P" + destination, "-N", String.valueOf(url.toString()) + ".gz"};
        if (!Updater.isWindows()) {
            cmd[0] = "wget";
        }
        String[] stringArray = cmd;
        int n = cmd.length;
        int n2 = 0;
        while (n2 < n) {
            String s2 = stringArray[n2];
            System.out.print(String.valueOf(s2) + " ");
            ++n2;
        }
        System.out.println("");
        ProcessBuilder pb = new ProcessBuilder(cmd);
        pb.redirectErrorStream(true);
        Process p = pb.start();
        BufferedReader r = new BufferedReader(new InputStreamReader(p.getInputStream()));
        while ((s = r.readLine()) != null) {
            System.out.println(s);
        }
        int val = p.waitFor();
        if (val != 0) {
            throw new IOException("Exception during wget; return code = " + val);
        }
        System.out.println("WGET COMPLETE");
        String urlString = url.toString();
        String fileName = urlString.substring(urlString.lastIndexOf(47) + 1, urlString.length());
        this.gunzip(new File("MAMEHubRepo/Binaries/dist/" + fileName + ".gz"), new File("MAMEHubRepo/Binaries/dist/" + fileName));
    }

    public void gunzip(File source, File dest) {
        byte[] buffer = new byte[1024];
        try {
            int len;
            GZIPInputStream gzis = new GZIPInputStream(new FileInputStream(source));
            FileOutputStream out = new FileOutputStream(dest);
            while ((len = gzis.read(buffer)) > 0) {
                out.write(buffer, 0, len);
            }
            gzis.close();
            out.close();
            System.out.println("Done");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void start(int totalTasks) {
        System.out.println("Total Tasks: " + totalTasks);
        this.sumCompleted = 0;
        this.totalWork = 0;
    }

    public void beginTask(String title, int totalWork) {
        this.totalWork = totalWork;
        this.sumCompleted = 0;
        System.out.println("Beginning: " + title + " : " + totalWork);
    }

    public void update(int completed) {
        if (this.totalWork > 0) {
            if (this.sumCompleted * 100 / this.totalWork != (this.sumCompleted + completed) * 100 / this.totalWork) {
                System.out.println("Completed: " + (this.sumCompleted + completed) * 100 / this.totalWork + "%");
            }
            this.sumCompleted += completed;
        }
    }

    public void endTask() {
        System.out.println("DONE");
    }

    public boolean isCancelled() {
        return false;
    }
}

