/*
 * Decompiled with CFR 0.152.
 */
package com.github.mistertea.updater;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.mapdb.BTreeMap;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.mapdb.Serializer;

public class ClientDatabaseEngine {
    private static final Logger logger = Logger.getLogger(ClientDatabaseEngine.class.getName());
    private File dbDirectory;
    private String dbFileName;
    public DB database;
    private boolean inMemory;
    private boolean compression;

    public ClientDatabaseEngine(String baseDbDirectory, String dbName, boolean wipe, boolean inMemory, boolean compression) throws IOException {
        this.inMemory = inMemory;
        this.compression = compression;
        logger.info("CREATING NEW DATABASE ENGINE");
        this.dbDirectory = new File(String.valueOf(baseDbDirectory) + "/" + dbName);
        this.dbFileName = this.dbDirectory + "/" + "db";
        logger.info(" db dir: " + this.dbDirectory + " db file" + this.dbFileName);
        if (wipe) {
            this.wipeDatabase();
        } else {
            this.createDatabase(compression);
        }
    }

    private void createDatabase(boolean compression) {
        this.dbDirectory.mkdirs();
        DBMaker dbMaker = null;
        dbMaker = this.inMemory ? DBMaker.newMemoryDirectDB() : DBMaker.newFileDB(new File(this.dbFileName));
        if (compression) {
            dbMaker.compressionEnable();
        }
        this.database = dbMaker.make();
    }

    public synchronized void wipeDatabase() throws IOException {
        System.out.println("WIPING OLD DATABASE");
        if (this.database != null) {
            this.database.close();
        }
        if (!this.inMemory) {
            FileUtils.deleteDirectory(this.dbDirectory);
        }
        this.createDatabase(this.compression);
    }

    public synchronized <T> ConcurrentMap<String, T> getOrCreateMap(Class<T> inClass, String className) {
        BTreeMap dbMap = null;
        if (dbMap == null && (dbMap = this.database.getTreeMap(className)) == null) {
            dbMap = this.database.createTreeMap(className).nodeSize(120).counterEnable().valueSerializer(new ObjectSerializer()).makeStringMap();
        }
        return dbMap;
    }

    public synchronized <T> ConcurrentMap<String, T> getOrCreatePrimitiveMap(String className) {
        BTreeMap dbMap = null;
        if (dbMap == null && (dbMap = this.database.getTreeMap(className)) == null) {
            dbMap = this.database.createTreeMap(className).nodeSize(120).counterEnable().makeStringMap();
        }
        return dbMap;
    }

    public synchronized void close() {
        if (this.database != null && !this.database.isClosed()) {
            this.database.close();
        }
        this.database = null;
    }

    public synchronized void defrag() {
        this.database.compact();
    }

    public synchronized void commit() {
        this.database.commit();
    }

    public static class ObjectSerializer<T>
    implements Serializer<T>,
    Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public void serialize(DataOutput out, T obj) throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(obj);
            oos.flush();
            oos.close();
            baos.flush();
            baos.close();
            out.writeInt(baos.size());
            out.write(baos.toByteArray());
        }

        @Override
        public T deserialize(DataInput in, int input_size) throws IOException {
            Object o;
            int size = in.readInt();
            byte[] b = new byte[size];
            in.readFully(b);
            ByteArrayInputStream bais = new ByteArrayInputStream(b);
            ObjectInputStream ois = new ObjectInputStream(bais);
            try {
                o = ois.readObject();
            }
            catch (ClassNotFoundException e) {
                throw new IOException(e);
            }
            ois.close();
            bais.close();
            return (T)o;
        }

        @Override
        public int fixedSize() {
            return -1;
        }
    }
}

