/*
 * Decompiled with CFR 0.152.
 */
package achtbit;

import achtbit.Assembler;
import achtbit.Cpu;
import achtbit.CpuState;
import achtbit.Memory;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CpuPanel
extends JPanel
implements Observer {
    private Cpu cpu;
    private Timer timer;
    private ButtonGroup cpuStateGroup;
    private JSlider frequencySlider;
    private JRadioButton haltButton;
    private JLabel jLabel1;
    private JTextField regPCTextField;
    private JRadioButton runButton;
    private JButton stepButton;

    public CpuPanel() {
        this.initComponents();
        Cpu.cpuTakt = 1000;
        this.frequencySlider.setValue(1000);
        this.regPCTextField.setText(Assembler.int2hex(Memory.instance().getPC(), 4));
        CpuState.instance().addObserver(this);
        this.cpu = new Cpu();
        this.timer = new Timer();
        this.timer.schedule((TimerTask)this.cpu, 1L, 1L);
    }

    public void stopCpuThread() {
        this.timer.cancel();
    }

    public void setStartAdress(int adress) {
        this.regPCTextField.setText(Assembler.int2hex(adress, 4));
    }

    public int getTakt() {
        int takt = this.frequencySlider.getValue();
        return takt;
    }

    private void initComponents() {
        this.cpuStateGroup = new ButtonGroup();
        this.haltButton = new JRadioButton();
        this.runButton = new JRadioButton();
        this.frequencySlider = new JSlider();
        this.stepButton = new JButton();
        this.jLabel1 = new JLabel();
        this.regPCTextField = new JTextField();
        this.cpuStateGroup.add(this.haltButton);
        this.haltButton.setSelected(true);
        this.haltButton.setText("Halt");
        this.haltButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CpuPanel.this.haltButtonActionPerformed(evt);
            }
        });
        this.cpuStateGroup.add(this.runButton);
        this.runButton.setText("Run");
        this.runButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CpuPanel.this.runButtonActionPerformed(evt);
            }
        });
        this.frequencySlider.setMajorTickSpacing(100);
        this.frequencySlider.setMaximum(1000);
        this.frequencySlider.setMinimum(1);
        this.frequencySlider.setMinorTickSpacing(50);
        this.frequencySlider.setPaintTicks(true);
        this.frequencySlider.setValue(1000);
        this.frequencySlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                CpuPanel.this.frequencySliderStateChanged(evt);
            }
        });
        this.stepButton.setText("Step");
        this.stepButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CpuPanel.this.stepButtonActionPerformed(evt);
            }
        });
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setText("1000 kHz");
        this.regPCTextField.setText("0000");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.frequencySlider, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.regPCTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.haltButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.runButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.stepButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jLabel1)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.frequencySlider, -2, -1, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jLabel1)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 59, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.regPCTextField, -2, -1, -2).addComponent(this.haltButton).addComponent(this.runButton).addComponent(this.stepButton))))));
    }

    @Override
    public void update(Observable o, Object o1) {
        if (!(o instanceof CpuState)) {
            return;
        }
        if (CpuState.instance().isRunning()) {
            this.runButton.setSelected(true);
        } else {
            this.haltButton.setSelected(true);
        }
    }

    public void haltCpu() {
        if (!CpuState.instance().isRunning()) {
            return;
        }
        CpuState.instance().halt();
        this.regPCTextField.setText(Assembler.int2hex(Memory.instance().getPC(), 4));
    }

    public void runCpu() {
        if (CpuState.instance().getState() == CpuState.State.cpuRun) {
            return;
        }
        Memory.instance().setPC(Assembler.hex2int(this.regPCTextField.getText()));
        CpuState.instance().run();
    }

    public void stepCpu() {
        if (!CpuState.instance().isRunning()) {
            Memory.instance().setPC(Assembler.hex2int(this.regPCTextField.getText()));
        }
        CpuState.instance().step();
        while (CpuState.instance().getState() == CpuState.State.cpuStep) {
        }
        this.regPCTextField.setText(Assembler.int2hex(Memory.instance().getPC(), 4));
    }

    private void haltButtonActionPerformed(ActionEvent evt) {
        this.haltCpu();
    }

    private void runButtonActionPerformed(ActionEvent evt) {
        this.runCpu();
    }

    private void frequencySliderStateChanged(ChangeEvent evt) {
        int f;
        Cpu.cpuTakt = f = this.getTakt();
        this.jLabel1.setText(f + " kHz");
    }

    private void stepButtonActionPerformed(ActionEvent evt) {
        this.stepCpu();
    }
}

