/*
 * Decompiled with CFR 0.152.
 */
package achtbit;

import java.awt.event.KeyEvent;
import java.util.ArrayDeque;
import java.util.Deque;

public class Keyboard {
    private Deque<Integer> buffer = new ArrayDeque<Integer>();
    private static Keyboard uniqueInstance = null;

    private Keyboard() {
    }

    public static Keyboard instance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Keyboard();
        }
        return uniqueInstance;
    }

    public void clear() {
        this.buffer.clear();
    }

    public int getKey() {
        if (this.buffer.isEmpty()) {
            return 0;
        }
        return this.buffer.pollFirst();
    }

    public void putKey(int key) {
        if (this.buffer.size() < 50) {
            this.buffer.addLast(key);
        }
    }

    public void keyPressed(KeyEvent evt) {
        if (evt.getKeyChar() == '\uffff') {
            int code = evt.getKeyCode();
            if (code >= 33 && code <= 40) {
                this.putKey(code - 16);
            } else if (code == 155) {
                this.putKey(code);
            }
        } else {
            this.putKey(evt.getKeyChar());
        }
    }
}

