/*
 * Decompiled with CFR 0.152.
 */
package achtbit;

import achtbit.AchtbitPanel;
import achtbit.Assembler;
import achtbit.Memory;
import achtbit.UpdateRequest;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class MemoryPanel
extends JPanel
implements Observer,
AchtbitPanel {
    private int startAdress;
    private UpdateRequest updateRequest;
    private JScrollPane jScrollPane1;
    private JTextArea jTextArea1;
    private JTextField jTextField1;
    private JTextField jTextField2;

    public MemoryPanel() {
        this.initComponents();
        this.jScrollPane1.setVerticalScrollBarPolicy(21);
        this.jScrollPane1.setHorizontalScrollBarPolicy(31);
        this.startAdress = 0;
        this.jTextArea1.repaint();
        this.updateRequest = new UpdateRequest(this);
        Memory.instance().addObserver(this);
    }

    public int getStartAdress() {
        return this.startAdress;
    }

    public void setStartAdress(int startAdress) {
        this.startAdress = startAdress;
        this.repaint();
    }

    public int getMaxLines() {
        int maxLines = this.jTextArea1.getHeight() / this.jTextArea1.getFontMetrics(this.jTextArea1.getFont()).getHeight() - 1;
        return maxLines;
    }

    @Override
    public void paint(Graphics grphcs) {
        this.drawMem(this.startAdress);
        super.paint(grphcs);
    }

    void drawMem(int adress) {
        int a = adress;
        String txt = "";
        int maxLines = this.getMaxLines();
        for (int i = 0; i < maxLines; ++i) {
            txt = txt + Assembler.int2hex(a, 4) + " -";
            String asc = "";
            for (int j = 0; j < 8; ++j) {
                int b = Memory.instance().getByte(a);
                txt = txt + " " + Assembler.int2hex(b, 2);
                asc = asc + (char)(b >= 32 ? (int)b : 46);
                ++a;
            }
            txt = txt + " " + asc;
            if (i + 1 >= maxLines) continue;
            txt = txt + "\n";
        }
        this.jTextArea1.setText(txt);
    }

    @Override
    public void update(Observable o, Object o1) {
        if (!this.isVisible()) {
            return;
        }
        if (!(o instanceof Memory)) {
            return;
        }
        if (!(o1 instanceof Integer)) {
            return;
        }
        Memory mem = (Memory)o;
        int adr = (Integer)o1;
        if (adr < this.startAdress || adr >= this.startAdress + this.getMaxLines() * 8) {
            return;
        }
        if (this.updateRequest.isDone()) {
            this.updateRequest.setDone(false);
            EventQueue.invokeLater(this.updateRequest);
        }
    }

    @Override
    public void update() {
        this.repaint();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.jTextField1 = new JTextField();
        this.jTextField2 = new JTextField();
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setColumns(15);
        this.jTextArea1.setFont(new Font("Monospaced", 0, 12));
        this.jTextArea1.setRows(5);
        this.jTextArea1.setText("0000 - 00 00 00 00 00 00 00 00 AAAAAAAA\n0000 - 00 00 00 00 00 00 00 00 AAAAAAAA\n0000 - 00 00 00 00 00 00 00 00 AAAAAAAA\n0000 - 00 00 00 00 00 00 00 00 AAAAAAAA\n0000 - 00 00 00 00 00 00 00 00 AAAAAAAA\n0000 - 00 00 00 00 00 00 00 00 AAAAAAAA\n0000 - 00 00 00 00 00 00 00 00 AAAAAAAA\n0000 - 00 00 00 00 00 00 00 00 AAAAAAAA\n0000 - 00 00 00 00 00 00 00 00 AAAAAAAA\n0000 - 00 00 00 00 00 00 00 00 AAAAAAAA\n0000 - 00 00 00 00 00 00 00 00 AAAAAAAA\n0000 - 00 00 00 00 00 00 00 00 AAAAAAAA\n0000 - 00 00 00 00 00 00 00 00 AAAAAAAA\n0000 - 00 00 00 00 00 00 00 00 AAAAAAAA\n0000 - 00 00 00 00 00 00 00 00 AAAAAAAA\n0000 - 00 00 00 00 00 00 00 00 AAAAAAAA\n0000 - 00 00 00 00 00 00 00 00 AAAAAAAA\n0000 - 00 00 00 00 00 00 00 00 AAAAAAAA\n0000 - 00 00 00 00 00 00 00 00 AAAAAAAA\n0000 - 00 00 00 00 00 00 00 00 AAAAAAAA\n0000 - 00 00 00 00 00 00 00 00 AAAAAAAA\n0000 - 00 00 00 00 00 00 00 00 AAAAAAAA\n0000 - 00 00 00 00 00 00 00 00 AAAAAAAA\n0000 - 00 00 00 00 00 00 00 00 AAAAAAAA");
        this.jScrollPane1.setViewportView(this.jTextArea1);
        this.jTextField1.setFont(new Font("Monospaced", 0, 12));
        this.jTextField1.setText("0000");
        this.jTextField1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MemoryPanel.this.jTextField1ActionPerformed(evt);
            }
        });
        this.jTextField2.setFont(new Font("Monospaced", 0, 12));
        this.jTextField2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MemoryPanel.this.jTextField2ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jTextField1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField2, -1, 241, Short.MAX_VALUE)).addComponent(this.jScrollPane1));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 368, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextField1, -2, -1, -2).addComponent(this.jTextField2, -2, -1, -2))));
    }

    private void jTextField1ActionPerformed(ActionEvent evt) {
        this.setStartAdress(Assembler.hex2int(this.jTextField1.getText()));
        this.jTextField1.transferFocus();
    }

    private void jTextField2ActionPerformed(ActionEvent evt) {
        int adress = Assembler.hex2int(this.jTextField1.getText());
        String d = this.jTextField2.getText();
        if (d.charAt(0) == '\"' || d.charAt(0) == '\'') {
            if (d.charAt(d.length() - 1) != d.charAt(0)) {
                d = d + d.charAt(0);
            }
            for (int i = 1; i < d.length() - 1; ++i) {
                Memory.instance().setByte(adress, d.charAt(i), true);
                ++adress;
            }
        } else {
            String[] hs;
            for (String s : hs = d.split(" ")) {
                Memory.instance().setByte(adress, Assembler.hex2int(s), true);
                ++adress;
            }
        }
        this.jTextField2.setText("");
        this.jTextField1.setText(Assembler.int2hex(adress, 4));
    }
}

