/*
 * Decompiled with CFR 0.152.
 */
package achtbit;

import achtbit.AchtbitPanel;
import achtbit.CpuState;
import achtbit.Memory;
import achtbit.UpdateRequest;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.Calendar;
import java.util.Date;
import java.util.Observable;
import java.util.Observer;
import javax.imageio.ImageIO;
import javax.swing.GroupLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class ScreenJPanel
extends JPanel
implements Observer,
AchtbitPanel {
    public static final int textInputBuffer = 53760;
    public static final int charset = 54784;
    public static final int screen = 57344;
    public static final int textPalette = 58368;
    public static final int palette = 65344;
    public static final int gfxMode = 65392;
    public static final int gfxColor = 65393;
    public static final int screenRefresh = 65394;
    public static final int screenInterrupt = 65395;
    public static final int cursorPosition = 65398;
    public static final int textColor = 65400;
    public static final int cursorEnable = 65401;
    public static final int textInputBufferPointer = 65402;
    public static final int cursorSpeed = 65404;
    public static final int timerSec = 65405;
    public static final int timerMin = 65406;
    public static final int timerHour = 65407;
    public static final int timerDay = 65408;
    public static final int timerMonth = 65409;
    public static final int timerYear = 65410;
    public static final int gfxColor1 = 65412;
    private BufferedImage screenImage = null;
    private boolean cursorVisible = false;
    private int cursorCount = 20;
    private boolean fixedZoom = false;
    private UpdateRequest updateRequest;

    public ScreenJPanel() {
        this.initComponents();
        this.resetPalette();
        this.reset();
        this.screenImage = new BufferedImage(320, 200, 5);
        this.update();
        this.updateRequest = new UpdateRequest(this);
        Memory.instance().addObserver(this);
    }

    public final void resetPalette() {
        this.readPalette("stdPalette.png");
        this.readCharset("stdCharset.png");
    }

    public final void reset() {
        Memory mem = Memory.instance();
        mem.setByte(65392, 0);
        mem.setByte(65393, 178);
        mem.setByte(65394, 127);
        mem.setWord(65398, 0);
        mem.setByte(65400, 194);
        mem.setByte(65401, 1);
        mem.setByte(65404, 20);
        mem.setByte(53760, 0);
        mem.setWord(65402, 53760);
        for (int i = 0; i < 800; ++i) {
            mem.setByte(57344 + i, 32);
            mem.setByte(58368 + i, mem.getByte(65400));
        }
        this.cursorCount = mem.getByte(65404);
        this.cursorVisible = false;
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        Memory.instance().setWord(65410, cal.get(1));
        Memory.instance().setByte(65409, cal.get(2) + 1);
        Memory.instance().setByte(65408, cal.get(5));
        Memory.instance().setByte(65407, cal.get(11));
        Memory.instance().setByte(65406, cal.get(12));
        Memory.instance().setByte(65405, cal.get(13));
    }

    public boolean isFixedZoom() {
        return this.fixedZoom;
    }

    public void setFixedZoom(boolean fixedZoom) {
        this.fixedZoom = fixedZoom;
    }

    public void readPalette(String filename) {
        try {
            BufferedImage pal = ImageIO.read(this.getClass().getResource(filename));
            Memory mem = Memory.instance();
            int p = 65344;
            for (int c = 0; c < 16; ++c) {
                int argb = pal.getRGB(c, 0);
                int r = argb >> 16 & 0xFF;
                int g = argb >> 8 & 0xFF;
                int b = argb & 0xFF;
                mem.setByte(p, r, true);
                mem.setByte(p + 1, g, true);
                mem.setByte(p + 2, b, true);
                p += 3;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void readCharset(String filename) {
        try {
            BufferedImage cs = ImageIO.read(this.getClass().getResource(filename));
            Memory mem = Memory.instance();
            int p = 54784;
            int y = 0;
            for (int j = 0; j < 16; ++j) {
                int x = 0;
                for (int i = 0; i < 16; ++i) {
                    for (int l = 0; l < 10; ++l) {
                        int b = 0;
                        for (int k = 0; k < 8; ++k) {
                            b <<= 1;
                            if (cs.getRGB(x + k, y + l) == -1) continue;
                            ++b;
                        }
                        mem.setByte(p, b, true);
                        ++p;
                    }
                    x += 8;
                }
                y += 10;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final synchronized void drawScreen() {
        Memory mem = Memory.instance();
        if (mem.getByte(65392) == 1) {
            int p = 57344;
            int c = mem.getByte(65393);
            int fg = (c & 0xF) * 3 + 65344;
            int bg = c / 16 * 3 + 65344;
            Color fgcolor = new Color(mem.getByte(fg), mem.getByte(fg + 1), mem.getByte(fg + 2));
            Color bgcolor = new Color(mem.getByte(bg), mem.getByte(bg + 1), mem.getByte(bg + 2));
            for (int y = 0; y < 200; ++y) {
                for (int x = 0; x < 40; ++x) {
                    this.drawByte(x, y, mem.getByte(p), fgcolor, bgcolor);
                    ++p;
                }
            }
        } else if (mem.getByte(65392) == 2) {
            int p = 57344;
            int c = mem.getByte(65393);
            int c1 = mem.getByte(65412);
            int f0 = c / 16 * 3 + 65344;
            int f1 = (c & 0xF) * 3 + 65344;
            int f2 = 65344;
            int f3 = (c1 & 0xF) * 3 + 65344;
            Color[] color = new Color[]{new Color(mem.getByte(f0), mem.getByte(f0 + 1), mem.getByte(f0 + 2)), new Color(mem.getByte(f1), mem.getByte(f1 + 1), mem.getByte(f1 + 2)), new Color(mem.getByte(f2), mem.getByte(f2 + 1), mem.getByte(f2 + 2)), new Color(mem.getByte(f3), mem.getByte(f3 + 1), mem.getByte(f3 + 2))};
            for (int y = 0; y < 200; ++y) {
                for (int x = 0; x < 40; ++x) {
                    this.drawTupel(x, y, mem.getByte(p), color);
                    ++p;
                }
            }
        } else if (mem.getByte(65392) == 3) {
            int p = 57344;
            for (int y = 0; y < 100; ++y) {
                for (int x = 0; x < 80; ++x) {
                    int b = mem.getByte(p) & 0xFF;
                    int c0 = b / 16 * 3 + 65344;
                    int c1 = (b & 0xF) * 3 + 65344;
                    Color color0 = new Color(mem.getByte(c0), mem.getByte(c0 + 1), mem.getByte(c0 + 2));
                    Color color1 = new Color(mem.getByte(c1), mem.getByte(c1 + 1), mem.getByte(c1 + 2));
                    this.draw2x2Pixel(x * 4, y * 2, color0);
                    this.draw2x2Pixel(x * 4 + 2, y * 2, color1);
                    ++p;
                }
            }
        } else {
            int p = 57344;
            int pc = 58368;
            for (int y = 0; y < 20; ++y) {
                for (int x = 0; x < 40; ++x) {
                    this.drawChar(x, y, mem.getByte(p), mem.getByte(pc));
                    ++p;
                    ++pc;
                }
            }
            if (mem.getByte(65401) != 0 && this.cursorVisible) {
                int x = mem.getByte(65398);
                int y = mem.getByte(65399);
                p = x + y * 40;
                this.drawChar(x, y, mem.getByte(57344 + p), mem.getByte(58368 + p) ^ 0xFF);
            }
        }
    }

    public void drawChar(int x, int y, int ch, int c) {
        Memory mem = Memory.instance();
        int fg = (c & 0xF) * 3 + 65344;
        int bg = c / 16 * 3 + 65344;
        Color fgcolor = new Color(mem.getByte(fg), mem.getByte(fg + 1), mem.getByte(fg + 2));
        Color bgcolor = new Color(mem.getByte(bg), mem.getByte(bg + 1), mem.getByte(bg + 2));
        int pch = ch * 10 + 54784;
        for (int j = 0; j < 10; ++j) {
            this.drawByte(x, y * 10 + j, mem.getByte(pch), fgcolor, bgcolor);
            ++pch;
        }
    }

    public void drawByte(int x, int y, int bt, Color fg, Color bg) {
        Memory mem = Memory.instance();
        int b = bt;
        for (int i = 0; i < 8; ++i) {
            if ((b & 0x80) > 0) {
                this.screenImage.setRGB(x * 8 + i, y, fg.getRGB());
            } else {
                this.screenImage.setRGB(x * 8 + i, y, bg.getRGB());
            }
            b <<= 1;
        }
    }

    public void drawTupel(int x, int y, int bt, Color[] color) {
        Memory mem = Memory.instance();
        int b = bt;
        for (int i = 0; i < 4; ++i) {
            int c = b >> 6 & 3;
            this.screenImage.setRGB(x * 8 + i * 2, y, color[c].getRGB());
            this.screenImage.setRGB(x * 8 + i * 2 + 1, y, color[c].getRGB());
            b <<= 2;
        }
    }

    public void draw2x2Pixel(int x, int y, Color color) {
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                this.screenImage.setRGB(x + i, y + j, color.getRGB());
            }
        }
    }

    @Override
    public void update(Observable o, Object o1) {
        if (!(o instanceof Memory)) {
            return;
        }
        if ((Memory.instance().getByte(65394) & 1) == 0) {
            return;
        }
        Memory.instance().setByte(65394, 0);
        if (CpuState.instance().isRunning()) {
            --this.cursorCount;
            if (this.cursorCount == 0) {
                this.cursorCount = Memory.instance().getByte(65404);
                boolean bl = this.cursorVisible = !this.cursorVisible;
            }
        }
        if (this.updateRequest.isDone()) {
            this.updateRequest.setDone(false);
            EventQueue.invokeLater(this.updateRequest);
        }
    }

    @Override
    public void update() {
        this.drawScreen();
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        if (this.screenImage == null) {
            return;
        }
        int w = this.getWidth();
        int h = this.getHeight();
        g.setColor(Color.black);
        g.fillRect(0, 0, w, h);
        if (!this.fixedZoom) {
            if (w > h * 8 / 5) {
                w = h * 8 / 5;
            } else {
                h = w * 5 / 8;
            }
        } else {
            int zh;
            int zw = w / this.screenImage.getWidth();
            int z = zw < (zh = h / this.screenImage.getHeight()) ? zw : zh;
            w = this.screenImage.getWidth() * z;
            h = this.screenImage.getHeight() * z;
        }
        int x = (this.getWidth() - w) / 2;
        int y = (this.getHeight() - h) / 2;
        g.drawImage(this.screenImage, x, y, w, h, this);
    }

    private void initComponents() {
        this.setFocusCycleRoot(true);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }

    public static void main(String[] args) {
        ScreenJPanel sp = new ScreenJPanel();
        JFrame f = new JFrame();
        f.add(sp);
        f.setVisible(true);
        Memory.instance().setByte(65392, 0);
        for (int i = 0; i < 255; ++i) {
            Memory.instance().setByte(57344 + (i & 0xF) + i / 16 * 40, i, true);
            Memory.instance().setByte(65400 + (i & 0xF) + i / 16 * 40, i, true);
        }
        sp.drawScreen();
        sp.repaint();
    }
}

