/*
 * Decompiled with CFR 0.152.
 */
package achtbit;

import achtbit.AssemblerPanel;
import achtbit.Cpu;
import achtbit.CpuPanel;
import achtbit.CpuState;
import achtbit.Keyboard;
import achtbit.Memory;
import achtbit.MemoryPanel;
import achtbit.RegisterJPanel;
import achtbit.RomAreaDialog;
import achtbit.SaveMemDialog;
import achtbit.ScreenJPanel;
import achtbit.SoundThread;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Observable;
import java.util.Observer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.filechooser.FileNameExtensionFilter;

public class AchtBitJFrame
extends JFrame
implements Observer {
    private JMenuItem LoadMenuItem;
    private JMenuItem QuitAchtBitMenuItem;
    private JMenuItem SaveMenuItem;
    private AssemblerPanel assemblerPanel;
    private JCheckBoxMenuItem assemblerPanelCheckBoxMenuItem;
    private CpuPanel cpuPanel;
    private JCheckBoxMenuItem cpuPanelCheckBoxMenuItem;
    private JMenu fileMenu;
    private JCheckBoxMenuItem fixedZoomCheckBoxMenuItem;
    private JMenuItem hardResetMenuItem;
    private JCheckBoxMenuItem jCheckBoxMenuItem1;
    private JMenu jMenu1;
    private JPopupMenu.Separator jSeparator1;
    private MemoryPanel memoryPanel;
    private JCheckBoxMenuItem memoryPanelCheckBoxMenuItem;
    private JMenuBar menuBar;
    private RegisterJPanel registerPanel;
    private JCheckBoxMenuItem registerPanelCheckBoxMenuItem;
    private JMenuItem romAreaMenuItem;
    private JCheckBoxMenuItem screenInterruptCheckBoxMenuItem;
    private ScreenJPanel screenPanel;
    private JMenuItem softResetMenuItem;
    private JMenu viewMenu;

    public AchtBitJFrame() {
        this.initComponents();
        this.registerPanel.setVisible(false);
        this.assemblerPanel.setVisible(false);
        this.memoryPanel.setVisible(false);
        this.cpuPanel.setVisible(false);
        this.screenPanel.grabFocus();
        Memory.instance().loadFromAssembler(AchtBitJFrame.getJarExecutionDirectory() + "roms/achtBit_rom.asm");
        CpuState.instance().addObserver(this);
        CpuState.instance().run();
    }

    private void initComponents() {
        this.cpuPanel = new CpuPanel();
        this.memoryPanel = new MemoryPanel();
        this.assemblerPanel = new AssemblerPanel();
        this.registerPanel = new RegisterJPanel();
        this.screenPanel = new ScreenJPanel();
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.LoadMenuItem = new JMenuItem();
        this.SaveMenuItem = new JMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.QuitAchtBitMenuItem = new JMenuItem();
        this.viewMenu = new JMenu();
        this.registerPanelCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.assemblerPanelCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.memoryPanelCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.cpuPanelCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.fixedZoomCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.jMenu1 = new JMenu();
        this.hardResetMenuItem = new JMenuItem();
        this.softResetMenuItem = new JMenuItem();
        this.romAreaMenuItem = new JMenuItem();
        this.jCheckBoxMenuItem1 = new JCheckBoxMenuItem();
        this.screenInterruptCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.setDefaultCloseOperation(3);
        this.setPreferredSize(new Dimension(1024, 768));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent evt) {
                AchtBitJFrame.this.formWindowClosed(evt);
            }
        });
        this.cpuPanel.setNextFocusableComponent(this.screenPanel);
        this.screenPanel.setNextFocusableComponent(this.assemblerPanel);
        this.screenPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                AchtBitJFrame.this.screenPanelMouseClicked(evt);
            }
        });
        this.screenPanel.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                AchtBitJFrame.this.screenPanelKeyTyped(evt);
            }

            @Override
            public void keyPressed(KeyEvent evt) {
                AchtBitJFrame.this.screenPanelKeyPressed(evt);
            }
        });
        GroupLayout screenPanelLayout = new GroupLayout(this.screenPanel);
        this.screenPanel.setLayout(screenPanelLayout);
        screenPanelLayout.setHorizontalGroup(screenPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 505, Short.MAX_VALUE));
        screenPanelLayout.setVerticalGroup(screenPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        this.fileMenu.setText("File");
        this.LoadMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.LoadMenuItem.setText("Load");
        this.LoadMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AchtBitJFrame.this.LoadMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.LoadMenuItem);
        this.SaveMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.SaveMenuItem.setText("Save");
        this.SaveMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AchtBitJFrame.this.SaveMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.SaveMenuItem);
        this.fileMenu.add(this.jSeparator1);
        this.QuitAchtBitMenuItem.setAccelerator(KeyStroke.getKeyStroke(81, 8));
        this.QuitAchtBitMenuItem.setText("Quit AchtBit");
        this.QuitAchtBitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AchtBitJFrame.this.QuitAchtBitMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.QuitAchtBitMenuItem);
        this.menuBar.add(this.fileMenu);
        this.viewMenu.setText("View");
        this.registerPanelCheckBoxMenuItem.setAccelerator(KeyStroke.getKeyStroke(113, 0));
        this.registerPanelCheckBoxMenuItem.setText("Register Panel");
        this.registerPanelCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AchtBitJFrame.this.registerPanelCheckBoxMenuItemActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.registerPanelCheckBoxMenuItem);
        this.assemblerPanelCheckBoxMenuItem.setAccelerator(KeyStroke.getKeyStroke(114, 0));
        this.assemblerPanelCheckBoxMenuItem.setText("Assembler Panel");
        this.assemblerPanelCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AchtBitJFrame.this.assemblerPanelCheckBoxMenuItemActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.assemblerPanelCheckBoxMenuItem);
        this.memoryPanelCheckBoxMenuItem.setAccelerator(KeyStroke.getKeyStroke(115, 0));
        this.memoryPanelCheckBoxMenuItem.setText("Memory Panel");
        this.memoryPanelCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AchtBitJFrame.this.memoryPanelCheckBoxMenuItemActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.memoryPanelCheckBoxMenuItem);
        this.cpuPanelCheckBoxMenuItem.setAccelerator(KeyStroke.getKeyStroke(116, 0));
        this.cpuPanelCheckBoxMenuItem.setText("Cpu Control Panel");
        this.cpuPanelCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AchtBitJFrame.this.cpuPanelCheckBoxMenuItemActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.cpuPanelCheckBoxMenuItem);
        this.fixedZoomCheckBoxMenuItem.setAccelerator(KeyStroke.getKeyStroke(117, 0));
        this.fixedZoomCheckBoxMenuItem.setText("Fixed Zoom");
        this.fixedZoomCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AchtBitJFrame.this.fixedZoomCheckBoxMenuItemActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.fixedZoomCheckBoxMenuItem);
        this.menuBar.add(this.viewMenu);
        this.jMenu1.setText("System");
        this.hardResetMenuItem.setAccelerator(KeyStroke.getKeyStroke(112, 2));
        this.hardResetMenuItem.setText("Hardware Reset");
        this.hardResetMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AchtBitJFrame.this.hardResetMenuItemActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.hardResetMenuItem);
        this.softResetMenuItem.setAccelerator(KeyStroke.getKeyStroke(112, 1));
        this.softResetMenuItem.setText("Soft Reset");
        this.softResetMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AchtBitJFrame.this.softResetMenuItemActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.softResetMenuItem);
        this.romAreaMenuItem.setText("ROM area");
        this.romAreaMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AchtBitJFrame.this.romAreaMenuItemActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.romAreaMenuItem);
        this.jCheckBoxMenuItem1.setAccelerator(KeyStroke.getKeyStroke(19, 0));
        this.jCheckBoxMenuItem1.setSelected(true);
        this.jCheckBoxMenuItem1.setText("Run Cpu");
        this.jCheckBoxMenuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AchtBitJFrame.this.jCheckBoxMenuItem1ActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jCheckBoxMenuItem1);
        this.screenInterruptCheckBoxMenuItem.setAccelerator(KeyStroke.getKeyStroke(120, 0));
        this.screenInterruptCheckBoxMenuItem.setSelected(true);
        this.screenInterruptCheckBoxMenuItem.setText("Enable Screen Interrupt");
        this.screenInterruptCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AchtBitJFrame.this.screenInterruptCheckBoxMenuItemActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.screenInterruptCheckBoxMenuItem);
        this.menuBar.add(this.jMenu1);
        this.setJMenuBar(this.menuBar);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.registerPanel, -2, -1, -2).addGap(0, 27, Short.MAX_VALUE)).addComponent(this.screenPanel, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.assemblerPanel, -2, 194, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.memoryPanel, -2, -1, -2)).addComponent(this.cpuPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.screenPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.registerPanel, -2, -1, -2)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.memoryPanel, -1, 415, Short.MAX_VALUE).addComponent(this.assemblerPanel, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cpuPanel, -2, 94, -2))).addContainerGap()));
        this.pack();
    }

    public static String getJarExecutionDirectory() {
        String jarFile = null;
        String jarDirectory = null;
        int cutFileSeperator = 0;
        int cutSemicolon = -1;
        jarFile = System.getProperty("java.class.path");
        cutFileSeperator = jarFile.lastIndexOf(System.getProperty("file.separator"));
        jarDirectory = cutFileSeperator > 0 ? jarFile.substring(0, cutFileSeperator) : ".";
        cutSemicolon = jarDirectory.lastIndexOf(59);
        jarDirectory = jarDirectory.substring(cutSemicolon + 1, jarDirectory.length());
        return jarDirectory + System.getProperty("file.separator");
    }

    private void registerPanelCheckBoxMenuItemActionPerformed(ActionEvent evt) {
        if (this.registerPanelCheckBoxMenuItem.getState() != this.registerPanel.isVisible()) {
            this.registerPanel.setVisible(this.registerPanelCheckBoxMenuItem.getState());
        }
    }

    private void assemblerPanelCheckBoxMenuItemActionPerformed(ActionEvent evt) {
        if (this.assemblerPanelCheckBoxMenuItem.getState() != this.assemblerPanel.isVisible()) {
            this.assemblerPanel.setVisible(this.assemblerPanelCheckBoxMenuItem.getState());
        }
    }

    private void memoryPanelCheckBoxMenuItemActionPerformed(ActionEvent evt) {
        if (this.memoryPanelCheckBoxMenuItem.getState() != this.memoryPanel.isVisible()) {
            this.memoryPanel.setVisible(this.memoryPanelCheckBoxMenuItem.getState());
        }
    }

    private void cpuPanelCheckBoxMenuItemActionPerformed(ActionEvent evt) {
        if (this.cpuPanelCheckBoxMenuItem.getState() != this.cpuPanel.isVisible()) {
            this.cpuPanel.setVisible(this.cpuPanelCheckBoxMenuItem.getState());
        }
    }

    private void LoadMenuItemActionPerformed(ActionEvent evt) {
        JFileChooser fc = new JFileChooser();
        FileNameExtensionFilter f = new FileNameExtensionFilter("Memory dumps (.txt), assembler (.asm)", "txt", "asm");
        fc.setFileFilter(f);
        fc.setSelectedFile(new File(SaveMemDialog.lastFileName.equals("") ? "memdump.txt" : SaveMemDialog.lastFileName));
        int returnVal = fc.showOpenDialog(this);
        if (returnVal == 1) {
            return;
        }
        SaveMemDialog.lastFileName = fc.getSelectedFile().getAbsolutePath();
        CpuState.instance().halt();
        if (SaveMemDialog.lastFileName.endsWith(".txt")) {
            Memory.instance().loadFromFile(SaveMemDialog.lastFileName);
        } else {
            try {
                Memory.instance().loadFromAssembler(SaveMemDialog.lastFileName);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, e.getMessage());
            }
        }
        this.cpuPanel.setStartAdress(Memory.instance().getPC());
        CpuState.instance().run();
    }

    private void QuitAchtBitMenuItemActionPerformed(ActionEvent evt) {
        this.cpuPanel.stopCpuThread();
        SoundThread.instance().kill();
        System.exit(0);
    }

    private void SaveMenuItemActionPerformed(ActionEvent evt) {
        SaveMemDialog dialog = new SaveMemDialog((Frame)this, true);
        dialog.setVisible(true);
    }

    private void screenInterruptCheckBoxMenuItemActionPerformed(ActionEvent evt) {
        Cpu.screenInterrupt = this.screenInterruptCheckBoxMenuItem.isSelected();
    }

    private void screenPanelKeyTyped(KeyEvent evt) {
    }

    private void hardResetMenuItemActionPerformed(ActionEvent evt) {
        this.cpuPanel.haltCpu();
        Memory.instance().reset();
        this.screenPanel.resetPalette();
        this.screenPanel.reset();
        this.cpuPanel.setStartAdress(Memory.instance().getPC());
        this.cpuPanel.runCpu();
    }

    private void softResetMenuItemActionPerformed(ActionEvent evt) {
        this.cpuPanel.haltCpu();
        Memory.instance().resetRegisters();
        this.screenPanel.reset();
        this.cpuPanel.setStartAdress(Memory.instance().getPC());
        this.cpuPanel.runCpu();
    }

    private void romAreaMenuItemActionPerformed(ActionEvent evt) {
        RomAreaDialog dialog = new RomAreaDialog((Frame)this, true);
        dialog.setVisible(true);
    }

    private void formWindowClosed(WindowEvent evt) {
    }

    @Override
    public void update(Observable o, Object o1) {
        if (!(o instanceof CpuState)) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        this.jCheckBoxMenuItem1.setSelected(CpuState.instance().isRunning());
        if (!CpuState.instance().isRunning()) {
            this.cpuPanel.setStartAdress(Memory.instance().getPC());
        }
    }

    private void jCheckBoxMenuItem1ActionPerformed(ActionEvent evt) {
        if (this.jCheckBoxMenuItem1.isSelected()) {
            CpuState.instance().run();
        } else {
            CpuState.instance().halt();
        }
    }

    private void fixedZoomCheckBoxMenuItemActionPerformed(ActionEvent evt) {
        this.screenPanel.setFixedZoom(this.fixedZoomCheckBoxMenuItem.getState());
    }

    private void screenPanelKeyPressed(KeyEvent evt) {
        if (CpuState.instance().isRunning()) {
            Keyboard.instance().keyPressed(evt);
        }
    }

    private void screenPanelMouseClicked(MouseEvent evt) {
        this.screenPanel.grabFocus();
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(AchtBitJFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(AchtBitJFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(AchtBitJFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(AchtBitJFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        AchtBitJFrame frame = new AchtBitJFrame();
        frame.setVisible(true);
    }
}

