/*
 * Decompiled with CFR 0.152.
 */
package achtbit;

import achtbit.Assembler;
import achtbit.CpuState;
import achtbit.Keyboard;
import achtbit.Memory;
import achtbit.Sound;
import achtbit.Storage;

public class Command {
    static final int com_nop = 0;
    static final int com_hlt = 1;
    static final int com_clc = 2;
    static final int com_reti = 3;
    static final int com_setc = 4;
    static final int com_ld = 8;
    static final int com_add = 16;
    static final int com_adc = 20;
    static final int com_sub = 24;
    static final int com_sbc = 28;
    static final int com_mul = 32;
    static final int com_div = 36;
    static final int com_and = 40;
    static final int com_or = 44;
    static final int com_xor = 48;
    static final int com_cmp = 52;
    static final int com_mod = 56;
    static final int com_jp = 64;
    static final int com_call = 72;
    static final int com_jr = 80;
    static final int com_ret = 88;
    static final int com_push = 96;
    static final int com_pop = 112;
    static final int com_shl = 128;
    static final int com_shr = 144;
    static final int com_rhl = 160;
    static final int com_rhr = 176;
    static final int com_inc = 192;
    static final int com_dec = 208;
    static final int com_in = 224;
    static final int com_out = 240;
    private int com;
    private Storage storage;
    private int adress;

    public Command(int adress, int com) {
        this.adress = adress;
        this.com = com;
        this.storage = new Storage(0, 0, 0);
    }

    public Command(int adress, int com, Storage storage) {
        this.adress = adress;
        this.com = com;
        this.storage = storage;
    }

    public Command() {
        this.adress = Memory.instance().getPC();
        this.init();
    }

    public Command(int adress) {
        this.adress = new Integer(adress);
        this.init();
    }

    public void init() {
        Memory mem = Memory.instance();
        this.com = mem.getByte(this.adress);
        ++this.adress;
        this.storage = null;
        if (this.com != 0 && this.com != 1 && this.com != 2 && this.com != 3) {
            if ((this.com & 0xF8) == 8) {
                this.storage = new Storage();
                this.adress = this.storage.init(this.com & 7, this.adress);
                this.com &= 0xF8;
            } else if (this.com >= 16 && this.com < 60) {
                this.storage = new Storage();
                this.adress = this.storage.init(this.com & 3, this.adress);
                this.com &= 0xFC;
            } else if (this.com >= 64 && this.com <= 96) {
                int flags = this.com & 7;
                this.com &= 0xF8;
                switch (this.com) {
                    case 64: 
                    case 72: {
                        this.storage = new Storage(1, mem.getWord(this.adress));
                        this.adress += 2;
                        this.storage.setFlags(flags);
                        break;
                    }
                    case 80: {
                        this.storage = new Storage(1, mem.getByte(this.adress));
                        ++this.adress;
                        this.storage.setFlags(flags);
                        break;
                    }
                    case 88: {
                        this.storage = new Storage(0, 0);
                        this.storage.setFlags(flags);
                    }
                }
            } else if (this.com >= 96 && this.com < 224) {
                int reg = this.com & 0xF;
                this.com &= 0xF0;
                this.storage = new Storage(0, reg);
            } else if ((this.com & 0xF0) == 224) {
                int reg = this.com & 0xF;
                this.com &= 0xF0;
                this.storage = new Storage(3, reg, mem.getByte(this.adress));
                ++this.adress;
            } else if ((this.com & 0xF0) == 240) {
                int reg = this.com & 0xF;
                this.com &= 0xF0;
                this.storage = new Storage(5, mem.getByte(this.adress), reg);
                ++this.adress;
            }
        }
    }

    public int getAdress() {
        return this.adress;
    }

    public void setAdress(int adress) {
        this.adress = adress;
    }

    public Storage getStorage() {
        return this.storage;
    }

    public int getCom() {
        return this.com;
    }

    public void run() {
        Memory mem = Memory.instance();
        mem.setPC(this.adress);
        block0 : switch (this.com) {
            case 0: {
                break;
            }
            case 1: {
                CpuState.instance().halt();
                break;
            }
            case 2: {
                mem.setCFlag(false);
                break;
            }
            case 4: {
                mem.setCFlag(true);
                break;
            }
            case 3: {
                mem.setEnableInterrupt(true);
                mem.setPC(mem.popWord());
                break;
            }
            case 8: {
                this.storage.set(this.storage.get());
                break;
            }
            case 16: {
                int u = this.storage.getDestinationValue();
                int v = u + this.storage.get();
                this.storage.set(v);
                this.storage.checkAndSetFlags(v);
                break;
            }
            case 20: {
                int u = this.storage.getDestinationValue();
                int v = this.storage.get();
                if (Memory.instance().hasCFlag()) {
                    ++v;
                }
                this.storage.set(v += u);
                this.storage.checkAndSetFlags(v);
                break;
            }
            case 24: {
                int u = this.storage.getDestinationValue();
                int v = u - this.storage.get();
                this.storage.set(v);
                this.storage.checkAndSetFlags(v);
                break;
            }
            case 28: {
                int u = this.storage.getDestinationValue();
                int v = u - this.storage.get();
                if (Memory.instance().hasCFlag()) {
                    this.storage.dec(v);
                }
                this.storage.set(v);
                this.storage.checkAndSetFlags(v);
                break;
            }
            case 32: {
                int u = this.storage.getDestinationValue();
                int v = u * this.storage.get();
                this.storage.set(v);
                this.storage.checkAndSetFlags(v);
                break;
            }
            case 36: {
                int u = this.storage.getDestinationValue();
                int v = this.storage.get();
                if (v == 0) break;
                this.storage.set(u /= v);
                this.storage.checkAndSetFlags(u);
                break;
            }
            case 40: {
                int u = this.storage.getDestinationValue();
                int v = u & this.storage.get();
                this.storage.set(v);
                this.storage.checkAndSetFlags(v);
                break;
            }
            case 44: {
                int u = this.storage.getDestinationValue();
                int v = u | this.storage.get();
                this.storage.set(v);
                this.storage.checkAndSetFlags(v);
                break;
            }
            case 48: {
                int u = this.storage.getDestinationValue();
                int v = u ^ this.storage.get();
                this.storage.set(v);
                this.storage.checkAndSetFlags(v);
                break;
            }
            case 52: {
                int u = this.storage.getDestinationValue();
                int v = u - this.storage.get();
                this.storage.checkAndSetFlags(v);
                break;
            }
            case 56: {
                int u = this.storage.getDestinationValue();
                int v = u % this.storage.get();
                this.storage.set(v);
                this.storage.checkAndSetFlags(v);
                break;
            }
            case 64: {
                if (!this.storage.tryFlags()) break;
                mem.setPC(this.storage.get());
                break;
            }
            case 72: {
                if (!this.storage.tryFlags()) break;
                mem.pushWord(mem.getPC());
                mem.setPC(this.storage.get());
                break;
            }
            case 80: {
                if (!this.storage.tryFlags()) break;
                int n = this.storage.get();
                if (n > 127) {
                    n -= 256;
                }
                mem.setPC(mem.getPC() + n);
                break;
            }
            case 88: {
                if (!this.storage.tryFlags()) break;
                mem.setPC(mem.popWord());
                break;
            }
            case 96: {
                if (this.storage.isByte()) {
                    mem.pushByte(this.storage.get());
                    break;
                }
                mem.pushWord(this.storage.get());
                break;
            }
            case 112: {
                if (this.storage.isByte()) {
                    this.storage.set(mem.popByte());
                    break;
                }
                this.storage.set(mem.popWord());
                break;
            }
            case 128: {
                int u = this.storage.get();
                this.storage.set(u << 1);
                mem.setFlag(2, (u & 0x80) > 0);
                break;
            }
            case 144: {
                int u = this.storage.get();
                this.storage.set(u >> 1);
                mem.setFlag(2, (u & 1) > 0);
                break;
            }
            case 160: {
                int v = this.storage.get() << 1;
                if (mem.hasCFlag()) {
                    ++v;
                }
                this.storage.set(v);
                this.storage.checkAndSetFlags(v);
                break;
            }
            case 176: {
                int u = this.storage.get();
                int v = u >> 1;
                if (mem.hasCFlag()) {
                    v += 128;
                }
                this.storage.set(v);
                mem.setFlag(2, u % 1 > 0);
                this.storage.checkAndSetFlags(v);
                break;
            }
            case 192: {
                int v = this.storage.get() + 1;
                this.storage.set(v);
                this.storage.checkAndSetFlags(v);
                break;
            }
            case 208: {
                int v = this.storage.dec(this.storage.get());
                this.storage.set(v);
                this.storage.checkAndSetFlags(v);
                break;
            }
            case 224: {
                int v;
                int u = this.storage.getSource();
                switch (u) {
                    case 0: {
                        v = Keyboard.instance().getKey();
                        this.storage.set(v);
                        break;
                    }
                    case 1: {
                        v = (int)(Math.random() * 256.0);
                        this.storage.set(v);
                        break;
                    }
                    case 2: {
                        v = Sound.getLoudness();
                        this.storage.set(v);
                        break;
                    }
                    case 3: {
                        v = Sound.getLength();
                        this.storage.set(v);
                        break;
                    }
                    case 4: {
                        v = Sound.getLengthUnit();
                        this.storage.set(v);
                        break;
                    }
                    case 5: {
                        v = Sound.isFinished() ? 1 : 0;
                        this.storage.set(v);
                        break;
                    }
                    case 6: {
                        v = Sound.getBpm();
                        this.storage.set(v);
                        break;
                    }
                }
            }
            case 240: {
                int u = this.storage.get();
                int v = this.storage.getDestination();
                switch (v) {
                    case 0: {
                        if (u != 255) break block0;
                        Keyboard.instance().clear();
                        break block0;
                    }
                    case 2: {
                        Sound.setLoudness(u);
                        break block0;
                    }
                    case 3: {
                        Sound.setLength(u);
                        break block0;
                    }
                    case 4: {
                        Sound.setLengthUnit(u);
                        break block0;
                    }
                    case 5: {
                        if (u == 0) {
                            Sound.clearQueue();
                            break block0;
                        }
                        Sound.play(u);
                        break block0;
                    }
                    case 6: {
                        Sound.setBpm(u);
                        break block0;
                    }
                }
                break;
            }
        }
    }

    public String toString() {
        String e = "";
        e = e + "com = " + Assembler.int2hex(this.com, 2) + " ";
        if (this.storage != null) {
            e = e + this.storage.toString();
        }
        return e;
    }

    public static void main(String[] args) {
        Memory mem = Memory.instance();
        mem.setByte(0, 9);
        mem.setByte(1, 11);
        mem.setWord(2, 30721);
        mem.setByte(4, 11);
        mem.setByte(5, 27);
        mem.setByte(6, 193);
        mem.setByte(7, 13);
        mem.setByte(8, 177);
        mem.setByte(9, 64);
        mem.setWord(10, 4);
        System.out.println(mem.regsString());
        for (int i = 0; i < 10; ++i) {
            Command c = new Command();
            c.run();
            System.out.println(c);
            System.out.println(mem.regsString());
            System.out.println("(7801)=" + Assembler.int2hex(mem.getByte(30721), 2));
        }
    }
}

