/*
 * Decompiled with CFR 0.152.
 */
package achtbit;

import achtbit.Command;
import achtbit.CpuState;
import achtbit.Memory;
import java.util.TimerTask;

public class Cpu
extends TimerTask {
    public static int cpuTakt = 1000;
    public static boolean screenInterrupt = true;
    private int countScreenRefresh = 20;
    private int timeRefresh = 10;
    private long timeLastMilliseconds;
    private long timeRemainingMilliseconds = 0L;
    private int[] days = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

    public Cpu() {
        this.timeLastMilliseconds = System.currentTimeMillis();
    }

    public void timeTick() {
        Memory mem = Memory.instance();
        int sec = mem.getByte(65405) + 1;
        if (sec > 59) {
            sec = 0;
            int min = mem.getByte(65406) + 1;
            if (min > 59) {
                min = 0;
                int hour = mem.getByte(65407) + 1;
                if (hour > 23) {
                    hour = 0;
                    int day = mem.getByte(65408);
                    int month = mem.getByte(65409);
                    int year = mem.getWord(65410);
                    ++day;
                    int maxDays = this.days[(month - 1) % 12];
                    if (month == 2 && year % 4 == 0) {
                        ++maxDays;
                    }
                    if (day > maxDays) {
                        day = 1;
                        if (++month > 12) {
                            month = 1;
                            ++year;
                        }
                    }
                    mem.setByte(65408, day);
                    mem.setByte(65409, month);
                    mem.setWord(65410, year);
                }
                mem.setByte(65407, hour);
            }
            mem.setByte(65406, min);
        }
        mem.setByte(65405, sec);
    }

    @Override
    public void run() {
        if (CpuState.instance().isRunning()) {
            --this.timeRefresh;
            if (this.timeRefresh == 0) {
                this.timeRefresh = 10;
                long t = System.currentTimeMillis();
                this.timeRemainingMilliseconds += t - this.timeLastMilliseconds;
                this.timeLastMilliseconds = t;
                while (this.timeRemainingMilliseconds > 1000L) {
                    this.timeRemainingMilliseconds -= 1000L;
                    this.timeTick();
                }
            }
            for (int i = 0; CpuState.instance().isRunning() && i < cpuTakt; ++i) {
                try {
                    Command command = new Command();
                    command.run();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (CpuState.instance().getState() != CpuState.State.cpuStep) continue;
                CpuState.instance().halt();
            }
        }
        --this.countScreenRefresh;
        if (this.countScreenRefresh == 0) {
            this.countScreenRefresh = 20;
            Memory.instance().setByte(65394, 1);
            if (CpuState.instance().isRunning() && screenInterrupt && Memory.instance().isEnableInterrupt()) {
                Memory.instance().pushWord(Memory.instance().getPC());
                Memory.instance().setPC(65395);
                Memory.instance().setEnableInterrupt(false);
            }
        }
    }
}

