/*
 * Decompiled with CFR 0.152.
 */
package achtbit;

import achtbit.Assembler;
import achtbit.Bereich;
import achtbit.CpuState;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.List;
import java.util.Observable;

public final class Memory
extends Observable {
    private int[] ram = new int[65536];
    private int[] registers = new int[11];
    private int registerPc;
    private boolean enableInterrupt;
    private int beginRom;
    private int endRom;
    private static Memory uniqueInstance = null;
    static final int regF = 0;
    static final int regA = 1;
    static final int regC = 2;
    static final int regB = 3;
    static final int regE = 4;
    static final int regD = 5;
    static final int regL = 6;
    static final int regH = 7;
    static final int regSpL = 8;
    static final int regSpH = 9;
    static final int regAF = 10;
    static final int regBC = 11;
    static final int regDE = 12;
    static final int regHL = 13;
    static final int regSP = 14;
    static final int regIX = 15;
    static final int regPc = 16;
    static final int noFlag = 0;
    static final int flagZ = 1;
    static final int flagC = 2;
    static final int flagP = 3;
    static final int flagNZ = 5;
    static final int flagNC = 6;
    static final int flagNP = 7;

    private Memory() {
        this.reset();
    }

    public void reset() {
        this.resetMemory();
        this.resetRegisters();
    }

    public void resetMemory() {
        int a = 0;
        for (int i = 0; i < 128; ++i) {
            int j;
            for (j = 0; j < 256; ++j) {
                this.ram[a++] = 0;
            }
            for (j = 0; j < 256; ++j) {
                this.ram[a++] = 255;
            }
        }
        this.beginRom = 0;
        this.endRom = 16383;
    }

    public void resetRegisters() {
        this.setAF(0);
        this.setBC(0);
        this.setDE(0);
        this.setHL(0);
        this.setPC(0);
        this.setIX(0);
        this.setSP(53760);
        this.setByte(65395, 3);
        this.setEnableInterrupt(true);
    }

    public static Memory instance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Memory();
        }
        return uniqueInstance;
    }

    public boolean isEnableInterrupt() {
        return this.enableInterrupt;
    }

    public void setEnableInterrupt(boolean enableInterrupt) {
        this.enableInterrupt = enableInterrupt;
    }

    public int getBeginRom() {
        return this.beginRom;
    }

    public void setBeginRom(int beginRom) {
        if (beginRom > this.endRom) {
            this.beginRom = -1;
            this.endRom = -1;
        } else {
            this.beginRom = beginRom;
        }
    }

    public int getEndRom() {
        return this.endRom;
    }

    public void setEndRom(int endRom) {
        if (endRom < this.beginRom) {
            this.beginRom = -1;
            this.endRom = -1;
        } else {
            this.endRom = endRom;
        }
    }

    public int getReg(int reg) {
        if (reg < 0) {
            throw new IllegalArgumentException("reg id " + reg + " is not allowed.");
        }
        if (reg == 15) {
            return this.registers[10];
        }
        if (reg >= 10) {
            int l = (reg - 10) * 2;
            int h = (reg - 10) * 2 + 1;
            return this.getReg(l, h);
        }
        return this.registers[reg];
    }

    public int getReg(int regL, int regH) {
        if (regL < 0 || regL >= this.registers.length) {
            throw new IllegalArgumentException("regL id " + regL + " is not allowed.");
        }
        if (regH < 0 || regH >= this.registers.length) {
            throw new IllegalArgumentException("regH id " + regH + " is not allowed.");
        }
        return this.registers[regL] + 256 * this.registers[regH];
    }

    public void setReg(int reg, int value) {
        if (reg < 0) {
            throw new IllegalArgumentException("reg id " + reg + " is not allowed.");
        }
        if (reg == 15) {
            this.registers[10] = value &= 0xFFFF;
            this.setChanged();
            this.notifyObservers(new Integer(-(reg + 1)));
            return;
        }
        if (reg >= 10) {
            int l = (reg - 10) * 2;
            int h = (reg - 10) * 2 + 1;
            this.setReg(l, h, value);
            this.setChanged();
            this.notifyObservers(new Integer(-(reg + 1)));
            return;
        }
        this.registers[reg] = value &= 0xFF;
        this.setChanged();
        this.notifyObservers(new Integer(-(reg + 1)));
    }

    public synchronized void setReg(int regL, int regH, int value) {
        if (regL < 0 || regL >= this.registers.length) {
            throw new IllegalArgumentException("regL id " + regL + " is not allowed.");
        }
        if (regH < 0 || regH >= this.registers.length) {
            throw new IllegalArgumentException("regH id " + regH + " is not allowed.");
        }
        this.registers[regL] = (value &= 0xFFFF) & 0xFF;
        this.registers[regH] = value / 256;
    }

    public int getByte(int adress) {
        return this.ram[adress &= 0xFFFF];
    }

    public int getWord(int adress) {
        int wL = this.ram[adress &= 0xFFFF];
        adress = adress + 1 & 0xFFFF;
        return wL + this.ram[adress] * 256;
    }

    public void setByte(int adress, int value) {
        this.setByte(adress, value, false);
    }

    public void setByte(int adress, int value, boolean readWrite) {
        this.setByte(adress, value, readWrite, true);
    }

    public synchronized void setByte(int adress, int value, boolean readWrite, boolean notify) {
        if (!readWrite && (adress &= 0xFFFF) >= this.beginRom && adress <= this.endRom) {
            return;
        }
        this.ram[adress] = value &= 0xFF;
        if (!notify) {
            return;
        }
        this.setChanged();
        this.notifyObservers(new Integer(adress));
    }

    public void setWord(int adress, int value) {
        this.setWord(adress, value, false);
    }

    public void setWord(int adress, int value, boolean readWrite) {
        this.setWord(adress, value, readWrite, true);
    }

    public synchronized void setWord(int adress, int value, boolean readWrite, boolean notify) {
        if (!readWrite && (adress &= 0xFFFF) >= this.beginRom && adress <= this.endRom) {
            return;
        }
        this.ram[adress] = (value &= 0xFFFF) & 0xFF;
        int adr = adress + 1 & 0xFFFF;
        this.ram[adr] = value / 256;
        if (!notify) {
            return;
        }
        this.setChanged();
        this.notifyObservers(new Integer(adr));
        this.setChanged();
        this.notifyObservers(new Integer(adr));
    }

    public boolean hasFlag(int flag) {
        int f = flag & 3;
        if (f == 0) {
            return true;
        }
        int m = 1;
        while (--f > 0) {
            m *= 2;
        }
        if (flag < 4) {
            return (this.getF() & m) > 0;
        }
        return (this.getF() & m) == 0;
    }

    public synchronized void setFlag(int flag, boolean b) {
        int f = flag & 3;
        if (f == 0) {
            return;
        }
        int m = 1;
        while (--f > 0) {
            m *= 2;
        }
        if (flag < 4 ^ b) {
            this.setReg(0, this.getF() & 255 - m);
        } else {
            this.setReg(0, this.getF() | m);
        }
    }

    public synchronized void pushByte(int b) {
        this.setSP(this.getSP() - 1);
        this.setByte(this.getSP(), b);
    }

    public synchronized void pushWord(int w) {
        this.setSP(this.getSP() - 2);
        this.setWord(this.getSP(), w);
    }

    public synchronized int popByte() {
        int b = this.getByte(this.getSP());
        this.setSP(this.getSP() + 1);
        return b;
    }

    public synchronized int popWord() {
        int w = this.getWord(this.getSP());
        this.setSP(this.getSP() + 2);
        return w;
    }

    public int getA() {
        return this.getReg(1);
    }

    public int getF() {
        return this.getReg(0);
    }

    public int getB() {
        return this.getReg(3);
    }

    public int getC() {
        return this.getReg(2);
    }

    public int getD() {
        return this.getReg(5);
    }

    public int getE() {
        return this.getReg(4);
    }

    public int getH() {
        return this.getReg(7);
    }

    public int getL() {
        return this.getReg(6);
    }

    public int getAF() {
        return this.getReg(0, 1);
    }

    public int getBC() {
        return this.getReg(2, 3);
    }

    public int getDE() {
        return this.getReg(4, 5);
    }

    public int getHL() {
        return this.getReg(6, 7);
    }

    public int getSP() {
        return this.getReg(8, 9);
    }

    public int getIX() {
        return this.getReg(15);
    }

    public int getPC() {
        return this.registerPc;
    }

    public void setA(int value) {
        this.setReg(1, value);
    }

    public void setF(int value) {
        this.setReg(0, value);
    }

    public void setB(int value) {
        this.setReg(3, value);
    }

    public void setC(int value) {
        this.setReg(2, value);
    }

    public void setD(int value) {
        this.setReg(5, value);
    }

    public void setE(int value) {
        this.setReg(4, value);
    }

    public void setH(int value) {
        this.setReg(7, value);
    }

    public void setL(int value) {
        this.setReg(6, value);
    }

    public void setAF(int value) {
        this.setReg(0, 1, value);
    }

    public void setBC(int value) {
        this.setReg(2, 3, value);
    }

    public void setDE(int value) {
        this.setReg(4, 5, value);
    }

    public void setHL(int value) {
        this.setReg(6, 7, value);
    }

    public void setSP(int value) {
        this.setReg(8, 9, value);
    }

    public void setIX(int value) {
        this.setReg(15, value);
    }

    public synchronized void setPC(int value) {
        this.registerPc = value & 0xFFFF;
        this.setChanged();
        this.notifyObservers(new Integer(-(16 + 1)));
    }

    public boolean hasZFlag() {
        return this.hasFlag(1);
    }

    public boolean hasNZFlag() {
        return this.hasFlag(5);
    }

    public boolean hasCFlag() {
        return this.hasFlag(2);
    }

    public boolean hasNCFlag() {
        return this.hasFlag(6);
    }

    public boolean hasPFlag() {
        return this.hasFlag(3);
    }

    public boolean hasNPFlag() {
        return this.hasFlag(7);
    }

    public void setZFlag(boolean b) {
        this.setFlag(1, b);
    }

    public void setNZFlag(boolean b) {
        this.setFlag(5, b);
    }

    public void setCFlag(boolean b) {
        this.setFlag(2, b);
    }

    public void setNCFlag(boolean b) {
        this.setFlag(6, b);
    }

    public void setPFlag(boolean b) {
        this.setFlag(3, b);
    }

    public void setNPFlag(boolean b) {
        this.setFlag(7, b);
    }

    public String regsString() {
        String e = "AF   BC   DE   HL   PC   SP   F\n";
        e = e + Assembler.int2hex(this.getAF(), 4) + " ";
        e = e + Assembler.int2hex(this.getBC(), 4) + " ";
        e = e + Assembler.int2hex(this.getDE(), 4) + " ";
        e = e + Assembler.int2hex(this.getHL(), 4) + " ";
        e = e + Assembler.int2hex(this.getPC(), 4) + " ";
        e = e + Assembler.int2hex(this.getSP(), 4) + " ";
        e = e + this.flagString();
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveToAssembler(String filename, int start, List<Bereich> bereiche) {
        boolean running = CpuState.instance().isRunning();
        if (running) {
            CpuState.instance().halt();
        }
        boolean success = true;
        FileWriter fw = null;
        try {
            fw = new FileWriter(filename);
            fw.write(".run " + Assembler.int2hex(start, 4) + "\n");
            Assembler assembler = new Assembler();
            for (Bereich bereich : bereiche) {
                int a0 = bereich.getStart();
                int a1 = bereich.getEnd();
                assembler.setAdress(a0);
                fw.write(".org " + Assembler.int2hex(a0, 4) + "\n");
                while (assembler.getAdress() <= a1) {
                    fw.append(Assembler.int2hex(assembler.getAdress(), 4) + ". " + assembler.dasm() + "\n");
                }
            }
        }
        catch (IOException e) {
            success = false;
        }
        finally {
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (IOException e) {
                    success = false;
                }
            }
        }
        if (running) {
            CpuState.instance().run();
        }
        return success;
    }

    public boolean saveToFile(String filename, int start, List<Bereich> bereiche) {
        return this.saveToFile(filename, start, bereiche, 16);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveToFile(String filename, int start, List<Bereich> bereiche, int width) {
        boolean running = CpuState.instance().isRunning();
        if (running) {
            CpuState.instance().halt();
        }
        boolean success = true;
        Assembler asm = new Assembler();
        FileWriter fw = null;
        try {
            fw = new FileWriter(filename);
            fw.write(".run 0x" + Assembler.int2hex(start, 4) + "\n");
            for (Bereich bereich : bereiche) {
                int a0 = bereich.getStart();
                int a1 = bereich.getEnd();
                fw.write(".org 0x" + Assembler.int2hex(a0, 4) + "\n");
                fw.append(asm.dasmDef(a0, bereich.getDefType(), width, false));
                while (asm.getAdress() < a1) {
                    fw.append(asm.dasmDef(bereich.getDefType(), width, false));
                }
            }
        }
        catch (IOException e) {
            success = false;
        }
        finally {
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (IOException e) {
                    success = false;
                }
            }
        }
        if (running) {
            CpuState.instance().run();
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadFromFile(String filename) {
        boolean running = CpuState.instance().isRunning();
        if (running) {
            CpuState.instance().halt();
        }
        FileReader reader = null;
        boolean success = true;
        int progstart = 0;
        int start = 0;
        try {
            reader = new FileReader(filename);
            int c = ((Reader)reader).read();
            while (c >= 0) {
                while (c >= 0 && (c == 32 || c == 10 || c == 9)) {
                    c = ((Reader)reader).read();
                }
                if (c < 0) continue;
                String s = "";
                while (c >= 0 && c != 32 && c != 10 && c != 9) {
                    s = s + (char)c;
                    c = ((Reader)reader).read();
                }
                if (s.isEmpty()) continue;
                if (s.startsWith("!")) {
                    start = progstart = Assembler.hex2int(s.substring(1));
                    continue;
                }
                if (s.endsWith(":")) {
                    start = Assembler.hex2int(s.substring(0, s.length() - 1));
                    continue;
                }
                Memory.instance().setByte(start, Assembler.hex2int(s), true);
                ++start;
            }
        }
        catch (IOException e) {
            success = false;
        }
        finally {
            try {
                ((Reader)reader).close();
            }
            catch (Exception e) {
                success = false;
            }
        }
        this.setPC(progstart);
        if (running) {
            CpuState.instance().run();
        }
        return success;
    }

    public boolean loadFromAssembler(String filename) {
        return this.loadFromAssembler(new File(filename), true);
    }

    public boolean loadFromAssembler(File file) {
        return this.loadFromAssembler(file, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadFromAssembler(File file, boolean writeLabelToFile) {
        boolean success;
        boolean running = CpuState.instance().isRunning();
        if (running) {
            CpuState.instance().halt();
        }
        String filename = file.getAbsolutePath();
        Assembler asm = new Assembler();
        boolean bl = success = this.includeFromAssembler(file, writeLabelToFile, asm, 0) >= 0;
        if (success) {
            OutputStreamWriter writer = null;
            try {
                asm.resolveLabels();
                this.setPC(asm.getAdress());
                if (writeLabelToFile) {
                    String newName = filename.substring(0, filename.length() - 4) + "_label.asm";
                    writer = new FileWriter(newName);
                    writer.write(asm.labels2string());
                }
            }
            catch (IOException e) {
                success = false;
            }
            finally {
                try {
                    if (writeLabelToFile) {
                        writer.close();
                    }
                }
                catch (Exception e) {
                    success = false;
                }
            }
        }
        if (running) {
            CpuState.instance().run();
        }
        return success;
    }

    public int includeFromAssembler(File file, boolean writeLabelToFile, Assembler asm, int adr) {
        String filename = file.getAbsolutePath();
        FileReader reader = null;
        int line = 1;
        try {
            reader = new FileReader(file);
            int c = ((Reader)reader).read();
            while (c >= 0) {
                while (c >= 0 && c == 10) {
                    ++line;
                    c = ((Reader)reader).read();
                }
                String s = "";
                while (c >= 0 && c != 10) {
                    s = s + (char)c;
                    c = ((Reader)reader).read();
                }
                if ((s = s.trim()).isEmpty()) continue;
                if (s.startsWith(".import") || s.startsWith(".include")) {
                    String[] p = s.split("[\t ,]+");
                    if (p.length < 2) {
                        throw new IllegalArgumentException("usage is: '" + p[0] + " filename'");
                    }
                    p[1] = p[0].equals(".import") ? p[1] + "_label.asm" : p[1] + ".asm";
                    p[1] = filename.substring(0, filename.lastIndexOf(File.separatorChar) + 1) + p[1];
                    if ((adr = this.includeFromAssembler(new File(p[1]), false, asm, adr)) >= 0) continue;
                    throw new IllegalArgumentException(p[0] + ": file '" + p[1] + "' not found.");
                }
                adr = asm.asm(s, adr);
            }
        }
        catch (IOException e) {
            adr = -1;
        }
        catch (IllegalArgumentException e) {
            int i = filename.lastIndexOf(File.separatorChar) + 1;
            throw new IllegalArgumentException("Error in \"" + filename.substring(i) + "\", line " + line + ":\n" + e.getMessage());
        }
        finally {
            try {
                ((Reader)reader).close();
            }
            catch (Exception e) {
                adr = -1;
            }
        }
        return adr;
    }

    public static void main(String[] args) {
    }

    public String flagString() {
        String e = "00000" + (this.hasPFlag() ? "P" : "0") + (this.hasCFlag() ? "C" : "0") + (this.hasZFlag() ? "Z " : "0");
        return e;
    }
}

